/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.Utils;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapSingleLayerTableDefinition;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.TableDataDefinition;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MapMoreLayerTableDefinition
extends TableDataDefinition {
    public static final String XML_TAG = "MapMoreLayerTableDefinition";
    private static final long serialVersionUID = 3389355131090619354L;
    private List nameValueList = new ArrayList();

    public ChartData createChartData(DataModel dataModel, DataProcessor dataProcessor) {
        MapChartData mapChartData = new MapChartData();
        mapChartData.clearAllMap();
        for (int i = 0; i < this.nameValueList.size(); ++i) {
            MapSingleLayerTableDefinition mapSingleLayerTableDefinition = (MapSingleLayerTableDefinition)this.nameValueList.get(i);
            if (mapSingleLayerTableDefinition == null) continue;
            mapSingleLayerTableDefinition.createMapDataWithLayerIndex(mapChartData, dataModel);
        }
        mapChartData.setHasLayerTo(true);
        return mapChartData;
    }

    public JSONObject createDataConfig() throws JSONException {
        JSONObject jSONObject = super.createDataConfig();
        if (this.nameValueList != null) {
            JSONArray jSONArray = new JSONArray();
            int n = this.nameValueList.size();
            for (int i = 0; i < n; ++i) {
                MapSingleLayerTableDefinition mapSingleLayerTableDefinition = (MapSingleLayerTableDefinition)this.nameValueList.get(i);
                jSONArray.put((Object)mapSingleLayerTableDefinition.createDataConfig());
            }
            jSONObject.put("layers", (Object)jSONArray);
        }
        return jSONObject;
    }

    public String getDataDefinitionType() {
        return "MapMoreLayerDefinition";
    }

    public void clearNameValues() {
        this.nameValueList.clear();
    }

    public MapSingleLayerTableDefinition[] getNameValues() {
        return this.nameValueList.toArray(new MapSingleLayerTableDefinition[this.nameValueList.size()]);
    }

    public void addNameValue(MapSingleLayerTableDefinition mapSingleLayerTableDefinition) {
        this.nameValueList.add(mapSingleLayerTableDefinition);
    }

    public int size() {
        return this.nameValueList.size();
    }

    public ArrayList getSeriesDefinitionList() {
        if (this.nameValueList.isEmpty()) {
            return new ArrayList();
        }
        return ((MapSingleLayerTableDefinition)this.nameValueList.get(0)).getSeriesDefinitionList();
    }

    public boolean equals(Object object) {
        return object instanceof MapMoreLayerTableDefinition && ComparatorUtils.equals((Object)this.nameValueList, (Object)((MapMoreLayerTableDefinition)object).nameValueList) && super.equals(object);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        if (this.nameValueList != null && !this.nameValueList.isEmpty()) {
            xMLPrintWriter.startTAG("MoreMapSingle");
            for (int i = 0; i < this.nameValueList.size(); ++i) {
                ((MapSingleLayerTableDefinition)this.nameValueList.get(i)).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals((String)"MoreMapSingle", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)"MapSingleLayerTableDefinition", (String)xMLableReader.getTagName())) {
                            Object object = xMLableReader.readXMLObject((XMLReadable)new MapSingleLayerTableDefinition());
                            MapMoreLayerTableDefinition.this.addNameValue((MapSingleLayerTableDefinition)object);
                        }
                    }
                });
            } else if (ComparatorUtils.equals((String)"MoreTableNameValue", (String)string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals((String)"SeriesDefinition", (String)xMLableReader.getTagName())) {
                            SeriesDefinition seriesDefinition = (SeriesDefinition)xMLableReader.readXMLObject((XMLReadable)new SeriesDefinition());
                            MapSingleLayerTableDefinition mapSingleLayerTableDefinition = new MapSingleLayerTableDefinition();
                            if (seriesDefinition.getSeriesName() != null) {
                                mapSingleLayerTableDefinition.setAreaName(Utils.objectToString((Object)seriesDefinition.getSeriesName()));
                                seriesDefinition.setSeriesName(Inter.getLocText((String)"Chart-Use_Value"));
                                mapSingleLayerTableDefinition.addTitleValue(seriesDefinition);
                                MapMoreLayerTableDefinition.this.addNameValue(mapSingleLayerTableDefinition);
                            }
                        }
                    }
                });
            }
            this.com4MoreIndex();
        }
    }

    private void com4MoreIndex() {
        MapSingleLayerTableDefinition[] mapSingleLayerTableDefinitionArray = this.getNameValues();
        if (mapSingleLayerTableDefinitionArray.length <= 1) {
            return;
        }
        MapSingleLayerTableDefinition mapSingleLayerTableDefinition = new MapSingleLayerTableDefinition();
        mapSingleLayerTableDefinition.setAreaName(mapSingleLayerTableDefinitionArray[mapSingleLayerTableDefinitionArray.length - 1].getAreaName());
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < mapSingleLayerTableDefinitionArray.length; ++i) {
            MapSingleLayerTableDefinition mapSingleLayerTableDefinition2 = mapSingleLayerTableDefinitionArray[i];
            int n = mapSingleLayerTableDefinition2.getTitleValueSize();
            for (int j = 0; j < n; ++j) {
                SeriesDefinition seriesDefinition = mapSingleLayerTableDefinition2.getTitleValueWithIndex(j);
                if (hashMap.containsKey(seriesDefinition.getSeriesName())) {
                    if (ComparatorUtils.equals(hashMap.get(seriesDefinition.getSeriesName()), (Object)seriesDefinition.getValue())) continue;
                    mapSingleLayerTableDefinition.addTitleValue(seriesDefinition);
                    continue;
                }
                hashMap.put(seriesDefinition.getSeriesName(), seriesDefinition.getValue());
                mapSingleLayerTableDefinition.addTitleValue(seriesDefinition);
            }
        }
        this.clearNameValues();
        this.addNameValue(mapSingleLayerTableDefinition);
    }
}

