/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.BaseUtils;
import com.fr.base.Utils;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.chartattr.Axis;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.ChartXMLUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RectanglePlot;
import com.fr.chart.chartdata.GanttChartData;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryAxisGlyph;
import com.fr.chart.chartglyph.DataPoint4Gantt;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.chart.chartglyph.DiamondFilledMarker;
import com.fr.chart.chartglyph.GanttPlotGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.SquareFilledMarker;
import com.fr.chart.chartglyph.TriangleFilledMarker;
import com.fr.general.Background;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;

public class GanttPlot
extends RectanglePlot {
    private static final long serialVersionUID = 3888739478450011607L;
    public static final String XML_TAG = "GanttPlot";
    public static final String NONE = Inter.getLocText((String)"FR-Chart-Data_None");
    private static final int DEFAULT_ID_COUNT = 1;
    private static final double MORETHANMIN = 10.0;
    private static final String[] GATTCATE = new String[]{Inter.getLocText((String)"FR-Chart-Gantt_Step") + "1", Inter.getLocText((String)"FR-Chart-Gantt_Step") + "2", Inter.getLocText((String)"FR-Chart-Gantt_Step") + "3"};
    private static final String[][] PLANSTART = new String[][]{{"2009/01/01", "2009/01/06", "2009/01/10"}};
    private static final String[][] PLANEND = new String[][]{{"2009/01/03", "2009/01/09", "2009/01/16"}};
    private static final String[][] REALDSTART = new String[][]{{"2009/01/02", "2009/01/05", "2009/01/10"}};
    private static final String[][] REALEND = new String[][]{{"2009/01/03", "2009/01/09", "2009/01/15"}};
    private static final String[][] PROGRESS = new String[][]{{"1", "1", "0.3"}};
    private static final GanttChartData GANTT_DATA = new GanttChartData(GATTCATE, PLANSTART, PLANEND, REALDSTART, REALEND, PROGRESS, new String[0]);

    public GanttPlot() {
        this.setxAxis(new CategoryAxis(1, true));
        this.setyAxis(new CategoryAxis(2));
    }

    public String getPlotDataPaneName() {
        return XML_TAG;
    }

    public String getPlotName() {
        return Inter.getLocText((String)"FR-Chart-Type_Gantt");
    }

    protected void addSeries2PlotGlyph(PlotGlyph plotGlyph, ChartData chartData) {
        GanttChartData ganttChartData = ChartXMLUtils.chartData4Gantt(chartData);
        this.addSeriesByIndex(0, ganttChartData.getCategoryLabelCount(), plotGlyph, ganttChartData);
    }

    protected void addSeriesByIndex(int n, int n2, PlotGlyph plotGlyph, GanttChartData ganttChartData) {
        int n3 = ganttChartData.getIDCount();
        for (int i = 0; i < n3; ++i) {
            DataSeries<DataPoint4Gantt> dataSeries = new DataSeries<DataPoint4Gantt>(i);
            plotGlyph.addSeries(dataSeries);
            String string = "1";
            if (n3 != 1) {
                string = Utils.objectToString((Object)ganttChartData.getIDName(i));
            }
            dataSeries.setSeriesName(string);
            for (int j = 0; j < ganttChartData.getCategoryLabelCount(); ++j) {
                DataPoint4Gantt dataPoint4Gantt = new DataPoint4Gantt();
                this.initDataPointValue(dataPoint4Gantt, ganttChartData, j, i);
                dataPoint4Gantt.setCategoryIndex(j);
                dataPoint4Gantt.setCategoryName(Utils.objectToString((Object)ganttChartData.getCategoryPresentLabel(j)));
                dataPoint4Gantt.setCategoryOriginalName(Utils.objectToString((Object)ganttChartData.getCategoryOriginalLabel(j)));
                dataPoint4Gantt.setSeriesIndex(i);
                dataPoint4Gantt.setSeriesName(string);
                dataPoint4Gantt.setSeriesOriginalName(string);
                dataSeries.addDataPoint(dataPoint4Gantt);
            }
        }
    }

    private void initDataPointValue(DataPoint4Gantt dataPoint4Gantt, GanttChartData ganttChartData, int n, int n2) {
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        double d4 = -1.0;
        double d5 = -1.0;
        Number number = ganttChartData.getPlanStart(n2, n);
        if (number != null) {
            d = number.doubleValue();
        }
        if ((number = ganttChartData.getPlanEnd(n2, n)) != null) {
            d2 = number.doubleValue();
        }
        if ((number = ganttChartData.getRealStart(n2, n)) != null) {
            d4 = number.doubleValue();
        }
        if ((number = ganttChartData.getRealEnd(n2, n)) != null) {
            d5 = number.doubleValue();
        }
        if ((number = ganttChartData.getProgress(n2, n)) != null) {
            d3 = number.doubleValue();
        }
        if (d == -1.0 || d2 == -1.0) {
            dataPoint4Gantt.setValueIsNull(true);
        } else {
            dataPoint4Gantt.setPlanStart(d);
            dataPoint4Gantt.setPlanEnd(d2);
            dataPoint4Gantt.setProgress(d3);
            dataPoint4Gantt.setRealStart(d4);
            dataPoint4Gantt.setRealEnd(d5);
        }
    }

    public ChartData createNullChartData() {
        return new GanttChartData(new String[]{""}, new String[][]{{""}}, new String[][]{{""}}, new String[][]{{""}}, new String[][]{{""}}, new String[][]{{""}}, (Object[])new String[][]{{""}, {""}});
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        GanttPlotGlyph ganttPlotGlyph = new GanttPlotGlyph();
        chartData = ChartXMLUtils.chartData4Gantt(chartData);
        this.createErrTextGlyph(ganttPlotGlyph, (GanttChartData)chartData);
        this.installAxisGlyph(ganttPlotGlyph, chartData);
        this.install4PlotGlyph(ganttPlotGlyph, chartData);
        return ganttPlotGlyph;
    }

    private void createErrTextGlyph(GanttPlotGlyph ganttPlotGlyph, GanttChartData ganttChartData) {
        int n = ganttChartData.getIDCount();
        if (!this.isNullGanttData(ganttChartData, n)) {
            return;
        }
        String string = "";
        if (ganttChartData.getCategoryLabelCount() <= 0) {
            string = string + " " + Inter.getLocText((String[])new String[]{"Chart_Plan", "D-Step"});
        }
        if (ganttChartData.getPlanStartCount() < n) {
            string = string + " " + Inter.getLocText((String)"FR-Chart-Gannt_PlanStartTime");
        }
        if (ganttChartData.getPlanEndCount() < n) {
            string = string + " " + Inter.getLocText((String)"FR-Chart-Gannt_PlanEndTime");
        }
        this.addErrorTip4Glyph(ganttPlotGlyph, string);
    }

    private boolean isNullGanttData(GanttChartData ganttChartData, int n) {
        return ganttChartData.getCategoryLabelCount() <= 0 || ganttChartData.getPlanStartCount() < n || ganttChartData.getPlanEndCount() < n;
    }

    private void addErrorTip4Glyph(GanttPlotGlyph ganttPlotGlyph, String string) {
        ganttPlotGlyph.setErrorToopTip(string);
        ganttPlotGlyph.setErrorImage(BaseUtils.readImage((String)"com/fr/chart/base/dataError.gif"));
    }

    public void installAxisGlyph(GanttPlotGlyph ganttPlotGlyph, ChartData chartData) {
        CategoryAxisGlyph categoryAxisGlyph = (CategoryAxisGlyph)this.getyAxis().createAxisGlyph(chartData);
        categoryAxisGlyph.setAxisType("yAxis");
        ganttPlotGlyph.setyAxisGlyph(categoryAxisGlyph);
        categoryAxisGlyph.setDrawBetweenTick(true);
        categoryAxisGlyph.deletedRepeatLabel();
        DateAxisGlyph dateAxisGlyph = new DateAxisGlyph();
        ((CategoryAxis)this.getxAxis()).initAxisGlyph(dateAxisGlyph, chartData);
        dateAxisGlyph.setAxisType("xAxis");
        ganttPlotGlyph.setxAxisGlyph(dateAxisGlyph);
        GanttChartData ganttChartData = ChartXMLUtils.chartData4Gantt(chartData);
        ((AxisGlyph)dateAxisGlyph).initMinMaxValue(this.getMinValueFromData(ganttChartData), this.getMaxValueFromData(ganttChartData));
    }

    private double getMaxValueFromData(GanttChartData ganttChartData) {
        double d = Double.MIN_VALUE;
        for (int i = 0; i < ganttChartData.getIDCount(); ++i) {
            for (int j = 0; j < ganttChartData.getCategoryLabelCount(); ++j) {
                d = this.getMaxValue(d, ganttChartData.getPlanStart(i, j));
                d = this.getMaxValue(d, ganttChartData.getPlanEnd(i, j));
                d = this.getMaxValue(d, ganttChartData.getRealStart(i, j));
                d = this.getMaxValue(d, ganttChartData.getRealEnd(i, j));
            }
        }
        if (d == this.getMinValueFromData(ganttChartData)) {
            return d + 10.0;
        }
        return d;
    }

    private double getMaxValue(double d, Number number) {
        if (number != null) {
            return number.doubleValue() > d ? number.doubleValue() : d;
        }
        return d;
    }

    private double getMinValue(double d, Number number) {
        if (number != null) {
            return number.doubleValue() < d ? number.doubleValue() : d;
        }
        return d;
    }

    private double getMinValueFromData(GanttChartData ganttChartData) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < ganttChartData.getIDCount(); ++i) {
            for (int j = 0; j < ganttChartData.getCategoryLabelCount(); ++j) {
                d = this.getMinValue(d, ganttChartData.getPlanStart(i, j));
                d = this.getMinValue(d, ganttChartData.getPlanEnd(i, j));
                d = this.getMinValue(d, ganttChartData.getRealStart(i, j));
                d = this.getMinValue(d, ganttChartData.getRealEnd(i, j));
            }
        }
        return d;
    }

    public LegendItem[] createLegendItems(PlotGlyph plotGlyph) {
        int n = plotGlyph.getSeriesSize();
        ArrayList<LegendItem> arrayList = new ArrayList<LegendItem>();
        for (int i = 0; i < n; ++i) {
            DataSeries dataSeries = plotGlyph.getSeries(i);
            if (dataSeries.getDataPointCount() <= 0 || dataSeries.isSeriesNullType4Gantt(0)) continue;
            Color[] colorArray = plotGlyph.createColors4Series();
            if (!dataSeries.isSeriesNullType4Gantt(1)) {
                arrayList.add(this.createPlanItem(plotGlyph.getSeries(i), n, colorArray));
            }
            if (!dataSeries.isSeriesNullType4Gantt(2)) {
                arrayList.add(this.createRealStartItem(plotGlyph.getSeries(i), n));
            }
            if (!dataSeries.isSeriesNullType4Gantt(3)) {
                arrayList.add(this.createRealEndItem(plotGlyph.getSeries(i), n));
            }
            if (dataSeries.isSeriesNullType4Gantt(4)) continue;
            arrayList.add(this.createProgressItem(plotGlyph.getSeries(i), n, colorArray));
        }
        return arrayList.toArray(new LegendItem[arrayList.size()]);
    }

    private LegendItem createPlanItem(DataSeries dataSeries, int n, Color[] colorArray) {
        String string = n > 1 ? dataSeries.getSeriesName() + "-" : "";
        LegendItem legendItem = new LegendItem(string + Inter.getLocText((String)"FR-Chart-Gantt_PlanTime"));
        AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataSeries, colorArray);
        AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataSeries, colorArray);
        SquareFilledMarker squareFilledMarker = new SquareFilledMarker();
        squareFilledMarker.setBackground((Background)ColorBackground.getInstance((Color)ChartBaseUtils.saturationDown(attrColor.getSeriesColor())));
        Background background = null;
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon(background, 0, squareFilledMarker);
        lineMarkerIcon.setAlpha(attrAlpha.getAlpha());
        legendItem.setLineMarkerIcon(lineMarkerIcon);
        return legendItem;
    }

    private LegendItem createRealStartItem(DataSeries dataSeries, int n) {
        String string = n > 1 ? dataSeries.getSeriesName() + "-" : "";
        LegendItem legendItem = new LegendItem(string + Inter.getLocText((String)"FR-Chart-Gantt_RealStart"));
        TriangleFilledMarker triangleFilledMarker = new TriangleFilledMarker();
        triangleFilledMarker.setBackground((Background)ColorBackground.getInstance((Color)Color.black));
        Background background = null;
        legendItem.setLineMarkerIcon(new LineMarkerIcon(background, 0, triangleFilledMarker));
        return legendItem;
    }

    private LegendItem createProgressItem(DataSeries dataSeries, int n, Color[] colorArray) {
        String string = n > 1 ? dataSeries.getSeriesName() + "-" : "";
        LegendItem legendItem = new LegendItem(string + Inter.getLocText((String)"FR-Chart-Gantt_Progress"));
        AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataSeries, colorArray);
        AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataSeries, colorArray);
        SquareFilledMarker squareFilledMarker = new SquareFilledMarker();
        squareFilledMarker.setBackground((Background)ColorBackground.getInstance((Color)attrColor.getSeriesColor()));
        Background background = null;
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon(background, 0, squareFilledMarker);
        lineMarkerIcon.setAlpha(attrAlpha.getAlpha());
        legendItem.setLineMarkerIcon(lineMarkerIcon);
        return legendItem;
    }

    private LegendItem createRealEndItem(DataSeries dataSeries, int n) {
        String string = n > 1 ? dataSeries.getSeriesName() + "-" : "";
        LegendItem legendItem = new LegendItem(string + Inter.getLocText((String)"FR-Chart-Gantt_RealEndTime"));
        DiamondFilledMarker diamondFilledMarker = new DiamondFilledMarker();
        diamondFilledMarker.setBackground((Background)ColorBackground.getInstance((Color)new Color(122, 225, 108)));
        Background background = null;
        legendItem.setLineMarkerIcon(new LineMarkerIcon(background, 0, diamondFilledMarker));
        return legendItem;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof GanttPlot;
    }

    public ChartData defaultChartData() {
        return GANTT_DATA;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("CategoryAxis")) {
                this.setyAxis((Axis)xMLableReader.readXMLObject((XMLReadable)new CategoryAxis()));
            } else if (string.equals("DateAxis")) {
                this.setxAxis((Axis)xMLableReader.readXMLObject((XMLReadable)new CategoryAxis()));
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GanttPlot ganttPlot = (GanttPlot)super.clone();
        return ganttPlot;
    }

    public boolean equals(Object object) {
        return object instanceof GanttPlot && super.equals(object);
    }

    public boolean isSupportDataSeriesAttr() {
        return false;
    }

    public boolean isSupportDataLabelAttr() {
        return false;
    }

    public boolean isSupportTooltipInInteractivePane() {
        return false;
    }

    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/gantt/0";
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.GANTT;
    }

    public int getDetailType() {
        return 0;
    }

    public String getPlotID() {
        return "FineReportGanttChart";
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.GANTT_CHART;
    }
}

