/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.ChangeConfigProvider;
import com.fr.base.chart.ChartWebSource;
import com.fr.chart.base.AttrContents;
import com.fr.chart.chartattr.ChartPainter;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.js.NameJavaScriptGroup;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.core.UUID;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.web.RepositoryHelper;
import com.fr.web.core.SessionIDInfor;
import java.awt.Image;
import java.util.Map;

public class EChartPaintUtils {
    static JSONObject createJSon4ChartPainter(NodeVisitor nodeVisitor, ChartPainter chartPainter, Repository repository, int n, int n2) {
        return EChartPaintUtils.paintTag(nodeVisitor, chartPainter, repository, n, n2, new JSONObject());
    }

    private static JSONObject paintTag(NodeVisitor nodeVisitor, ChartPainter chartPainter, Repository repository, int n, int n2, JSONObject jSONObject) {
        String string = UUID.randomUUID().toString();
        chartPainter.setID(chartPainter.getID() + "__" + string);
        try {
            JSONArray jSONArray = EChartPaintUtils.chartPainter2JSArray(chartPainter, repository, n, n2);
            jSONObject.put("items", (Object)jSONArray);
            jSONObject.put("type", (Object)"simplechart");
            jSONObject.put("isNeedRefreshButton", EChartPaintUtils.isNeedRefreshButton(chartPainter));
            jSONObject.put("chartWidth", n);
            jSONObject.put("chartHeight", n2);
            int n3 = chartPainter.getSelectedIndex();
            if (n3 < 0 || n3 >= chartPainter.getGlyphCount()) {
                n3 = 0;
            }
            jSONObject.put("selectedIndex", n3);
            String string2 = repository.getDevice().isMobile() ? chartPainter.getID() : "ChartPainter__" + chartPainter.getID();
            jSONObject.put("chartpainter_id_web_change_selected", (Object)string2);
            ChartWebSource.putChartSource((String)repository.getSessionID(), (String)string2, (Object)((Object)chartPainter));
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
        if (nodeVisitor != null) {
            nodeVisitor.visit("simplechart", jSONObject);
        }
        return jSONObject;
    }

    private static boolean isNeedRefreshButton(ChartPainter chartPainter) {
        boolean bl = false;
        int n = chartPainter.getGlyphCount();
        for (int i = 0; i < n && !bl; ++i) {
            ChartGlyph chartGlyph;
            Object t;
            Object object = chartPainter.getGlyph(i);
            if (!(object instanceof ChartGlyph) || (t = (chartGlyph = (ChartGlyph)object).getPlotGlyph()) == null) continue;
            bl = bl || ((PlotGlyph)t).isSeriesDragEnable();
        }
        return bl;
    }

    private static void putChartType(JSONObject jSONObject, ChartGlyph chartGlyph) throws JSONException {
        if (chartGlyph != null && chartGlyph.getPlotGlyph() != null) {
            jSONObject.put("chartImageType", (Object)((PlotGlyph)chartGlyph.getPlotGlyph()).getPlotDetailType());
            jSONObject.put("simpleIconType", (Object)((PlotGlyph)chartGlyph.getPlotGlyph()).getSmallIconType());
        }
    }

    private static JSONArray chartPainter2JSArray(ChartPainter chartPainter, Repository repository, int n, int n2) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        ChangeConfigProvider changeConfigProvider = chartPainter.getChangConfig();
        repository.setFontScale(chartPainter.getFontScale());
        if (changeConfigProvider != null && changeConfigProvider.useChangeModel()) {
            EChartPaintUtils.createJson4Change(chartPainter, repository, jSONArray, n, n2);
        } else {
            EChartPaintUtils.createJson4NoChange(chartPainter, repository, jSONArray, n, n2);
        }
        return jSONArray;
    }

    private static void createJson4Change(ChartPainter chartPainter, Repository repository, JSONArray jSONArray, int n, int n2) throws JSONException {
        if (chartPainter.getGlyphCount() == 0) {
            return;
        }
        chartPainter.setSelectedIndex(0);
        JSONObject jSONObject = new JSONObject();
        int n3 = chartPainter.getSelectedIndex();
        jSONObject.put("name", (Object)chartPainter.getGlyphName(n3));
        if (chartPainter.getGlyph(n3) instanceof ChartGlyph) {
            ChartGlyph chartGlyph = (ChartGlyph)chartPainter.getGlyph(n3);
            EChartPaintUtils.putChartType(jSONObject, chartGlyph);
            jSONObject.put("chartJSDraw", chartGlyph.isJSDraw());
            jSONObject.put("beforeInit", (Object)chartGlyph.beforeInitFunc());
            String string = chartPainter.getID() + "__index__" + n3;
            BaseChartGlyph[] baseChartGlyphArray = new ChartGlyph[chartPainter.getGlyphCount()];
            int n4 = chartPainter.getGlyphCount();
            for (int i = 0; i < n4; ++i) {
                baseChartGlyphArray[i] = (ChartGlyph)chartPainter.getGlyph(i);
                baseChartGlyphArray[i].setFontScale(chartPainter.getFontScale());
            }
            Map map = chartGlyph.toJSONMap4Change(chartPainter.getChangConfig(), baseChartGlyphArray, chartPainter.getWidgetDependenced(), n, n2, repository, chartPainter.getSheetIndex(), chartPainter.getECName());
            ChartWebSource.putChartSource((String)repository.getSessionID(), (String)string, (Object)map);
            jSONObject.put("url", (Object)EChartPaintUtils.getChartGlyphURL(string, repository));
            jSONObject.put("isJS", true);
            jSONObject.put("simpleChartInShowID", (Object)string);
            jSONArray.put((Object)jSONObject);
        } else if (chartPainter.getGlyph(n3) instanceof Image) {
            jSONObject.put("url", (Object)repository.checkoutObject(chartPainter.getGlyph(n3), "image"));
            jSONArray.put((Object)jSONObject);
        }
    }

    private static void createJson4NoChange(ChartPainter chartPainter, Repository repository, JSONArray jSONArray, int n, int n2) throws JSONException {
        int n3 = chartPainter.getGlyphCount();
        for (int i = 0; i < n3; ++i) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", (Object)chartPainter.getGlyphName(i));
            if (chartPainter.getGlyph(i) instanceof ChartGlyph) {
                ChartGlyph chartGlyph = (ChartGlyph)chartPainter.getGlyph(i);
                EChartPaintUtils.putChartType(jSONObject, chartGlyph);
                jSONObject.put("chartJSDraw", chartGlyph.isJSDraw());
                jSONObject.put("beforeInit", (Object)chartGlyph.beforeInitFunc());
                if (EChartPaintUtils.isChartSupportCanvas(repository, chartGlyph)) {
                    String string = chartPainter.getID() + "__index__" + i;
                    chartGlyph.setFontScale(chartPainter.getFontScale());
                    Map map = chartGlyph.toJSONMap(chartPainter.getWidgetDependenced(), n, n2, repository, chartPainter.getSheetIndex(), chartPainter.getECName());
                    ChartWebSource.putChartSource((String)repository.getSessionID(), (String)string, (Object)map);
                    jSONObject.put("url", (Object)EChartPaintUtils.getChartGlyphURL(string, repository));
                    jSONObject.put("isJS", true);
                    jSONObject.put("simpleChartInShowID", (Object)string);
                } else {
                    EChartPaintUtils.notSupportCanvas(chartGlyph, repository, jSONObject, n, n2);
                }
                jSONArray.put((Object)jSONObject);
                continue;
            }
            if (!(chartPainter.getGlyph(i) instanceof Image)) continue;
            jSONObject.put("url", (Object)repository.checkoutObject(chartPainter.getGlyph(i), "image"));
            jSONArray.put((Object)jSONObject);
        }
    }

    private static void notSupportCanvas(ChartGlyph chartGlyph, Repository repository, JSONObject jSONObject, int n, int n2) throws JSONException {
        if (chartGlyph.getPlotGlyph() != null && ((PlotGlyph)chartGlyph.getPlotGlyph()).is3DPlotGlyph() && repository.getBrowser().shouldConsiderVML()) {
            chartGlyph.is3DIE6(true);
        }
        Image image = chartGlyph.toImage(n, n2, repository.getResolution());
        jSONObject.put("url", (Object)repository.checkoutObject((Object)image, "image"));
        image = null;
        Object t = chartGlyph.getPlotGlyph();
        if (t != null && ((PlotGlyph)t).isNeedDealHotHyperlink()) {
            String string = "chart_hotmap_" + chartGlyph.getPlotGlyph().hashCode();
            jSONObject.put("usemap", (Object)("#" + string));
            jSONObject.put("mapHtml", (Object)EChartPaintUtils.dealChartHot(chartGlyph, string, repository).toHtml());
        }
    }

    private static boolean isChartSupportCanvas(Repository repository, ChartGlyph chartGlyph) {
        return repository.getBrowser().supportCanvas() && chartGlyph.isChartSupportCanvas();
    }

    private static String getChartGlyphURL(String string, Repository repository) {
        String string2 = CodeUtils.cjkEncode((String)string);
        SessionIDInfor sessionIDInfor = RepositoryHelper.getSessionIDInfor((Repository)repository);
        return "?op=chart&cmd=writer_out_html&sessionID=" + sessionIDInfor.getSessionID() + "&chartID=" + string2;
    }

    private static Tag dealChartHot(ChartGlyph chartGlyph, String string, Repository repository) {
        Object t = chartGlyph.getPlotGlyph();
        Tag tag = new Tag("map");
        tag.attr("name", string);
        tag.attr("id", string);
        int n = 0;
        int n2 = ((PlotGlyph)t).getCategoryCount();
        int n3 = ((PlotGlyph)t).getSeriesSize();
        int[] nArray = ((PlotGlyph)t).getDrawSequence();
        for (int i = n2 - 1; i >= 0; --i) {
            int n4;
            DataPoint[] dataPointArray = new DataPoint[n3];
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                if (((PlotGlyph)t).getSeries(nArray[n4]) == null) continue;
                dataPointArray[n4] = ((PlotGlyph)t).getSeries(nArray[n4]).getDataPoint(i);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                for (int j = n3 - 1; j > n4; --j) {
                    if (dataPointArray[j] == null || dataPointArray[j].isValueIsNull() || !(dataPointArray[j].getValue() < 0.0)) continue;
                    DataPoint dataPoint = dataPointArray[j];
                    dataPointArray[j] = dataPointArray[j - 1];
                    dataPointArray[j - 1] = dataPoint;
                }
            }
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                if (dataPointArray[n4] == null) continue;
                EChartPaintUtils.dealDataPointHot(dataPointArray[n4], chartGlyph, n, tag, repository);
                ++n;
            }
        }
        return tag;
    }

    private static void dealDataPointHot(DataPoint dataPoint, ChartGlyph chartGlyph, int n, Tag tag, Repository repository) {
        Object t = chartGlyph.getPlotGlyph();
        Tag tag2 = dataPoint.getImageMapAreaTag(chartGlyph);
        if (tag2 != null) {
            tag.sub((Html)tag2);
            tag2.attr("id", n + "");
            if (((PlotGlyph)t).getHotHyperLink() != null) {
                EChartPaintUtils.dealChartHotHyperLink(((PlotGlyph)t).getHotHyperLink(), dataPoint, tag2, repository);
            }
            if (((PlotGlyph)t).getHotTooltipStyle() != null) {
                EChartPaintUtils.dealChartHotTooltip(((PlotGlyph)t).getHotTooltipStyle(), dataPoint, tag2);
            }
        }
    }

    private static void dealChartHotHyperLink(NameJavaScriptGroup nameJavaScriptGroup, DataPoint dataPoint, Tag tag, Repository repository) {
        String string = dataPoint.createDataPointHotHyperLink(nameJavaScriptGroup, repository);
        if (string != null) {
            tag.attr("cursor", "pointer");
            tag.attr("onclick", "FR.doHyperlink(event||window.event, " + string + ", true)");
            if (repository.getBrowser().isNoBlurInImage()) {
                tag.attr("onfocus", "this.blur()");
            }
            tag.attr("href", "javascript:void(0)");
        }
    }

    private static void dealChartHotTooltip(AttrContents attrContents, DataPoint dataPoint, Tag tag) {
        tag.attr("title", dataPoint.createHotTooltip(attrContents));
    }
}

