/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.ScreenResolution;
import com.fr.base.chart.BaseChart;
import com.fr.base.chart.BaseChartGlyph;
import com.fr.base.chart.BaseChartIcon;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;

public class ChartIcon
implements BaseChartIcon,
XMLable {
    private static final int WIDTH = 400;
    private static final int HEIGHT = 225;
    private BaseChart chart;

    public ChartIcon(BaseChart baseChart) {
        this.chart = baseChart;
    }

    public void setBaseChart(BaseChart baseChart) {
        this.chart = baseChart;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics.translate(n, n2);
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        this.createGlyph().draw((Graphics)graphics2D, ScreenResolution.getScreenResolution());
        graphics.translate(-n, -n2);
        graphics2D.setPaint(paint);
    }

    protected BaseChartGlyph createGlyph() {
        ChartData chartData = this.chart.defaultChartData();
        BaseChartGlyph baseChartGlyph = this.chart.createGlyph(chartData);
        baseChartGlyph.setBounds((RectangularShape)new Rectangle2D.Double(0.0, 0.0, this.getIconWidth(), this.getIconHeight()));
        return baseChartGlyph;
    }

    public int getIconWidth() {
        return 400;
    }

    public int getIconHeight() {
        return 225;
    }

    public BaseChart getChart() {
        return this.chart;
    }

    public BufferedImage createIconImage() {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)this.getIconWidth(), (int)this.getIconHeight(), (int)2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(10, 1.0f));
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        graphics2D.setComposite(composite);
        this.createGlyph().draw((Graphics)graphics2D, ScreenResolution.getScreenResolution());
        return bufferedImage;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public Object clone() throws CloneNotSupportedException {
        ChartIcon chartIcon = (ChartIcon)super.clone();
        if (this.chart != null) {
            return new ChartIcon((BaseChart)this.chart.clone());
        }
        return chartIcon;
    }
}

