/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.ChartEquationType;
import com.fr.chart.base.LineStyleInfo;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class TrendLine
implements XMLable {
    private static final long serialVersionUID = -993509754275088848L;
    private int moveAverage = 2;
    private ChartEquationType equation = ChartEquationType.POLYNOMIAL;
    private int square = 6;
    private LineStyleInfo lineStyleInfo = new LineStyleInfo();
    private String trendLineName = Inter.getLocText((String)"Chart_TrendLine");

    public TrendLine() {
    }

    public TrendLine(ChartEquationType chartEquationType) {
        this.setEquation(chartEquationType);
    }

    public void setEquation(ChartEquationType chartEquationType) {
        this.equation = chartEquationType;
    }

    public ChartEquationType getEquation() {
        return this.equation;
    }

    public int getSquare() {
        return this.square;
    }

    public void setMoveAverage(int n) {
        this.moveAverage = n;
    }

    public int getMoveAverage() {
        return this.moveAverage;
    }

    public void setTrendLineName(String string) {
        this.trendLineName = string;
    }

    public String getTrendLineName() {
        return this.trendLineName;
    }

    public void setLineStyleInfo(LineStyleInfo lineStyleInfo) {
        this.lineStyleInfo = lineStyleInfo;
    }

    public LineStyleInfo getLineStyleInfo() {
        return this.lineStyleInfo;
    }

    public Object clone() {
        TrendLine trendLine = new TrendLine(this.equation);
        trendLine.square = this.square;
        trendLine.setLineStyleInfo(this.getLineStyleInfo());
        return trendLine;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("LineStyleInfo")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string = xMLableReader.getTagName();
                        if (string.equals("LineStyleInfo")) {
                            TrendLine.this.setLineStyleInfo((LineStyleInfo)xMLableReader.readXMLObject((XMLReadable)new LineStyleInfo()));
                        }
                    }
                });
            } else if (string.equals("Attr")) {
                this.square = xMLableReader.getAttrAsInt("square", 6);
                this.equation = ChartEquationType.getEquationByOrdinal(xMLableReader.getAttrAsInt("equation", ChartEquationType.POLYNOMIAL.ordinal()));
                this.setMoveAverage(xMLableReader.getAttrAsInt("moveAverage", 2));
                if (xMLableReader.getAttrAsString("trendLineName", null) != null) {
                    this.setTrendLineName(xMLableReader.getAttrAsString("trendLineName", Inter.getLocText((String)"Chart_TrendLine")));
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("TrendLine");
        xMLPrintWriter.startTAG("Attr").attr("equation", this.equation.ordinal()).attr("square", this.square).attr("trendLineName", this.trendLineName).attr("moveAverage", this.getMoveAverage()).end();
        this.getLineStyleInfo().writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("equation", this.equation.ordinal());
        jSONObject.put("square", this.square);
        jSONObject.put("moveAverage", this.getMoveAverage());
        jSONObject.put("trendLineName", (Object)this.trendLineName);
        if (this.lineStyleInfo != null) {
            jSONObject.put("lineStyleInfo", (Object)this.lineStyleInfo.toJSONObject(repository));
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof TrendLine && ComparatorUtils.equals((String)((TrendLine)object).trendLineName, (String)this.trendLineName) && ComparatorUtils.equals((Object)((TrendLine)object).lineStyleInfo, (Object)this.lineStyleInfo) && ((TrendLine)object).square == this.square && ((TrendLine)object).moveAverage == this.moveAverage && ((TrendLine)object).equation == this.equation;
    }
}

