/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ShadowRenderer;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class Shadow
implements XMLReadable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 316720726448090470L;
    public static final String XML_TAG = "Shadow";
    private float shadowAlpha;
    private int shadowSize = 4;
    private Color shadowColor;

    public Shadow() {
    }

    public Shadow(Color color, int n, float f) {
        this.shadowAlpha = f;
        this.shadowSize = n;
        this.shadowColor = color;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowSize(int n) {
        this.shadowSize = n;
    }

    public void setShadowAlpha(float f) {
        this.shadowAlpha = f;
    }

    public void paint(Graphics graphics, Shape shape) {
        this.paint(graphics, shape, 0);
    }

    public void paint(Graphics graphics, Shape shape, int n) {
        if (this.needPaintShadow(shape)) {
            return;
        }
        BufferedImage bufferedImage = ChartBaseUtils.shapeToImage(shape, n);
        ShadowRenderer shadowRenderer = new ShadowRenderer(this.shadowSize / 4, 1.0f, this.getShadowColor());
        BufferedImage bufferedImage2 = shadowRenderer.createShadow(bufferedImage);
        double d = shape.getBounds().getX();
        double d2 = shape.getBounds().getY();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.shadowAlpha));
        graphics2D.translate(d, d2);
        if (n <= 0) {
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        } else {
            graphics2D.drawImage((Image)bufferedImage2, -n, -n, null);
        }
        graphics2D.setComposite(composite);
        graphics2D.translate(-d, -d2);
    }

    private boolean needPaintShadow(Shape shape) {
        return shape == null || this.shadowAlpha == 0.0f || this.shadowSize == 0 || shape.getBounds2D() == null || shape.getBounds2D().getWidth() <= 0.0 || shape.getBounds2D().getHeight() <= 0.0;
    }

    public boolean equals(Object object) {
        return object instanceof Shadow && ((Shadow)object).shadowAlpha == this.shadowAlpha && ((Shadow)object).shadowSize == this.shadowSize && ComparatorUtils.equals((Object)((Shadow)object).shadowColor, (Object)this.shadowColor);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("Attr")) {
            this.shadowSize = xMLableReader.getAttrAsInt("shadowSize", 0);
            this.shadowAlpha = xMLableReader.getAttrAsFloat("shadowAlpha", 0.0f);
            this.shadowColor = xMLableReader.getAttrAsColor("shadowColor", null);
        }
    }

    public void writerXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("shadowSize", this.shadowSize).attr("shadowAlpha", this.shadowAlpha);
        if (this.shadowColor != null) {
            xMLPrintWriter.attr("shadowColor", this.shadowColor.getRGB());
        }
        xMLPrintWriter.end();
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        Shadow shadow = (Shadow)super.clone();
        return shadow;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("shadowSize", this.shadowSize);
        jSONObject.put("shadowAlpha", (double)this.shadowAlpha);
        if (this.shadowColor != null) {
            jSONObject.put("shadowColor", (Object)StableUtils.javaColorToCSSColor((Color)this.shadowColor));
        }
        return jSONObject;
    }
}

