/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.chart.base.MapSvgXMLHelper;
import com.fr.general.ComparatorUtils;
import com.fr.general.jsqlparser.parser.ParseException;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.Nameable;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.SvgProvider;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGPathSegList;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGGraphicsElement;
import org.apache.batik.dom.svg.SVGOMCircleElement;
import org.apache.batik.dom.svg.SVGOMEllipseElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMPolygonElement;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.parser.DefaultPointsHandler;
import org.apache.batik.parser.PointsHandler;
import org.apache.batik.parser.PointsParser;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGSVGElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSvgAttr
implements Nameable,
SvgProvider {
    private static final int WIDTH = 800;
    private static final int HEIGHT = 600;
    private static final int FOUR = 4;
    private static final String LAYERSTO = "layersTo";
    private Image mapImage;
    private String filePath;
    private int versionID;
    private SVGDocument svgDocument;
    private Dimension mapSize = new Dimension(800, 600);
    private HashMap<String, ArrayList<String>> shapeValues = new HashMap();
    private HashMap<String, String> layersTo = new HashMap();
    private HashMap<String, String> nameTo = new HashMap();
    private HashMap<String, GeneralPath> shapePaths = new HashMap();
    private HashMap<String, String> nameToID = new HashMap();
    private String tmpName = "";

    public MapSvgAttr(String string) {
        this.filePath = string;
        this.readSvgMap();
        this.tmpName = this.getName();
    }

    public MapSvgAttr() {
    }

    public void setFilePath(String string) {
        this.filePath = string;
        this.tmpName = this.getName();
    }

    public void readSvgMap() {
        String string = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(string);
        try {
            this.svgDocument = (SVGDocument)sAXSVGDocumentFactory.createDocument(new File(this.filePath).toURI().toString());
            this.readLayersTo();
            this.readMapSize();
            this.readAllNodeToPath();
        }
        catch (IOException iOException) {
            FRContext.getLogger().error(iOException.getMessage());
        }
    }

    public boolean removeSvgFile() {
        String string = this.filePath.substring(this.filePath.indexOf("chartmapsvg"));
        return FRContext.getCurrentEnv().deleteFile(StableUtils.pathJoin((String[])new String[]{"resources", string}));
    }

    public void setMapTypeAndName(String string, String string2) {
        if (this.svgDocument == null) {
            return;
        }
        this.svgDocument.getRootElement().setAttribute("mapType", string);
        this.svgDocument.getRootElement().setAttribute("mapName", string2);
    }

    public String getMapType() {
        return this.svgDocument.getRootElement().getAttribute("mapType");
    }

    private void readMapSize() {
        SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
        String string = sVGSVGElement.getAttribute("width");
        String string2 = sVGSVGElement.getAttribute("height");
        if (StringUtils.isNotBlank((String)string) || StringUtils.isNotBlank((String)string2)) {
            if (string.indexOf("px") != -1) {
                string = string.substring(0, string.indexOf("px"));
                string2 = string2.substring(0, string2.indexOf("px"));
            }
            this.mapSize = new Dimension(Integer.parseInt(string), Integer.parseInt(string2));
        } else {
            String string3 = sVGSVGElement.getAttribute("viewBox");
            String[] stringArray = string3.split(" ");
            if (stringArray.length == 4) {
                int n = Integer.parseInt(stringArray[2]) - Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[3]) - Integer.parseInt(stringArray[1]);
                this.mapSize = new Dimension(n, n2);
            }
        }
    }

    private void readAllNodeToPath() {
        this.readRect();
        this.readCircle();
        this.readEllipse();
        this.readPath();
        this.readPolygon();
    }

    private void readRect() {
        NodeList nodeList = this.svgDocument.getElementsByTagName("rect");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                SVGOMRectElement sVGOMRectElement = (SVGOMRectElement)nodeList.item(i);
                double d = Double.parseDouble(sVGOMRectElement.getAttribute("x"));
                double d2 = Double.parseDouble(sVGOMRectElement.getAttribute("y"));
                double d3 = Double.parseDouble(sVGOMRectElement.getAttribute("width"));
                double d4 = Double.parseDouble(sVGOMRectElement.getAttribute("height"));
                double d5 = Double.parseDouble(sVGOMRectElement.getAttribute("rx"));
                double d6 = Double.parseDouble(sVGOMRectElement.getAttribute("ry"));
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d, d2, d3, d4, d5, d6);
                GeneralPath generalPath = new GeneralPath(double_);
                this.setElementPath((SVGGraphicsElement)sVGOMRectElement, i, generalPath);
            }
        }
    }

    private void readCircle() {
        NodeList nodeList = this.svgDocument.getElementsByTagName("circle");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                SVGOMCircleElement sVGOMCircleElement = (SVGOMCircleElement)nodeList.item(i);
                double d = Double.parseDouble(sVGOMCircleElement.getAttribute("cx"));
                double d2 = Double.parseDouble(sVGOMCircleElement.getAttribute("cy"));
                double d3 = Double.parseDouble(sVGOMCircleElement.getAttribute("r"));
                Arc2D.Double double_ = new Arc2D.Double(d - d3, d2 - d3, d3 * 2.0, d3 * 2.0, 0.0, 360.0, 1);
                GeneralPath generalPath = new GeneralPath(double_);
                this.setElementPath((SVGGraphicsElement)sVGOMCircleElement, i, generalPath);
            }
        }
    }

    private void readEllipse() {
        NodeList nodeList = this.svgDocument.getElementsByTagName("ellipse");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                SVGOMEllipseElement sVGOMEllipseElement = (SVGOMEllipseElement)nodeList.item(i);
                double d = Double.parseDouble(sVGOMEllipseElement.getAttribute("cx"));
                double d2 = Double.parseDouble(sVGOMEllipseElement.getAttribute("cy"));
                double d3 = Double.parseDouble(sVGOMEllipseElement.getAttribute("rx"));
                double d4 = Double.parseDouble(sVGOMEllipseElement.getAttribute("ry"));
                Arc2D.Double double_ = new Arc2D.Double(d - d3, d2 - d4, d3 * 2.0, d4 * 2.0, 0.0, 360.0, 1);
                GeneralPath generalPath = new GeneralPath(double_);
                this.setElementPath((SVGGraphicsElement)sVGOMEllipseElement, i, generalPath);
            }
        }
    }

    private void readPath() {
        String string = "http://www.w3.org/2000/svg";
        NodeList nodeList = this.svgDocument.getElementsByTagNameNS(string, "path");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                SVGOMPathElement sVGOMPathElement = (SVGOMPathElement)nodeList.item(i);
                GeneralPath generalPath = new GeneralPath();
                SVGPathSegList sVGPathSegList = sVGOMPathElement.getNormalizedPathSegList();
                int n2 = sVGPathSegList.getNumberOfItems();
                block9: for (int j = 0; j < n2; ++j) {
                    SVGPathSeg sVGPathSeg = sVGPathSegList.getItem(j);
                    char c = sVGPathSeg.getPathSegTypeAsLetter().charAt(0);
                    switch (c) {
                        case 'L': {
                            AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem sVGPathSegMovetoLinetoItem = (AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem)sVGPathSeg;
                            generalPath.lineTo(sVGPathSegMovetoLinetoItem.getX(), sVGPathSegMovetoLinetoItem.getY());
                            continue block9;
                        }
                        case 'M': {
                            AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem sVGPathSegMovetoLinetoItem = (AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem)sVGPathSeg;
                            generalPath.moveTo(sVGPathSegMovetoLinetoItem.getX(), sVGPathSegMovetoLinetoItem.getY());
                            continue block9;
                        }
                        case 'C': {
                            AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem sVGPathSegCurvetoCubicItem = (AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSeg;
                            generalPath.curveTo(sVGPathSegCurvetoCubicItem.getX1(), sVGPathSegCurvetoCubicItem.getY1(), sVGPathSegCurvetoCubicItem.getX2(), sVGPathSegCurvetoCubicItem.getY2(), sVGPathSegCurvetoCubicItem.getX(), sVGPathSegCurvetoCubicItem.getY());
                            continue block9;
                        }
                        case 'Q': {
                            AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem sVGPathSegCurvetoQuadraticItem = (AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem)sVGPathSeg;
                            generalPath.quadTo(sVGPathSegCurvetoQuadraticItem.getX1(), sVGPathSegCurvetoQuadraticItem.getY1(), sVGPathSegCurvetoQuadraticItem.getX(), sVGPathSegCurvetoQuadraticItem.getY());
                            continue block9;
                        }
                        case 'A': {
                            continue block9;
                        }
                        case 'Z': {
                            generalPath.closePath();
                        }
                    }
                }
                this.setElementPath((SVGGraphicsElement)sVGOMPathElement, i, generalPath);
            }
        }
    }

    private void readPolygon() {
        NodeList nodeList = this.svgDocument.getElementsByTagName("polygon");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                SVGOMPolygonElement sVGOMPolygonElement = (SVGOMPolygonElement)nodeList.item(i);
                try {
                    Point2D[] point2DArray = this.extractPoints(sVGOMPolygonElement.getAttribute("points"));
                    GeneralPath generalPath = new GeneralPath();
                    int n2 = point2DArray.length;
                    for (int j = 0; j < n2; ++j) {
                        Point2D point2D = point2DArray[j];
                        if (j == 0) {
                            generalPath.moveTo(point2D.getX(), point2D.getY());
                            continue;
                        }
                        if (j == n2 - 1) {
                            generalPath.closePath();
                            continue;
                        }
                        generalPath.lineTo(point2D.getX(), point2D.getY());
                    }
                    this.setElementPath((SVGGraphicsElement)sVGOMPolygonElement, i, generalPath);
                    continue;
                }
                catch (ParseException parseException) {
                    FRContext.getLogger().error(parseException.getMessage());
                }
            }
        }
    }

    private void setElementPath(SVGGraphicsElement sVGGraphicsElement, int n, GeneralPath generalPath) {
        String string = sVGGraphicsElement.getTagName() + n;
        sVGGraphicsElement.setId(string);
        this.shapePaths.put(string, generalPath);
        String string2 = sVGGraphicsElement.getAttribute("name");
        if (!StringUtils.isEmpty((String)string2)) {
            Object object;
            if (this.shapeValues.keySet().contains(string2)) {
                object = this.shapeValues.get(string2);
                ((ArrayList)object).add(string);
            } else {
                object = new ArrayList();
                this.shapeValues.put(string2, (ArrayList<String>)object);
                ((ArrayList)object).add((Object)string);
            }
            object = sVGGraphicsElement.getAttribute("nameTo");
            if (!StringUtils.isEmpty((String)object)) {
                this.nameTo.put(string2, (String)object);
            }
            this.nameToID.put(string2, string);
        }
    }

    private Point2D[] extractPoints(String string) throws ParseException {
        final ArrayList arrayList = new ArrayList();
        PointsParser pointsParser = new PointsParser();
        DefaultPointsHandler defaultPointsHandler = new DefaultPointsHandler(){

            public void point(float f, float f2) {
                Point2D.Float float_ = new Point2D.Float(f, f2);
                arrayList.add(float_);
            }
        };
        pointsParser.setPointsHandler((PointsHandler)defaultPointsHandler);
        pointsParser.parse(string);
        return arrayList.toArray(new Point2D.Float[0]);
    }

    public Image getMapImage() {
        if (this.svgDocument != null && this.mapImage == null) {
            try {
                PNGTranscoder pNGTranscoder = new PNGTranscoder();
                pNGTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)new Float(this.mapSize.getWidth()));
                pNGTranscoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, (Object)new Float(this.mapSize.getHeight()));
                String string = new File(this.filePath).toURI().toString();
                TranscoderInput transcoderInput = new TranscoderInput(string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)byteArrayOutputStream);
                try {
                    pNGTranscoder.transcode(transcoderInput, transcoderOutput);
                    this.mapImage = GeneralXMLTools.imageDecode((byte[])byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                }
                catch (TranscoderException transcoderException) {
                    FRContext.getLogger().error(transcoderException.getMessage());
                }
            }
            catch (IOException iOException) {
                FRContext.getLogger().error(iOException.getMessage());
            }
        }
        return this.mapImage;
    }

    public GeneralPath getPath4PathID(String string) {
        if (ComparatorUtils.equals((String)string, (String)"")) {
            return new GeneralPath();
        }
        GeneralPath generalPath = this.shapePaths.get(string);
        if (generalPath == null) {
            return new GeneralPath();
        }
        return generalPath;
    }

    public GeneralPath getShapeValue(String string) {
        GeneralPath generalPath = null;
        if (this.shapeValues.containsKey(string)) {
            generalPath = new GeneralPath();
            for (String string2 : this.shapeValues.get(string)) {
                generalPath.append(this.shapePaths.get(string2), false);
            }
        }
        return generalPath;
    }

    public GeneralPath getSelectPath(Point point) {
        String string = this.getSelectedPathName(point);
        if (string == null || string.isEmpty()) {
            return null;
        }
        GeneralPath generalPath = this.shapePaths.get(string);
        if (generalPath == null) {
            return new GeneralPath();
        }
        return generalPath;
    }

    public String getSelectedPathName(Point point) {
        for (Map.Entry<String, GeneralPath> entry : this.shapePaths.entrySet()) {
            GeneralPath generalPath = entry.getValue();
            if (!generalPath.contains(point)) continue;
            return entry.getKey();
        }
        return "";
    }

    public String getLayerTo(String string) {
        if (this.layersTo.containsKey(string)) {
            return Utils.objectToString((Object)this.layersTo.get(string));
        }
        return "";
    }

    public void setNodeName(String string, String string2) {
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
            return;
        }
        AbstractElement abstractElement = (AbstractElement)this.svgDocument.getElementById(string);
        if (abstractElement != null) {
            abstractElement.setAttribute("name", string2);
            if (this.shapeValues.containsKey(string2)) {
                if (!this.checkPathsExistInShape(string2, string)) {
                    this.shapeValues.get(string2).add(string);
                }
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                this.shapeValues.put(string2, arrayList);
                arrayList.add(string);
            }
            this.nameToID.put(string2, string);
        }
    }

    private boolean checkPathsExistInShape(String string, String string2) {
        if (!this.shapeValues.containsKey(string)) {
            return false;
        }
        ArrayList<String> arrayList = this.shapeValues.get(string);
        for (String string3 : arrayList) {
            if (!ComparatorUtils.equals((String)string3, (String)string2)) continue;
            return true;
        }
        return false;
    }

    public void removeNodeName(String string) {
        if (this.shapeValues.containsKey(string)) {
            this.shapeValues.remove(string);
        }
        if (this.nameToID.containsKey(string)) {
            this.nameToID.remove(string);
        }
    }

    public Iterator shapeValuesIterator() {
        return this.shapeValues.keySet().iterator();
    }

    public ArrayList<String> getExistedShapePathID(String string) {
        if (this.shapeValues.containsKey(string)) {
            return this.shapeValues.get(string);
        }
        return new ArrayList<String>();
    }

    public void addVersionID() {
        ++this.versionID;
    }

    public int shapeValueSize() {
        return this.shapeValues.size();
    }

    public String getNameToValue(String string) {
        if (this.nameTo.keySet().contains(string)) {
            return this.nameTo.get(string);
        }
        return string;
    }

    public void setNameTo(String string, String string2) {
        for (String string3 : this.shapePaths.keySet()) {
            AbstractElement abstractElement = (AbstractElement)this.svgDocument.getElementById(string3);
            if (!ComparatorUtils.equals((String)string, (String)abstractElement.getAttribute("name"))) continue;
            abstractElement.setAttribute("nameTo", string2);
            if (this.nameTo.containsKey(string)) {
                this.nameTo.remove(string);
            }
            this.nameTo.put(string, string2);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public SVGDocument getSvgDocument() {
        return this.svgDocument;
    }

    public void renameMap(String string) {
        if (this.svgDocument == null) {
            if (MapSvgXMLHelper.getInstance().getMapAttr(this.tmpName) != null) {
                MapSvgXMLHelper.getInstance().getMapAttr(this.tmpName).renameMap(string);
            }
            this.tmpName = string;
            return;
        }
        this.tmpName = string;
        String string2 = this.svgDocument.getRootElement().getAttribute("mapName");
        MapSvgXMLHelper.getInstance().refreshMapName(string2, string);
        this.svgDocument.getRootElement().setAttribute("mapName", string);
    }

    public void putLayerTo(String string, String string2) {
        this.layersTo.put(string, string2);
        this.writeLayersTo();
    }

    private void writeLayersTo() {
        if (this.svgDocument != null && this.svgDocument.getRootElement() != null) {
            SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
            if (this.layersTo == null || this.layersTo.isEmpty()) {
                sVGSVGElement.setAttribute(LAYERSTO, "");
            } else {
                String string = "";
                for (String string2 : this.layersTo.keySet()) {
                    String string3 = this.layersTo.get(string2);
                    string = string + string2 + "," + string3 + ",";
                }
                sVGSVGElement.setAttribute(LAYERSTO, string);
            }
        }
    }

    private void readLayersTo() {
        if (this.svgDocument != null && this.svgDocument.getRootElement() != null) {
            SVGSVGElement sVGSVGElement = this.svgDocument.getRootElement();
            String string = sVGSVGElement.getAttribute(LAYERSTO);
            String[] stringArray = string.split(",");
            int n = 0;
            int n2 = stringArray.length;
            while (n + 1 < n2) {
                this.layersTo.put(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
        }
    }

    private boolean isDefaultMap() {
        return this.filePath != null && this.filePath.indexOf("user-defined") == -1 && this.filePath.indexOf(MapSvgXMLHelper.defaultMapPath()) != -1;
    }

    public void writeBack(String string) {
        String string2 = MapSvgXMLHelper.customMapPath() + "/" + string + ".svg";
        if (this.isDefaultMap()) {
            string2 = MapSvgXMLHelper.defaultMapPath() + "/" + string + ".svg";
        }
        if (StringUtils.isNotEmpty((String)string)) {
            this.filePath = string2;
        }
        try {
            FRContext.getCurrentEnv().writeSvgFile((SvgProvider)this);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public String getName() {
        if (this.svgDocument == null) {
            if (ComparatorUtils.equals((String)this.tmpName, (String)"") && this.filePath != null) {
                return this.filePath.substring(this.filePath.lastIndexOf("/") + 1, this.filePath.indexOf(".svg"));
            }
            if (!ComparatorUtils.equals((String)this.tmpName, (String)"")) {
                return this.tmpName;
            }
            return "";
        }
        return this.svgDocument.getRootElement().getAttribute("mapName");
    }

    public void setName(String string) {
        this.renameMap(string);
    }

    public void clearExistShape() {
        this.shapeValues.clear();
        for (String string : this.shapePaths.keySet()) {
            AbstractElement abstractElement = (AbstractElement)this.svgDocument.getElementById(string);
            if (abstractElement == null) continue;
            abstractElement.removeAttribute("name");
        }
    }
}

