/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseUtils;
import com.fr.base.ChartPreStyleManagerProvider;
import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.AttrFillStyle;
import com.fr.chart.base.ChartPreStyle;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.stable.ColumnRow;
import com.fr.stable.StableUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ChartUtils {
    private static final double CENTER = 0.5;
    private static final int FONT_SIZE_NORENDER = 14;
    private static final float SCALE = 0.6f;
    private static final float CIRCLE = 360.0f;
    private static final HashMap<Integer, String> POS_STRING = new HashMap<Integer, String>(){
        {
            this.put(0, "center");
            this.put(2, "left");
            this.put(4, "right");
            this.put(1, "top");
            this.put(3, "bottom");
            this.put(8, "right-top");
            this.put(5, "inside");
            this.put(6, "outside");
        }
    };
    private static final HashMap<Integer, String> FILL_STYLE = new HashMap<Integer, String>(){
        {
            this.put(0, "fill");
            this.put(1, "fill");
            this.put(2, "gradient");
        }
    };
    private static final HashMap<Integer, String> PLOT_STYLE = new HashMap<Integer, String>(){
        {
            this.put(1, "3D");
            this.put(2, "highlight");
            this.put(4, "gradient");
            this.put(5, "transparent");
        }
    };
    public static final HashMap<String, String> CONDITION_NAME = new HashMap<String, String>(){
        {
            this.put("Chart-Series_Index", "SeriesIndex");
            this.put("ChartF-Series_Name", "SeriesName");
            this.put("Chart-Category_Index", "CategoryIndex");
            this.put("Chart-Category_Name", "CategoryName");
            this.put("Chart-Series_Value", "Value");
            this.put("Chart-Project_ID", "ProjectID");
            this.put("Chart-Step_Nam", "StepName");
            this.put("Chart-Step_Index", "StepIndex");
            this.put("FR-Chart-Area_Name", "AreaName");
            this.put("Chart-Area_Value", "AreaValue");
        }
    };
    private static final String[] DEFINED_COLORS = new String[]{"bright", "elegant", "soft", "simple", "retro", "business", "fresh", "classic", "gradual", "nostalgia"};
    public static final Object[] CATEGORY_STRING = new Object[]{Inter.getLocText((String)"FR-Chart-Category_Name") + "1", Inter.getLocText((String)"FR-Chart-Category_Name") + "2", Inter.getLocText((String)"FR-Chart-Category_Name") + "3"};
    public static final Object[] MORE_SECOND_CATE = new Object[]{Inter.getLocText((String)"FR-Chart-Category_Name") + "Y1", Inter.getLocText((String)"FR-Chart-Category_Name") + "Y2", Inter.getLocText((String)"FR-Chart-Category_Name") + "Y3", Inter.getLocText((String)"FR-Chart-Category_Name") + "Y1", Inter.getLocText((String)"FR-Chart-Category_Name") + "Y2", Inter.getLocText((String)"FR-Chart-Category_Name") + "Y3"};
    public static final Object[] SECOND_CATE = new Object[]{Inter.getLocText((String)"FR-Chart-Category_Name") + "X1", Inter.getLocText((String)"FR-Chart-Category_Name") + "X2"};
    public static final Object[] MORE_SERIES = new Object[]{Inter.getLocText((String)"FR.Chart-Series_Name") + "1", Inter.getLocText((String)"FR.Chart-Series_Name") + "2", Inter.getLocText((String)"FR.Chart-Series_Name") + "3"};
    public static final Object[][] MORE_SECOND_VALUES = new Object[][]{{"40", "50", "30", "40", "50", "30"}, {"25", "45", "55", "25", "45", "55"}, {"25", "45", "55", "25", "45", "55"}};
    public static final Object[] MORE_THIRD_CATE = new Object[]{Inter.getLocText((String)"FR-Chart-Category_Name") + "Z1", Inter.getLocText((String)"FR-Chart-Category_Name") + "Z2", Inter.getLocText((String)"FR-Chart-Category_Name") + "Z1", Inter.getLocText((String)"FR-Chart-Category_Name") + "Z2", Inter.getLocText((String)"FR-Chart-Category_Name") + "Z1", Inter.getLocText((String)"FR-Chart-Category_Name") + "Z2", Inter.getLocText((String)"FR-Chart-Category_Name") + "Z1", Inter.getLocText((String)"FR-Chart-Category_Name") + "Z2"};
    public static final Object[] THIRD_SECOND_CATE = new Object[]{Inter.getLocText((String)"FR-Chart-Category_Name") + "Y1", Inter.getLocText((String)"FR-Chart-Category_Name") + "Y2"};
    public static final Object[] THIRD_CATE = new Object[]{Inter.getLocText((String)"FR-Chart-Category_Name") + "X1", Inter.getLocText((String)"FR-Chart-Category_Name") + "X2"};
    public static final Object[][] MORE_THIRD_VALUES = new Object[][]{{"40", "50", "30", "40", "50", "30", "40", "50"}, {"25", "45", "55", "25", "45", "55", "40", "50"}, {"25", "45", "55", "25", "45", "55", "25", "45"}};
    public static final Object[] CATEGORY_DATE = new Object[]{DateUtils.createDate((int)2001, (int)1, (int)1), DateUtils.createDate((int)2001, (int)1, (int)2), DateUtils.createDate((int)2001, (int)1, (int)3)};
    public static final Object[] LONG_CATEGORY_STRING = new Object[]{"Apple", "Banana", "Pear", "Orange", "Grape", "Plum"};
    public static final Object[] LONG_CATEGORY_DATE = new Object[]{new Date(0L), new Date(86400000L), new Date(172800000L), new Date(259200000L), new Date(345600000L), new Date(432000000L)};
    public static final Object[] STOCK_CATEGORY_DATE = new Object[]{new Date(0L), new Date(86400000L), new Date(172800000L), new Date(259200000L), new Date(345600000L), new Date(432000000L), new Date(518400000L), new Date(604800000L), new Date(691200000L), new Date(777600000L), new Date(864000000L), new Date(950400000L), new Date(1036800000L), new Date(1123200000L), new Date(1209600000L), new Date(1296000000L), new Date(1382400000L), new Date(1468800000L), new Date(1555200000L), new Date(1641600000L), new Date(1728000000L), new Date(1814400000L), new Date(1900800000L), new Date(1987200000L), new Date(2073600000L)};
    public static final String[] STOCK_CATEGORY_STRING = new String[]{"2010-08-23", "2010-08-24", "2010-08-25", "2010-08-26", "2010-08-27", "2010-08-28", "2010-08-29", "2010-08-30", "2010-08-31", "2010-09-01", "2010-09-02", "2010-09-03", "2010-09-04", "2010-09-05", "2010-09-06", "2010-09-07", "2010-09-08", "2010-09-08", "2010-09-10", "2010-09-11", "2010-09-12", "2010-09-13", "2010-09-14", "2010-09-15", "2010-09-16", "2010-09-17", "2010-09-18", "2010-09-19", "2010-09-20", "2010-09-21", "2010-09-22", "2010-09-23"};

    private ChartUtils() {
    }

    public static final Image string2Image(String string, TextAttr textAttr) {
        if (textAttr == null) {
            textAttr = new TextAttr(FRFont.getInstance());
        }
        if (textAttr.getFRFont() == null) {
            textAttr.setFRFont(FRFont.getInstance());
        }
        FRFont fRFont = textAttr.getFRFont();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, new TextAttr(FRFont.getInstance((String)"SimSun", (int)0, (float)(fRFont.getSize() + 1))), 72);
        BufferedImage bufferedImage = new BufferedImage((int)dimension2D.getWidth() + 3, (int)dimension2D.getHeight() + 1, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (fRFont.getSize() <= 14) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setPaint(fRFont.getForeground());
        graphics2D.setFont((Font)fRFont);
        graphics2D.drawString(string, 2, fRFont.getSize());
        graphics2D.dispose();
        bufferedImage.flush();
        return bufferedImage;
    }

    public static Point2D getArc2DCenterAnglePoint(Shape shape) {
        if (!(shape instanceof Arc2D)) {
            return null;
        }
        Arc2D arc2D = (Arc2D)shape;
        double d = Math.toRadians(-arc2D.getAngleStart() - arc2D.getAngleExtent() / 2.0);
        double d2 = arc2D.getX() + (Math.cos(d) * 0.5 + 0.5) * arc2D.getWidth();
        double d3 = arc2D.getY() + (Math.sin(d) * 0.5 + 0.5) * arc2D.getHeight();
        return new Point2D.Double(d2, d3);
    }

    public static AttrFillStyle getColorFillStyleInPre() {
        ChartPreStyle chartPreStyle;
        AttrFillStyle attrFillStyle;
        ChartPreStyleManagerProvider chartPreStyleManagerProvider = ChartPreStyleServerManager.getProviderInstance();
        Object object = chartPreStyleManagerProvider.getStyleEditing();
        if (object instanceof ChartPreStyle) {
            ChartPreStyle chartPreStyle2 = (ChartPreStyle)object;
            return chartPreStyle2.getAttrFillStyle();
        }
        Object object2 = chartPreStyleManagerProvider.getDefaultPreStyle();
        if (object2 instanceof ChartPreStyle && (attrFillStyle = (chartPreStyle = (ChartPreStyle)object2).getAttrFillStyle()) != null) {
            attrFillStyle.setFillStyleName(chartPreStyleManagerProvider.getCurrentStyle());
            return attrFillStyle;
        }
        return null;
    }

    public static int getStyleInPre() {
        ChartPreStyleManagerProvider chartPreStyleManagerProvider = ChartPreStyleServerManager.getProviderInstance();
        Object object = chartPreStyleManagerProvider.getStyleEditing();
        if (object instanceof ChartPreStyle) {
            ChartPreStyle chartPreStyle = (ChartPreStyle)object;
            return chartPreStyle.getPrePlotStyle();
        }
        Object object2 = chartPreStyleManagerProvider.getDefaultPreStyle();
        if (object2 instanceof ChartPreStyle) {
            ChartPreStyle chartPreStyle = (ChartPreStyle)object2;
            return chartPreStyle.getPrePlotStyle();
        }
        return 0;
    }

    public static Color brighterWithFactor(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n4, n4, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255));
    }

    public static GeneralPath getBoundsWithoutTop(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f, f2 + f4);
        generalPath.lineTo(f + f3, f2 + f4);
        generalPath.lineTo(f + f3, f2);
        return generalPath;
    }

    public static GeneralPath getBoundsWithoutBottom(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2 + f4);
        generalPath.lineTo(f, f2);
        generalPath.lineTo(f + f3, f2);
        generalPath.lineTo(f + f3, f2 + f4);
        return generalPath;
    }

    public static GeneralPath getBoundsWithoutLeft(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f + f3, f2);
        generalPath.lineTo(f + f3, f2 + f4);
        generalPath.lineTo(f, f2 + f4);
        return generalPath;
    }

    public static GeneralPath getBoundsWithoutRight(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f + f3, f2 + f4);
        generalPath.lineTo(f, f2 + f4);
        generalPath.lineTo(f, f2);
        generalPath.lineTo(f + f3, f2);
        return generalPath;
    }

    public static GeneralPath getBoundsLeftAndRight(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f, f2 + f4);
        generalPath.moveTo(f + f3, f2);
        generalPath.lineTo(f + f3, f2 + f4);
        return generalPath;
    }

    public static GeneralPath getBoundsTopAndBottom(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new GeneralPath();
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f + f3, f2);
        generalPath.moveTo(f, f2 + f4);
        generalPath.lineTo(f + f3, f2 + f4);
        return generalPath;
    }

    public static void curveTo(GeneralPath generalPath, GeneralPath generalPath2) {
        Object[] objectArray;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        PathIterator pathIterator = generalPath2.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            objectArray = new double[2];
            pathIterator.currentSegment((double[])objectArray);
            pathIterator.next();
            arrayList.add((double[])objectArray);
        }
        if (arrayList.size() <= 2) {
            generalPath.append(generalPath2, true);
        } else {
            Object[] objectArray2;
            objectArray = new float[arrayList.size()];
            float[] fArray = new float[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray2 = (double[])arrayList.get(i);
                objectArray[i] = (float)objectArray2[0];
                fArray[i] = (float)objectArray2[1];
            }
            float[] fArray2 = new float[arrayList.size() - 1];
            objectArray2 = new float[arrayList.size() - 1];
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i] = (float)((objectArray[i] + objectArray[i + 1]) / 2.0f);
                objectArray2[i] = (fArray[i] + fArray[i + 1]) / 2.0f;
            }
            float[] fArray3 = new float[(objectArray.length - 2) * 2];
            float[] fArray4 = new float[(fArray.length - 2) * 2];
            for (int i = 1; i < fArray2.length; ++i) {
                double d = objectArray[i] - (fArray2[i - 1] + fArray2[i]) / 2.0f;
                float f = fArray[i] - (objectArray2[i - 1] + objectArray2[i]) / 2.0f;
                fArray3[(i - 1) * 2] = (float)(objectArray[i] + (fArray2[i - 1] + d - objectArray[i]) * 0.6f);
                fArray4[(i - 1) * 2] = fArray[i] + (objectArray2[i - 1] + f - fArray[i]) * 0.6f;
                fArray3[(i - 1) * 2 + 1] = (float)(objectArray[i] + (fArray2[i] + d - objectArray[i]) * 0.6f);
                fArray4[(i - 1) * 2 + 1] = fArray[i] + (objectArray2[i] + f - fArray[i]) * 0.6f;
            }
            GeneralPath generalPath3 = new GeneralPath(1);
            generalPath3.moveTo((float)objectArray[0], fArray[0]);
            for (int i = 1; i < objectArray.length; ++i) {
                if (i == 1) {
                    generalPath3.quadTo(fArray3[0], fArray4[0], (float)objectArray[i], fArray[i]);
                    continue;
                }
                if (i == objectArray.length - 1) {
                    generalPath3.quadTo(fArray3[fArray3.length - 1], fArray4[fArray4.length - 1], (float)objectArray[i], fArray[i]);
                    continue;
                }
                generalPath3.curveTo(fArray3[(i - 1) * 2 - 1], fArray4[(i - 1) * 2 - 1], fArray3[(i - 1) * 2], fArray4[(i - 1) * 2], (float)objectArray[i], fArray[i]);
            }
            generalPath.append(generalPath3, true);
        }
    }

    public static Object string2FormulaStr(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        String string2 = "";
        String[] stringArray = StableUtils.splitString((String)string.trim(), (char)',');
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = StableUtils.splitString((String)stringArray[i].trim(), (char)':');
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                boolean bl = true;
                for (int j = 0; j < stringArray2.length; ++j) {
                    ColumnRow columnRow = BaseUtils.convertCellStringToColumnRow((String)stringArray2[j].trim());
                    if (ColumnRow.validate((ColumnRow)columnRow)) continue;
                    bl = false;
                }
                if (bl) {
                    if (i == 0) {
                        string2 = stringArray[i].trim();
                        continue;
                    }
                    string2 = string2 + ", " + stringArray[i].trim();
                    continue;
                }
                string2 = i == 0 ? "\"" + stringArray[i].trim() + "\"" : string2 + ", \"" + stringArray[i].trim() + "\"";
            }
            if (stringArray.length > 1) {
                return new Formula("[" + string2 + "]");
            }
            if (!(stringArray.length != 1 || string2.startsWith("\"") && string2.endsWith("\""))) {
                return new Formula(string2);
            }
            return stringArray[0].trim();
        }
        return string2;
    }

    public static boolean rectangleOverlapped(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (rectangle2D == null || rectangle2D2 == null) {
            return true;
        }
        double d = Math.max(rectangle2D.getX(), rectangle2D2.getX());
        double d2 = Math.max(rectangle2D.getY(), rectangle2D2.getY());
        double d3 = Math.min(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D2.getX() + rectangle2D2.getWidth());
        double d4 = Math.min(rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D2.getY() + rectangle2D2.getHeight());
        return d <= d3 && d2 <= d4;
    }

    public static Color getColorFromBaseColor(Color color, double d, double d2, double d3) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        fArray[0] = fArray[0] + (float)d;
        fArray[1] = fArray[1] + (float)d2;
        fArray[2] = fArray[2] + (float)d3;
        return ChartUtils.HSB2RGB(fArray[0], fArray[1], fArray[2]);
    }

    private static Color HSB2RGB(float f, float f2, float f3) {
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f >= 360.0f) {
            f = 360.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return Color.getHSBColor(f, f2, f3);
    }

    public static Color getShadeStartColor(Color color, float f) {
        float[] fArray = color.getRGBColorComponents(new float[3]);
        float[] fArray2 = new float[3];
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            fArray2[i] = (double)f2 <= 0.5 ? 2.0f * f2 * (1.0f - f) : 1.0f - 2.0f * (1.0f - f2) * f;
        }
        return new Color(fArray2[0], fArray2[1], fArray2[2]);
    }

    public static Color getShadeEndColor(Color color, float f) {
        float[] fArray = color.getRGBColorComponents(new float[3]);
        float[] fArray2 = new float[3];
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            fArray2[i] = (double)f2 <= 0.5 ? 2.0f * f2 * f : 1.0f - 2.0f * (1.0f - f2) * (1.0f - f);
        }
        return new Color(fArray2[0], fArray2[1], fArray2[2]);
    }

    public static String getPositionString(int n) {
        return POS_STRING.get(n) == null ? "" : POS_STRING.get(n);
    }

    public static String getColorStyleString(int n) {
        return FILL_STYLE.get(n) == null ? "fill" : FILL_STYLE.get(n);
    }

    public static String getPlotStyleString(int n) {
        return PLOT_STYLE.get(n) == null ? "" : PLOT_STYLE.get(n);
    }

    public static String getDefinedColorsByName(String string) {
        ChartPreStyleManagerProvider chartPreStyleManagerProvider = ChartPreStyleServerManager.getProviderInstance();
        Iterator iterator = chartPreStyleManagerProvider.names();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            arrayList.add(Utils.objectToString(e));
        }
        int n = arrayList.indexOf(string);
        if (n >= 0 && n < DEFINED_COLORS.length) {
            return DEFINED_COLORS[n];
        }
        return "";
    }

    public static String getConditionName(String string) {
        String[] stringArray = CONDITION_NAME.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!ComparatorUtils.equals((String)Inter.getLocText((String)stringArray[i]), (String)string)) continue;
            return CONDITION_NAME.get(stringArray[i]);
        }
        return "";
    }
}

