/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.BaseXMLUtils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.TextAttr;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.text.Format;
import java.util.regex.Pattern;

public class AttrContents
extends DataSeriesCondition {
    private static final long serialVersionUID = -1909328717512675726L;
    public static final String XML_TAG = "AttrContents";
    public static String RelineSeparation = "\n";
    private String seriesLabel = null;
    private int position = 1;
    private boolean isShowGuidLine = false;
    private boolean isShowMutiSeries = false;
    private boolean isWhiteBackground = true;
    private TextAttr textAttr = null;
    private Format format = null;
    private Format percentFormat = null;

    public AttrContents() {
    }

    public AttrContents(String string) {
        this.seriesLabel = string;
    }

    public void setSeriesLabel(String string) {
        this.seriesLabel = string;
    }

    public String getSeriesLabel() {
        return this.seriesLabel;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public void setTextAttr(TextAttr textAttr) {
        this.textAttr = textAttr;
    }

    public TextAttr getTextAttr() {
        return this.textAttr;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setPercentFormat(Format format) {
        this.percentFormat = format;
    }

    public Format getPercentFormat() {
        return this.percentFormat;
    }

    public void setShowGuidLine(boolean bl) {
        this.isShowGuidLine = bl;
    }

    public boolean isShowGuidLine() {
        return this.isShowGuidLine;
    }

    public boolean isShowMutiSeries() {
        return this.isShowMutiSeries;
    }

    public void setShowMutiSeries(boolean bl) {
        this.isShowMutiSeries = bl;
    }

    public boolean isWhiteBackground() {
        return this.isWhiteBackground;
    }

    public void setWhiteBackground(boolean bl) {
        this.isWhiteBackground = bl;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Attr")) {
                this.isShowGuidLine = xMLableReader.getAttrAsBoolean("showLine", false);
                this.seriesLabel = xMLableReader.getAttrAsString("seriesLabel", null);
                if (this.seriesLabel != null && this.seriesLabel.indexOf("%") != -1) {
                    this.seriesLabel = Pattern.compile("%").matcher(this.seriesLabel).replaceAll("");
                }
                this.position = xMLableReader.getAttrAsInt("position", 1);
                if (this.isShowGuidLine) {
                    this.position = 6;
                }
                this.isWhiteBackground = xMLableReader.getAttrAsBoolean("isWhiteBackground", true);
                this.isShowMutiSeries = xMLableReader.getAttrAsBoolean("isShowMutiSeries", false);
            } else if ("TextAttr".equals(string)) {
                this.setTextAttr((TextAttr)xMLableReader.readXMLObject((XMLReadable)new TextAttr()));
            } else if ("Format".equals(string)) {
                this.setFormat(BaseXMLUtils.readFormat((XMLableReader)xMLableReader));
            } else if ("PercentFormat".equals(string)) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && "Format".equals(xMLableReader.getTagName())) {
                            AttrContents.this.setPercentFormat(BaseXMLUtils.readFormat((XMLableReader)xMLableReader));
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("Attr").attr("showLine", this.isShowGuidLine).attr("position", this.position).attr("isWhiteBackground", this.isWhiteBackground).attr("isShowMutiSeries", this.isShowMutiSeries);
        if (this.seriesLabel != null) {
            xMLPrintWriter.attr("seriesLabel", this.seriesLabel);
        }
        xMLPrintWriter.end();
        if (this.textAttr != null) {
            this.textAttr.writeXML(xMLPrintWriter);
        }
        if (this.format != null) {
            BaseXMLUtils.writeFormat((XMLPrintWriter)xMLPrintWriter, (Format)this.format);
        }
        if (this.percentFormat != null) {
            xMLPrintWriter.startTAG("PercentFormat");
            BaseXMLUtils.writeFormat((XMLPrintWriter)xMLPrintWriter, (Format)this.percentFormat);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrContents && ((AttrContents)object).isShowGuidLine == this.isShowGuidLine && this.position == ((AttrContents)object).position && this.isWhiteBackground == ((AttrContents)object).isWhiteBackground && this.isShowMutiSeries == ((AttrContents)object).isShowMutiSeries && ComparatorUtils.equals((String)((AttrContents)object).seriesLabel, (String)this.seriesLabel) && ComparatorUtils.equals((Object)((AttrContents)object).format, (Object)this.format) && ComparatorUtils.equals((Object)((AttrContents)object).textAttr, (Object)this.textAttr) && ComparatorUtils.equals((Object)((AttrContents)object).percentFormat, (Object)this.percentFormat);
    }

    public Object clone() throws CloneNotSupportedException {
        AttrContents attrContents = (AttrContents)super.clone();
        if (this.seriesLabel != null) {
            attrContents.setSeriesLabel(this.seriesLabel);
        }
        if (this.format != null) {
            attrContents.format = (Format)this.format.clone();
        }
        if (this.textAttr != null) {
            attrContents.textAttr = (TextAttr)this.textAttr.clone();
        }
        if (this.percentFormat != null) {
            attrContents.percentFormat = (Format)this.percentFormat.clone();
        }
        attrContents.isWhiteBackground = this.isWhiteBackground;
        return attrContents;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("seriesLabel", (Object)this.seriesLabel);
        jSONObject.put("isShowGuidLine", this.isShowGuidLine);
        jSONObject.put("position", this.position);
        if (this.format != null) {
            jSONObject.put("valueFormat", (Object)ChartBaseUtils.format2JS(this.format, repository));
        }
        if (this.textAttr != null) {
            jSONObject.put("textAttr", (Object)this.textAttr.toJSONObject());
        }
        if (this.percentFormat != null) {
            jSONObject.put("percentFormat", (Object)ChartBaseUtils.format2JS(this.percentFormat, repository));
        }
        jSONObject.put("isWhiteBackground", this.isWhiteBackground);
        jSONObject.put("isShowMutiSeries", this.isShowMutiSeries);
        return jSONObject;
    }

    public String getConditionType() {
        return XML_TAG;
    }
}

