/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxICanvas2D;
import java.util.Hashtable;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class mxSaxOutputHandler
extends DefaultHandler {
    protected mxICanvas2D canvas;
    protected transient Map<String, IElementHandler> handlers = new Hashtable<String, IElementHandler>();

    public mxSaxOutputHandler(mxICanvas2D canvas) {
        this.setCanvas(canvas);
        this.initHandlers();
    }

    public void setCanvas(mxICanvas2D value) {
        this.canvas = value;
    }

    public mxICanvas2D getCanvas() {
        return this.canvas;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        IElementHandler handler = this.handlers.get(qName.toLowerCase());
        if (handler != null) {
            handler.parseElement(atts);
        }
    }

    protected void initHandlers() {
        this.handlers.put("save", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.save();
            }
        });
        this.handlers.put("restore", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.restore();
            }
        });
        this.handlers.put("scale", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.scale(Double.parseDouble(atts.getValue("scale")));
            }
        });
        this.handlers.put("translate", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.translate(Double.parseDouble(atts.getValue("dx")), Double.parseDouble(atts.getValue("dy")));
            }
        });
        this.handlers.put("rotate", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.rotate(Double.parseDouble(atts.getValue("theta")), atts.getValue("flipH").equals("1"), atts.getValue("flipV").equals("1"), Double.parseDouble(atts.getValue("cx")), Double.parseDouble(atts.getValue("cy")));
            }
        });
        this.handlers.put("strokewidth", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setStrokeWidth(Double.parseDouble(atts.getValue("width")));
            }
        });
        this.handlers.put("strokecolor", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setStrokeColor(atts.getValue("color"));
            }
        });
        this.handlers.put("dashed", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setDashed(atts.getValue("dashed").equals("1"));
            }
        });
        this.handlers.put("dashpattern", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setDashPattern(atts.getValue("pattern"));
            }
        });
        this.handlers.put("linecap", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setLineCap(atts.getValue("cap"));
            }
        });
        this.handlers.put("linejoin", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setLineJoin(atts.getValue("join"));
            }
        });
        this.handlers.put("miterlimit", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setMiterLimit(Double.parseDouble(atts.getValue("limit")));
            }
        });
        this.handlers.put("fontsize", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setFontSize(Double.parseDouble(atts.getValue("size")));
            }
        });
        this.handlers.put("fontcolor", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setFontColor(atts.getValue("color"));
            }
        });
        this.handlers.put("fontfamily", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setFontFamily(atts.getValue("family"));
            }
        });
        this.handlers.put("fontstyle", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setFontStyle(Integer.parseInt(atts.getValue("style")));
            }
        });
        this.handlers.put("alpha", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setAlpha(Double.parseDouble(atts.getValue("alpha")));
            }
        });
        this.handlers.put("fillcolor", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setFillColor(atts.getValue("color"));
            }
        });
        this.handlers.put("gradient", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setGradient(atts.getValue("c1"), atts.getValue("c2"), Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("w")), Double.parseDouble(atts.getValue("h")), atts.getValue("direction"));
            }
        });
        this.handlers.put("glass", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.setGlassGradient(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("w")), Double.parseDouble(atts.getValue("h")));
            }
        });
        this.handlers.put("rect", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.rect(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("w")), Double.parseDouble(atts.getValue("h")));
            }
        });
        this.handlers.put("roundrect", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.roundrect(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("w")), Double.parseDouble(atts.getValue("h")), Double.parseDouble(atts.getValue("dx")), Double.parseDouble(atts.getValue("dy")));
            }
        });
        this.handlers.put("ellipse", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.ellipse(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("w")), Double.parseDouble(atts.getValue("h")));
            }
        });
        this.handlers.put("image", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.image(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("w")), Double.parseDouble(atts.getValue("h")), atts.getValue("src"), atts.getValue("aspect").equals("1"), atts.getValue("flipH").equals("1"), atts.getValue("flipV").equals("1"));
            }
        });
        this.handlers.put("text", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.text(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")), Double.parseDouble(atts.getValue("w")), Double.parseDouble(atts.getValue("h")), atts.getValue("str"), atts.getValue("align"), atts.getValue("valign"), atts.getValue("vertical").equals("1"), mxSaxOutputHandler.this.getValue(atts, "wrap", "").equals("1"), atts.getValue("format"));
            }
        });
        this.handlers.put("begin", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.begin();
            }
        });
        this.handlers.put("move", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.moveTo(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")));
            }
        });
        this.handlers.put("line", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.lineTo(Double.parseDouble(atts.getValue("x")), Double.parseDouble(atts.getValue("y")));
            }
        });
        this.handlers.put("quad", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.quadTo(Double.parseDouble(atts.getValue("x1")), Double.parseDouble(atts.getValue("y1")), Double.parseDouble(atts.getValue("x2")), Double.parseDouble(atts.getValue("y2")));
            }
        });
        this.handlers.put("curve", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.curveTo(Double.parseDouble(atts.getValue("x1")), Double.parseDouble(atts.getValue("y1")), Double.parseDouble(atts.getValue("x2")), Double.parseDouble(atts.getValue("y2")), Double.parseDouble(atts.getValue("x3")), Double.parseDouble(atts.getValue("y3")));
            }
        });
        this.handlers.put("close", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.close();
            }
        });
        this.handlers.put("stroke", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.stroke();
            }
        });
        this.handlers.put("fill", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.fill();
            }
        });
        this.handlers.put("fillstroke", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.fillAndStroke();
            }
        });
        this.handlers.put("shadow", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.shadow(atts.getValue("value"), mxSaxOutputHandler.this.getValue(atts, "filled", "1").equals("1"));
            }
        });
        this.handlers.put("clip", new IElementHandler(){

            public void parseElement(Attributes atts) {
                mxSaxOutputHandler.this.canvas.clip();
            }
        });
    }

    protected String getValue(Attributes atts, String name, String defaultValue) {
        String value = atts.getValue(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected static interface IElementHandler {
        public void parseElement(Attributes var1);
    }
}

