/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;
import org.jbpm.JbpmException;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

public class JtaDbPersistenceService
extends DbPersistenceService {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog((Class)JtaDbPersistenceService.class);
    private UserTransaction userTransaction;

    public JtaDbPersistenceService(DbPersistenceServiceFactory persistenceServiceFactory) {
        super(persistenceServiceFactory);
        if (!this.isJtaTransactionInProgress()) {
            this.beginJtaTransaction();
        }
    }

    protected boolean isTransactionActive() {
        return this.isJtaTxCreated();
    }

    public void close() {
        super.close();
        if (this.userTransaction != null) {
            this.endJtaTransaction();
        }
    }

    boolean isJtaTransactionInProgress() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.persistenceServiceFactory.getSessionFactory();
        return JTAHelper.isTransactionInProgress((SessionFactoryImplementor)sessionFactory);
    }

    void beginJtaTransaction() {
        try {
            log.debug((Object)"start user JTA transaction");
            this.userTransaction = this.getUserTransaction();
            this.userTransaction.begin();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't start JTA transaction", e);
        }
    }

    void endJtaTransaction() {
        if (this.isRollbackOnly() || JTAHelper.isRollback((int)this.getJtaTransactionStatus())) {
            log.debug((Object)"end jta transation with ROLLBACK");
            try {
                this.userTransaction.rollback();
            }
            catch (Exception e) {
                throw new JbpmException("couldn't rollback JTA transaction", e);
            }
        }
        log.debug((Object)"end jta transation with COMMIT");
        try {
            this.userTransaction.commit();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't commit JTA transaction", e);
        }
    }

    UserTransaction getUserTransaction() {
        String jndiName = this.persistenceServiceFactory.getConfiguration().getProperty("jta.UserTransaction");
        if (jndiName == null) {
            jndiName = "java:comp/UserTransaction";
        }
        try {
            return (UserTransaction)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new JbpmException("couldn't lookup UserTransaction in JNDI with name " + jndiName, e);
        }
    }

    int getJtaTransactionStatus() {
        try {
            return this.userTransaction.getStatus();
        }
        catch (SystemException e) {
            throw new JbpmException("couldn't get status for user transaction", e);
        }
    }

    public boolean isJtaTxCreated() {
        return this.userTransaction != null;
    }
}

