/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.cert.X509Extension;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.tsp.TimeStampReq;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPUtil;
import org.bouncycastle.tsp.TSPValidationException;

public class TimeStampRequest
implements X509Extension {
    private TimeStampReq req;
    private X509Extensions extensions;

    public TimeStampRequest(TimeStampReq req) {
        this.req = req;
        this.extensions = req.getExtensions();
    }

    public TimeStampRequest(byte[] req) throws IOException {
        this(new ByteArrayInputStream(req));
    }

    public TimeStampRequest(InputStream in) throws IOException {
        try {
            this.req = TimeStampReq.getInstance(new ASN1InputStream(in).readObject());
        }
        catch (ClassCastException e) {
            throw new IOException("malformed request: " + e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("malformed request: " + e);
        }
    }

    public int getVersion() {
        return this.req.getVersion().getValue().intValue();
    }

    public String getMessageImprintAlgOID() {
        return this.req.getMessageImprint().getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getMessageImprintDigest() {
        return this.req.getMessageImprint().getHashedMessage();
    }

    public String getReqPolicy() {
        if (this.req.getReqPolicy() != null) {
            return this.req.getReqPolicy().getId();
        }
        return null;
    }

    public BigInteger getNonce() {
        if (this.req.getNonce() != null) {
            return this.req.getNonce().getValue();
        }
        return null;
    }

    public boolean getCertReq() {
        if (this.req.getCertReq() != null) {
            return this.req.getCertReq().isTrue();
        }
        return false;
    }

    public void validate(Set algorithms, Set policies, Set extensions, String provider) throws TSPException, NoSuchProviderException {
        int digestLength;
        if (!algorithms.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm.", 128);
        }
        if (policies != null && this.getReqPolicy() != null && !policies.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy.", 256);
        }
        if (this.getExtensions() != null && extensions != null) {
            Enumeration en = this.getExtensions().oids();
            while (en.hasMoreElements()) {
                String oid = ((DERObjectIdentifier)en.nextElement()).getId();
                if (extensions.contains(oid)) continue;
                throw new TSPValidationException("request contains unknown extension.", 0x800000);
            }
        }
        if ((digestLength = TSPUtil.getDigestLength(this.getMessageImprintAlgOID())) != this.getMessageImprintDigest().length) {
            throw new TSPValidationException("imprint digest the wrong length.", 4);
        }
    }

    public void validate(Set algorithms, Set policies, Set extensions) throws TSPException {
        int digestLength;
        if (!algorithms.contains(this.getMessageImprintAlgOID())) {
            throw new TSPValidationException("request contains unknown algorithm.", 128);
        }
        if (policies != null && this.getReqPolicy() != null && !policies.contains(this.getReqPolicy())) {
            throw new TSPValidationException("request contains unknown policy.", 256);
        }
        if (this.getExtensions() != null && extensions != null) {
            Enumeration en = this.getExtensions().oids();
            while (en.hasMoreElements()) {
                String oid = ((DERObjectIdentifier)en.nextElement()).getId();
                if (extensions.contains(oid)) continue;
                throw new TSPValidationException("request contains unknown extension.", 0x800000);
            }
        }
        if ((digestLength = TSPUtil.getDigestLength(this.getMessageImprintAlgOID())) != this.getMessageImprintDigest().length) {
            throw new TSPValidationException("imprint digest the wrong length.", 4);
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.req.getEncoded();
    }

    X509Extensions getExtensions() {
        return this.extensions;
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public org.bouncycastle.asn1.x509.X509Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return TSPUtil.getExtensionOIDs(this.extensions);
    }

    public byte[] getExtensionValue(String oid) {
        org.bouncycastle.asn1.x509.X509Extension ext;
        X509Extensions exts = this.req.getExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            try {
                return ext.getValue().getEncoded();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }

    private Set getExtensionOIDS(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.req.getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                org.bouncycastle.asn1.x509.X509Extension ext = extensions.getExtension(oid);
                if (ext.isCritical() != critical) continue;
                set.add(oid.getId());
            }
            return set;
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDS(false);
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDS(true);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }
}

