/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedData;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle.cms.IntRecipientInfoGenerator;
import org.bouncycastle.cms.MacOutputStream;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedDataGenerator() {
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(typedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authData;
        ByteArrayOutputStream bOut;
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        Iterator it = this.recipientInfoGenerators.iterator();
        while (it.hasNext()) {
            RecipientInfoGenerator recipient = (RecipientInfoGenerator)it.next();
            recipientInfos.add(recipient.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString macResult;
            BERConstructedOctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream out = new TeeOutputStream(digestCalculator.getOutputStream(), bOut);
                typedData.write(out);
                ((OutputStream)out).close();
                encContent = new BERConstructedOctetString(bOut.toByteArray());
            }
            catch (IOException e) {
                throw new CMSException("unable to perform digest calculation: " + e.getMessage(), e);
            }
            Map parameters = this.getBaseParameters(typedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            DERSet authed = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector());
            try {
                OutputStream mOut = macCalculator.getOutputStream();
                mOut.write(authed.getDEREncoded());
                mOut.close();
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(null, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), eci, authed, macResult, unauthed);
        } else {
            DEROctetString macResult;
            BERConstructedOctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream mOut = new TeeOutputStream(bOut, macCalculator.getOutputStream());
                typedData.write(mOut);
                ((OutputStream)mOut).close();
                encContent = new BERConstructedOctetString(bOut.toByteArray());
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.EMPTY_MAP).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(null, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), null, eci, null, macResult, unauthed);
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authenticatedData, authData);
        return new CMSAuthenticatedData(contentInfo, new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }

    public CMSAuthenticatedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    private CMSAuthenticatedData generate(CMSProcessable content, String macOID, KeyGenerator keyGen, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Object recipient;
        DEROctetString macResult;
        BERConstructedOctetString encContent;
        AlgorithmIdentifier macAlgId;
        SecretKey encKey;
        Provider encProvider = keyGen.getProvider();
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        try {
            Mac mac = CMSEnvelopedHelper.INSTANCE.getMac(macOID, encProvider);
            encKey = keyGen.generateKey();
            AlgorithmParameterSpec params = this.generateParameterSpec(macOID, encKey, encProvider);
            mac.init(encKey, params);
            macAlgId = this.getAlgorithmIdentifier(macOID, params, encProvider);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            TeeOutputStream mOut = new TeeOutputStream(bOut, new MacOutputStream(mac));
            content.write(mOut);
            ((OutputStream)mOut).close();
            bOut.close();
            encContent = new BERConstructedOctetString(bOut.toByteArray());
            macResult = new DEROctetString(mac.doFinal());
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException("algorithm parameters invalid.", e);
        }
        catch (IOException e) {
            throw new CMSException("exception decoding algorithm parameters.", e);
        }
        catch (InvalidParameterSpecException e) {
            throw new CMSException("exception setting up parameters.", e);
        }
        Iterator it = this.oldRecipientInfoGenerators.iterator();
        while (it.hasNext()) {
            recipient = (IntRecipientInfoGenerator)it.next();
            try {
                recipientInfos.add(recipient.generate(encKey, this.rand, provider));
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for algorithm.", e);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("error making encrypted content.", e);
            }
        }
        it = this.recipientInfoGenerators.iterator();
        while (it.hasNext()) {
            recipient = (RecipientInfoGenerator)it.next();
            recipientInfos.add(recipient.generate(new GenericKey(encKey)));
        }
        ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authenticatedData, new AuthenticatedData(null, new DERSet(recipientInfos), macAlgId, null, eci, null, macResult, null));
        return new CMSAuthenticatedData(contentInfo);
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String macOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, macOID, CMSUtils.getProvider(provider));
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        keyGen.init(this.rand);
        return this.generate(content, encryptionOID, keyGen, provider);
    }
}

