/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;

public class AutoThresholder {
    private static String[] mStrings;
    public static final int Default = 0;
    public static final int Huang = 1;
    public static final int Intermodes = 2;
    public static final int IsoData = 3;
    public static final int IJ_IsoData = 4;
    public static final int Li = 5;
    public static final int MaxEntropy = 6;
    public static final int Mean = 7;
    public static final int MinError = 8;
    public static final int Minimum = 9;
    public static final int Moments = 10;
    public static final int Otsu = 11;
    public static final int Percentile = 12;
    public static final int RenyiEntropy = 13;
    public static final int Shanbhag = 14;
    public static final int Triangle = 15;
    public static final int Yen = 16;

    public static String[] getMethods() {
        if (mStrings == null) {
            int[] nArray = new int[17];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 8;
            nArray[9] = 9;
            nArray[10] = 10;
            nArray[11] = 11;
            nArray[12] = 12;
            nArray[13] = 13;
            nArray[14] = 14;
            nArray[15] = 15;
            nArray[16] = 16;
            int[] mVals = nArray;
            mStrings = new String[mVals.length];
            int i = 0;
            while (i < mVals.length) {
                AutoThresholder.mStrings[i] = "" + mVals[i];
                ++i;
            }
        }
        return mStrings;
    }

    public static int getInt(String name) {
        if (name.equals("Default")) {
            return 0;
        }
        if (name.equals("IJ_IsoData")) {
            return 4;
        }
        if (name.equals("Huang")) {
            return 1;
        }
        if (name.equals("Intermodes")) {
            return 2;
        }
        if (name.equals("IsoData")) {
            return 3;
        }
        if (name.equals("Li")) {
            return 5;
        }
        if (name.equals("MaxEntropy")) {
            return 6;
        }
        if (name.equals("Mean")) {
            return 7;
        }
        if (name.equals("MinError")) {
            return 8;
        }
        if (name.equals("Minimum")) {
            return 9;
        }
        if (name.equals("Moments")) {
            return 10;
        }
        if (name.equals("Otsu")) {
            return 11;
        }
        if (name.equals("Percentile")) {
            return 12;
        }
        if (name.equals("RenyiEntropy")) {
            return 13;
        }
        if (name.equals("Shanbhag")) {
            return 14;
        }
        if (name.equals("Triangle")) {
            return 15;
        }
        if (name.equals("Yen")) {
            return 16;
        }
        return 0;
    }

    public int getThreshold(int method, int[] histogram) {
        int threshold = 0;
        switch (method) {
            case 0: {
                threshold = this.defaultIsoData(histogram);
                break;
            }
            case 4: {
                threshold = this.IJIsoData(histogram);
                break;
            }
            case 1: {
                threshold = this.Huang(histogram);
                break;
            }
            case 2: {
                threshold = this.Intermodes(histogram);
                break;
            }
            case 3: {
                threshold = this.IsoData(histogram);
                break;
            }
            case 5: {
                threshold = this.Li(histogram);
                break;
            }
            case 6: {
                threshold = this.MaxEntropy(histogram);
                break;
            }
            case 7: {
                threshold = this.Mean(histogram);
                break;
            }
            case 8: {
                threshold = this.MinErrorI(histogram);
                break;
            }
            case 9: {
                threshold = this.Minimum(histogram);
                break;
            }
            case 10: {
                threshold = this.Moments(histogram);
                break;
            }
            case 11: {
                threshold = this.Otsu(histogram);
                break;
            }
            case 12: {
                threshold = this.Percentile(histogram);
                break;
            }
            case 13: {
                threshold = this.RenyiEntropy(histogram);
                break;
            }
            case 14: {
                threshold = this.Shanbhag(histogram);
                break;
            }
            case 15: {
                threshold = this.Triangle(histogram);
                break;
            }
            case 16: {
                threshold = this.Yen(histogram);
            }
        }
        if (threshold == -1) {
            threshold = 0;
        }
        return threshold;
    }

    public int getThreshold(String mString, int[] histogram) {
        int index = mString.indexOf(" ");
        if (index != -1) {
            mString = mString.substring(0, index);
        }
        int method = AutoThresholder.getInt(mString);
        return this.getThreshold(method, histogram);
    }

    int Huang(int[] data) {
        int threshold = -1;
        int first_bin = 0;
        int ih = 0;
        while (ih < 256) {
            if (data[ih] != 0) {
                first_bin = ih;
                break;
            }
            ++ih;
        }
        int last_bin = 255;
        ih = 255;
        while (ih >= first_bin) {
            if (data[ih] != 0) {
                last_bin = ih;
                break;
            }
            --ih;
        }
        double term = 1.0 / (double)(last_bin - first_bin);
        double[] mu_0 = new double[256];
        double num_pix = 0.0;
        double sum_pix = 0.0;
        ih = first_bin;
        while (ih < 256) {
            mu_0[ih] = (sum_pix += (double)ih * (double)data[ih]) / (num_pix += (double)data[ih]);
            ++ih;
        }
        double[] mu_1 = new double[256];
        num_pix = 0.0;
        sum_pix = 0.0;
        ih = last_bin;
        while (ih > 0) {
            mu_1[ih - 1] = (sum_pix += (double)ih * (double)data[ih]) / (num_pix += (double)data[ih]);
            --ih;
        }
        threshold = -1;
        double min_ent = Double.MAX_VALUE;
        int it = 0;
        while (it < 256) {
            double mu_x;
            double ent = 0.0;
            ih = 0;
            while (ih <= it) {
                mu_x = 1.0 / (1.0 + term * Math.abs((double)ih - mu_0[it]));
                if (!(mu_x < 1.0E-6) && !(mu_x > 0.999999)) {
                    ent += (double)data[ih] * (-mu_x * Math.log(mu_x) - (1.0 - mu_x) * Math.log(1.0 - mu_x));
                }
                ++ih;
            }
            ih = it + 1;
            while (ih < 256) {
                mu_x = 1.0 / (1.0 + term * Math.abs((double)ih - mu_1[it]));
                if (!(mu_x < 1.0E-6) && !(mu_x > 0.999999)) {
                    ent += (double)data[ih] * (-mu_x * Math.log(mu_x) - (1.0 - mu_x) * Math.log(1.0 - mu_x));
                }
                ++ih;
            }
            if (ent < min_ent) {
                min_ent = ent;
                threshold = it;
            }
            ++it;
        }
        return threshold;
    }

    boolean bimodalTest(double[] y) {
        int len = y.length;
        boolean b = false;
        int modes = 0;
        int k = 1;
        while (k < len - 1) {
            if (y[k - 1] < y[k] && y[k + 1] < y[k] && ++modes > 2) {
                return false;
            }
            ++k;
        }
        if (modes == 2) {
            b = true;
        }
        return b;
    }

    int Intermodes(int[] data) {
        double[] iHisto = new double[256];
        int iter = 0;
        int threshold = -1;
        int i = 0;
        while (i < 256) {
            iHisto[i] = data[i];
            ++i;
        }
        while (!this.bimodalTest(iHisto)) {
            i = 1;
            while (i < 255) {
                iHisto[i] = (iHisto[i - 1] + iHisto[i] + iHisto[i + 1]) / 3.0;
                ++i;
            }
            iHisto[0] = (iHisto[0] + iHisto[1]) / 3.0;
            iHisto[255] = (iHisto[254] + iHisto[255]) / 3.0;
            if (++iter <= 10000) continue;
            threshold = -1;
            IJ.log("Intermodes: threshold not found after 10000 iterations.");
            return threshold;
        }
        int tt = 0;
        int i2 = 1;
        while (i2 < 255) {
            if (iHisto[i2 - 1] < iHisto[i2] && iHisto[i2 + 1] < iHisto[i2]) {
                tt += i2;
            }
            ++i2;
        }
        threshold = (int)Math.floor((double)tt / 2.0);
        return threshold;
    }

    int IsoData(int[] data) {
        int g;
        block5: {
            g = 0;
            int i = 1;
            while (i < 256) {
                if (data[i] > 0) {
                    g = i + 1;
                    break;
                }
                ++i;
            }
            do {
                int l = 0;
                int totl = 0;
                i = 0;
                while (i < g) {
                    totl += data[i];
                    l += data[i] * i;
                    ++i;
                }
                double h = 0.0;
                double toth = 0.0;
                i = g + 1;
                while (i < 256) {
                    toth += (double)data[i];
                    h += (double)data[i] * (double)i;
                    ++i;
                }
                if (totl > 0 && toth > 0.0 && g == (int)Math.round(((double)(l /= totl) + (h /= toth)) / 2.0)) break block5;
            } while (++g <= 254);
            return -1;
        }
        return g;
    }

    int defaultIsoData(int[] data) {
        int n = data.length;
        int[] data2 = new int[n];
        int mode = 0;
        int maxCount = 0;
        int i = 0;
        while (i < n) {
            int count = data[i];
            data2[i] = data[i];
            if (data2[i] > maxCount) {
                maxCount = data2[i];
                mode = i;
            }
            ++i;
        }
        int maxCount2 = 0;
        int i2 = 0;
        while (i2 < n) {
            if (data2[i2] > maxCount2 && i2 != mode) {
                maxCount2 = data2[i2];
            }
            ++i2;
        }
        int hmax = maxCount;
        if (hmax > maxCount2 * 2 && maxCount2 != 0) {
            data2[mode] = hmax = (int)((double)maxCount2 * 1.5);
        }
        return this.IJIsoData(data2);
    }

    int IJIsoData(int[] data) {
        double sum4;
        double sum3;
        double sum2;
        double sum1;
        double result;
        int maxValue = data.length - 1;
        int count0 = data[0];
        data[0] = 0;
        int countMax = data[maxValue];
        data[maxValue] = 0;
        int min = 0;
        while (data[min] == 0 && min < maxValue) {
            ++min;
        }
        int max = maxValue;
        while (data[max] == 0 && max > 0) {
            --max;
        }
        if (min >= max) {
            data[0] = count0;
            data[maxValue] = countMax;
            int level = data.length / 2;
            return level;
        }
        int movingIndex = min;
        int inc = Math.max(max / 40, 1);
        do {
            sum4 = 0.0;
            sum3 = 0.0;
            sum2 = 0.0;
            sum1 = 0.0;
            int i = min;
            while (i <= movingIndex) {
                sum1 += (double)i * (double)data[i];
                sum2 += (double)data[i];
                ++i;
            }
            i = movingIndex + 1;
            while (i <= max) {
                sum3 += (double)i * (double)data[i];
                sum4 += (double)data[i];
                ++i;
            }
        } while ((double)(++movingIndex + 1) <= (result = (sum1 / sum2 + sum3 / sum4) / 2.0) && movingIndex < max - 1);
        data[0] = count0;
        data[maxValue] = countMax;
        int level = (int)Math.round(result);
        return level;
    }

    int Li(int[] data) {
        int threshold;
        double old_thresh;
        double sum_obj;
        double num_obj;
        double mean_obj;
        double mean_back;
        double temp;
        double tolerance = 0.5;
        double num_pixels = 0.0;
        int ih = 0;
        while (ih < 256) {
            num_pixels += (double)data[ih];
            ++ih;
        }
        double mean = 0.0;
        ih = 1;
        while (ih < 256) {
            mean += (double)ih * (double)data[ih];
            ++ih;
        }
        double new_thresh = mean /= num_pixels;
        do {
            old_thresh = new_thresh;
            threshold = (int)(old_thresh + 0.5);
            double sum_back = 0.0;
            double num_back = 0.0;
            ih = 0;
            while (ih <= threshold) {
                sum_back += (double)ih * (double)data[ih];
                num_back += (double)data[ih];
                ++ih;
            }
            mean_back = num_back == 0.0 ? 0.0 : sum_back / num_back;
            sum_obj = 0.0;
            num_obj = 0.0;
            ih = threshold + 1;
            while (ih < 256) {
                sum_obj += (double)ih * (double)data[ih];
                num_obj += (double)data[ih];
                ++ih;
            }
        } while (Math.abs((new_thresh = (temp = (mean_back - (mean_obj = num_obj == 0.0 ? 0.0 : sum_obj / num_obj)) / (Math.log(mean_back) - Math.log(mean_obj))) < -2.220446049250313E-16 ? (double)((int)(temp - 0.5)) : (double)((int)(temp + 0.5))) - old_thresh) > tolerance);
        return threshold;
    }

    int MaxEntropy(int[] data) {
        int threshold = -1;
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P2 = new double[256];
        double total = 0.0;
        int ih = 0;
        while (ih < 256) {
            total += (double)data[ih];
            ++ih;
        }
        ih = 0;
        while (ih < 256) {
            norm_histo[ih] = (double)data[ih] / total;
            ++ih;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        ih = 1;
        while (ih < 256) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
            ++ih;
        }
        int first_bin = 0;
        ih = 0;
        while (ih < 256) {
            if (!(Math.abs(P1[ih]) < 2.220446049250313E-16)) {
                first_bin = ih;
                break;
            }
            ++ih;
        }
        int last_bin = 255;
        ih = 255;
        while (ih >= first_bin) {
            if (!(Math.abs(P2[ih]) < 2.220446049250313E-16)) {
                last_bin = ih;
                break;
            }
            --ih;
        }
        double max_ent = Double.MIN_VALUE;
        int it = first_bin;
        while (it <= last_bin) {
            double ent_back = 0.0;
            ih = 0;
            while (ih <= it) {
                if (data[ih] != 0) {
                    ent_back -= norm_histo[ih] / P1[it] * Math.log(norm_histo[ih] / P1[it]);
                }
                ++ih;
            }
            double ent_obj = 0.0;
            ih = it + 1;
            while (ih < 256) {
                if (data[ih] != 0) {
                    ent_obj -= norm_histo[ih] / P2[it] * Math.log(norm_histo[ih] / P2[it]);
                }
                ++ih;
            }
            double tot_ent = ent_back + ent_obj;
            if (max_ent < tot_ent) {
                max_ent = tot_ent;
                threshold = it;
            }
            ++it;
        }
        return threshold;
    }

    int Mean(int[] data) {
        int threshold = -1;
        double tot = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < 256) {
            tot += (double)data[i];
            sum += (double)i * (double)data[i];
            ++i;
        }
        threshold = (int)Math.floor(sum / tot);
        return threshold;
    }

    int MinErrorI(int[] data) {
        int threshold = this.Mean(data);
        int Tprev = -2;
        while (threshold != Tprev) {
            double w2;
            double w0;
            double tau2;
            double mu = this.B(data, threshold) / this.A(data, threshold);
            double nu = (this.B(data, 255) - this.B(data, threshold)) / (this.A(data, 255) - this.A(data, threshold));
            double p = this.A(data, threshold) / this.A(data, 255);
            double q = (this.A(data, 255) - this.A(data, threshold)) / this.A(data, 255);
            double sigma2 = this.C(data, threshold) / this.A(data, threshold) - mu * mu;
            double w1 = mu / sigma2 - nu / (tau2 = (this.C(data, 255) - this.C(data, threshold)) / (this.A(data, 255) - this.A(data, threshold)) - nu * nu);
            double sqterm = w1 * w1 - (w0 = 1.0 / sigma2 - 1.0 / tau2) * (w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log(sigma2 * (q * q) / (tau2 * (p * p))) / Math.log(10.0));
            if (sqterm < 0.0) {
                IJ.log("MinError(I): not converging.");
                return threshold;
            }
            Tprev = threshold;
            double temp = (w1 + Math.sqrt(sqterm)) / w0;
            if (Double.isNaN(temp)) {
                IJ.log("MinError(I): NaN, not converging.");
                threshold = Tprev;
                continue;
            }
            threshold = (int)Math.floor(temp);
        }
        return threshold;
    }

    double A(int[] y, int j) {
        double x = 0.0;
        int i = 0;
        while (i <= j) {
            x += (double)y[i];
            ++i;
        }
        return x;
    }

    double B(int[] y, int j) {
        double x = 0.0;
        int i = 0;
        while (i <= j) {
            x += (double)(i * y[i]);
            ++i;
        }
        return x;
    }

    double C(int[] y, int j) {
        double x = 0.0;
        int i = 0;
        while (i <= j) {
            x += (double)(i * i * y[i]);
            ++i;
        }
        return x;
    }

    int Minimum(int[] data) {
        int i;
        int iter = 0;
        int threshold = -1;
        double[] iHisto = new double[256];
        int i2 = 0;
        while (i2 < 256) {
            iHisto[i2] = data[i2];
            ++i2;
        }
        double[] tHisto = iHisto;
        while (!this.bimodalTest(iHisto)) {
            i = 1;
            while (i < 255) {
                tHisto[i] = (iHisto[i - 1] + iHisto[i] + iHisto[i + 1]) / 3.0;
                ++i;
            }
            tHisto[0] = (iHisto[0] + iHisto[1]) / 3.0;
            tHisto[255] = (iHisto[254] + iHisto[255]) / 3.0;
            iHisto = tHisto;
            if (++iter <= 10000) continue;
            threshold = -1;
            IJ.log("Minimum: threshold not found after 10000 iterations.");
            return threshold;
        }
        i = 1;
        while (i < 255) {
            if (iHisto[i - 1] > iHisto[i] && iHisto[i + 1] >= iHisto[i]) {
                threshold = i;
                break;
            }
            ++i;
        }
        return threshold;
    }

    int Moments(int[] data) {
        double total = 0.0;
        double m0 = 1.0;
        double m1 = 0.0;
        double m2 = 0.0;
        double m3 = 0.0;
        double sum = 0.0;
        double p0 = 0.0;
        int threshold = -1;
        double[] histo = new double[256];
        int i = 0;
        while (i < 256) {
            total += (double)data[i];
            ++i;
        }
        i = 0;
        while (i < 256) {
            histo[i] = (double)data[i] / total;
            ++i;
        }
        i = 0;
        while (i < 256) {
            double di = i;
            m1 += di * histo[i];
            m2 += di * di * histo[i];
            m3 += di * di * di * histo[i];
            ++i;
        }
        double cd = m0 * m2 - m1 * m1;
        double c0 = (-m2 * m2 + m1 * m3) / cd;
        double c1 = (m0 * -m3 + m2 * m1) / cd;
        double z0 = 0.5 * (-c1 - Math.sqrt(c1 * c1 - 4.0 * c0));
        double z1 = 0.5 * (-c1 + Math.sqrt(c1 * c1 - 4.0 * c0));
        p0 = (z1 - m1) / (z1 - z0);
        sum = 0.0;
        i = 0;
        while (i < 256) {
            if ((sum += histo[i]) > p0) {
                threshold = i;
                break;
            }
            ++i;
        }
        return threshold;
    }

    int Otsu(int[] data) {
        double L = 256.0;
        double N2 = 0.0;
        double S = 0.0;
        int k = 0;
        while ((double)k < L) {
            S += (double)k * (double)data[k];
            N2 += (double)data[k];
            ++k;
        }
        double Sk = 0.0;
        double N1 = data[0];
        double BCV = 0.0;
        double BCVmax = 0.0;
        int kStar = 0;
        k = 1;
        while ((double)k < L - 1.0) {
            double denom;
            Sk += (double)k * (double)data[k];
            if ((denom = (N1 += (double)data[k]) * (N2 - N1)) != 0.0) {
                double num = N1 / N2 * S - Sk;
                BCV = num * num / denom;
            } else {
                BCV = 0.0;
            }
            if (BCV >= BCVmax) {
                BCVmax = BCV;
                kStar = k;
            }
            ++k;
        }
        return kStar;
    }

    int Percentile(int[] data) {
        boolean iter = false;
        int threshold = -1;
        double ptile = 0.5;
        double[] avec = new double[256];
        int i = 0;
        while (i < 256) {
            avec[i] = 0.0;
            ++i;
        }
        double total = this.partialSum(data, 255);
        double temp = 1.0;
        int i2 = 0;
        while (i2 < 256) {
            avec[i2] = Math.abs(this.partialSum(data, i2) / total - ptile);
            if (avec[i2] < temp) {
                temp = avec[i2];
                threshold = i2;
            }
            ++i2;
        }
        return threshold;
    }

    double partialSum(int[] y, int j) {
        double x = 0.0;
        int i = 0;
        while (i <= j) {
            x += (double)y[i];
            ++i;
        }
        return x;
    }

    int RenyiEntropy(int[] data) {
        int beta3;
        int beta2;
        int beta1;
        int tmp_var;
        double tot_ent;
        double ent_obj;
        double ent_back;
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P2 = new double[256];
        double total = 0.0;
        int ih = 0;
        while (ih < 256) {
            total += (double)data[ih];
            ++ih;
        }
        ih = 0;
        while (ih < 256) {
            norm_histo[ih] = (double)data[ih] / total;
            ++ih;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        ih = 1;
        while (ih < 256) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
            ++ih;
        }
        int first_bin = 0;
        ih = 0;
        while (ih < 256) {
            if (!(Math.abs(P1[ih]) < 2.220446049250313E-16)) {
                first_bin = ih;
                break;
            }
            ++ih;
        }
        int last_bin = 255;
        ih = 255;
        while (ih >= first_bin) {
            if (!(Math.abs(P2[ih]) < 2.220446049250313E-16)) {
                last_bin = ih;
                break;
            }
            --ih;
        }
        int threshold = 0;
        double max_ent = 0.0;
        int it = first_bin;
        while (it <= last_bin) {
            ent_back = 0.0;
            ih = 0;
            while (ih <= it) {
                if (data[ih] != 0) {
                    ent_back -= norm_histo[ih] / P1[it] * Math.log(norm_histo[ih] / P1[it]);
                }
                ++ih;
            }
            ent_obj = 0.0;
            ih = it + 1;
            while (ih < 256) {
                if (data[ih] != 0) {
                    ent_obj -= norm_histo[ih] / P2[it] * Math.log(norm_histo[ih] / P2[it]);
                }
                ++ih;
            }
            tot_ent = ent_back + ent_obj;
            if (max_ent < tot_ent) {
                max_ent = tot_ent;
                threshold = it;
            }
            ++it;
        }
        int t_star2 = threshold;
        threshold = 0;
        max_ent = 0.0;
        double alpha = 0.5;
        double term = 1.0 / (1.0 - alpha);
        it = first_bin;
        while (it <= last_bin) {
            ent_back = 0.0;
            ih = 0;
            while (ih <= it) {
                ent_back += Math.sqrt(norm_histo[ih] / P1[it]);
                ++ih;
            }
            ent_obj = 0.0;
            ih = it + 1;
            while (ih < 256) {
                ent_obj += Math.sqrt(norm_histo[ih] / P2[it]);
                ++ih;
            }
            tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
            if (tot_ent > max_ent) {
                max_ent = tot_ent;
                threshold = it;
            }
            ++it;
        }
        int t_star1 = threshold;
        threshold = 0;
        max_ent = 0.0;
        alpha = 2.0;
        term = 1.0 / (1.0 - alpha);
        it = first_bin;
        while (it <= last_bin) {
            ent_back = 0.0;
            ih = 0;
            while (ih <= it) {
                ent_back += norm_histo[ih] * norm_histo[ih] / (P1[it] * P1[it]);
                ++ih;
            }
            ent_obj = 0.0;
            ih = it + 1;
            while (ih < 256) {
                ent_obj += norm_histo[ih] * norm_histo[ih] / (P2[it] * P2[it]);
                ++ih;
            }
            tot_ent = term * (ent_back * ent_obj > 0.0 ? Math.log(ent_back * ent_obj) : 0.0);
            if (tot_ent > max_ent) {
                max_ent = tot_ent;
                threshold = it;
            }
            ++it;
        }
        int t_star3 = threshold;
        if (t_star2 < t_star1) {
            tmp_var = t_star1;
            t_star1 = t_star2;
            t_star2 = tmp_var;
        }
        if (t_star3 < t_star2) {
            tmp_var = t_star2;
            t_star2 = t_star3;
            t_star3 = tmp_var;
        }
        if (t_star2 < t_star1) {
            tmp_var = t_star1;
            t_star1 = t_star2;
            t_star2 = tmp_var;
        }
        if (Math.abs(t_star1 - t_star2) <= 5) {
            if (Math.abs(t_star2 - t_star3) <= 5) {
                beta1 = 1;
                beta2 = 2;
                beta3 = 1;
            } else {
                beta1 = 0;
                beta2 = 1;
                beta3 = 3;
            }
        } else if (Math.abs(t_star2 - t_star3) <= 5) {
            beta1 = 3;
            beta2 = 1;
            beta3 = 0;
        } else {
            beta1 = 1;
            beta2 = 2;
            beta3 = 1;
        }
        double omega = P1[t_star3] - P1[t_star1];
        int opt_threshold = (int)((double)t_star1 * (P1[t_star1] + 0.25 * omega * (double)beta1) + 0.25 * (double)t_star2 * omega * (double)beta2 + (double)t_star3 * (P2[t_star3] + 0.25 * omega * (double)beta3));
        return opt_threshold;
    }

    int Shanbhag(int[] data) {
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P2 = new double[256];
        double total = 0.0;
        int ih = 0;
        while (ih < 256) {
            total += (double)data[ih];
            ++ih;
        }
        ih = 0;
        while (ih < 256) {
            norm_histo[ih] = (double)data[ih] / total;
            ++ih;
        }
        P1[0] = norm_histo[0];
        P2[0] = 1.0 - P1[0];
        ih = 1;
        while (ih < 256) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            P2[ih] = 1.0 - P1[ih];
            ++ih;
        }
        int first_bin = 0;
        ih = 0;
        while (ih < 256) {
            if (!(Math.abs(P1[ih]) < 2.220446049250313E-16)) {
                first_bin = ih;
                break;
            }
            ++ih;
        }
        int last_bin = 255;
        ih = 255;
        while (ih >= first_bin) {
            if (!(Math.abs(P2[ih]) < 2.220446049250313E-16)) {
                last_bin = ih;
                break;
            }
            --ih;
        }
        int threshold = -1;
        double min_ent = Double.MAX_VALUE;
        int it = first_bin;
        while (it <= last_bin) {
            double ent_back = 0.0;
            double term = 0.5 / P1[it];
            ih = 1;
            while (ih <= it) {
                ent_back -= norm_histo[ih] * Math.log(1.0 - term * P1[ih - 1]);
                ++ih;
            }
            ent_back *= term;
            double ent_obj = 0.0;
            term = 0.5 / P2[it];
            ih = it + 1;
            while (ih < 256) {
                ent_obj -= norm_histo[ih] * Math.log(1.0 - term * P2[ih]);
                ++ih;
            }
            double tot_ent = Math.abs(ent_back - (ent_obj *= term));
            if (tot_ent < min_ent) {
                min_ent = tot_ent;
                threshold = it;
            }
            ++it;
        }
        return threshold;
    }

    int Triangle(int[] data) {
        int min = 0;
        int dmax = 0;
        int max = 0;
        int min2 = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > 0) {
                min = i;
                break;
            }
            ++i;
        }
        if (min > 0) {
            --min;
        }
        i = 255;
        while (i > 0) {
            if (data[i] > 0) {
                min2 = i;
                break;
            }
            --i;
        }
        if (min2 < 255) {
            ++min2;
        }
        i = 0;
        while (i < 256) {
            if (data[i] > dmax) {
                max = i;
                dmax = data[i];
            }
            ++i;
        }
        boolean inverted = false;
        if (max - min < min2 - max) {
            inverted = true;
            int left = 0;
            int right = 255;
            while (left < right) {
                int temp = data[left];
                data[left] = data[right];
                data[right] = temp;
                ++left;
                --right;
            }
            min = 255 - min2;
            max = 255 - max;
        }
        if (min == max) {
            return min;
        }
        double nx = data[max];
        double ny = min - max;
        double d = Math.sqrt(nx * nx + ny * ny);
        nx /= d;
        ny /= d;
        d = nx * (double)min + ny * (double)data[min];
        int split = min;
        double splitDistance = 0.0;
        int i2 = min + 1;
        while (i2 <= max) {
            double newDistance = nx * (double)i2 + ny * (double)data[i2] - d;
            if (newDistance > splitDistance) {
                split = i2;
                splitDistance = newDistance;
            }
            ++i2;
        }
        --split;
        if (inverted) {
            int left = 0;
            int right = 255;
            while (left < right) {
                int temp = data[left];
                data[left] = data[right];
                data[right] = temp;
                ++left;
                --right;
            }
            return 255 - split;
        }
        return split;
    }

    int Yen(int[] data) {
        double[] norm_histo = new double[256];
        double[] P1 = new double[256];
        double[] P1_sq = new double[256];
        double[] P2_sq = new double[256];
        double total = 0.0;
        int ih = 0;
        while (ih < 256) {
            total += (double)data[ih];
            ++ih;
        }
        ih = 0;
        while (ih < 256) {
            norm_histo[ih] = (double)data[ih] / total;
            ++ih;
        }
        P1[0] = norm_histo[0];
        ih = 1;
        while (ih < 256) {
            P1[ih] = P1[ih - 1] + norm_histo[ih];
            ++ih;
        }
        P1_sq[0] = norm_histo[0] * norm_histo[0];
        ih = 1;
        while (ih < 256) {
            P1_sq[ih] = P1_sq[ih - 1] + norm_histo[ih] * norm_histo[ih];
            ++ih;
        }
        P2_sq[255] = 0.0;
        ih = 254;
        while (ih >= 0) {
            P2_sq[ih] = P2_sq[ih + 1] + norm_histo[ih + 1] * norm_histo[ih + 1];
            --ih;
        }
        int threshold = -1;
        double max_crit = Double.MIN_VALUE;
        int it = 0;
        while (it < 256) {
            double crit = -1.0 * (P1_sq[it] * P2_sq[it] > 0.0 ? Math.log(P1_sq[it] * P2_sq[it]) : 0.0) + 2.0 * (P1[it] * (1.0 - P1[it]) > 0.0 ? Math.log(P1[it] * (1.0 - P1[it])) : 0.0);
            if (crit > max_crit) {
                max_crit = crit;
                threshold = it;
            }
            ++it;
        }
        return threshold;
    }
}

