/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ContrastPlot
extends Canvas
implements MouseListener {
    static final int WIDTH = 128;
    static final int HEIGHT = 64;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Graphics osg;
    Color color = Color.gray;

    public ContrastPlot() {
        this.addMouseListener(this);
        this.setSize(129, 65);
    }

    public Dimension getPreferredSize() {
        return new Dimension(129, 65);
    }

    void setHistogram(ImageStatistics stats, Color color) {
        this.color = color;
        this.histogram = stats.histogram;
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        double scale = 0.5;
        int i = 0;
        while (i < 128) {
            int index = (int)((double)i / scale);
            this.histogram[i] = (this.histogram[index] + this.histogram[index + 1]) / 2;
            ++i;
        }
        int maxCount = 0;
        int mode = 0;
        int i2 = 0;
        while (i2 < 128) {
            if (this.histogram[i2] > maxCount) {
                maxCount = this.histogram[i2];
                mode = i2;
            }
            ++i2;
        }
        int maxCount2 = 0;
        int i3 = 0;
        while (i3 < 128) {
            if (this.histogram[i3] > maxCount2 && i3 != mode) {
                maxCount2 = this.histogram[i3];
            }
            ++i3;
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        double scale = 128.0 / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        if (this.max != this.min) {
            slope = 64.0 / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = 64;
        } else {
            x1 = 0;
            y1 = this.max > this.min ? 64 - (int)((this.defaultMin - this.min) * slope) : 64;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = 128;
            y2 = this.max > this.min ? 64 - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax != 0) {
                this.os = this.createImage(128, 64);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 128, 64);
                this.osg.setColor(this.color);
                int i = 0;
                while (i < 128) {
                    this.osg.drawLine(i, 64, i, 64 - 64 * this.histogram[i] / this.hmax);
                    ++i;
                }
                this.osg.dispose();
            }
            if (this.os != null) {
                g.drawImage(this.os, 0, 0, this);
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, 128, 64);
        }
        g.setColor(Color.black);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, 59, x2, 64);
        g.drawRect(0, 0, 128, 64);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }
}

