/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.image.IndexColorModel;

public class RGBStackMerge
implements PlugIn {
    private static boolean staticCreateComposite = true;
    private static boolean staticKeep;
    private static boolean staticIgnoreLuts;
    private ImagePlus imp;
    private byte[] blank;
    private boolean ignoreLuts;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        this.mergeStacks();
    }

    public static ImagePlus mergeChannels(ImagePlus[] images, boolean keepSourceImages) {
        RGBStackMerge rgbsm = new RGBStackMerge();
        return rgbsm.mergeHyperstacks(images, keepSourceImages);
    }

    public void mergeStacks() {
        ImagePlus imp2;
        String options;
        String none;
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            this.error("No images are open.");
            return;
        }
        String[] titles = new String[wList.length + 1];
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
            ++i;
        }
        titles[wList.length] = none = "*None*";
        boolean createComposite = staticCreateComposite;
        boolean keep = staticKeep;
        this.ignoreLuts = staticIgnoreLuts;
        if (IJ.isMacro()) {
            this.ignoreLuts = false;
            keep = false;
            createComposite = false;
        }
        boolean macro = IJ.macroRunning();
        String string = options = IJ.isMacro() ? Macro.getOptions() : null;
        if (options != null) {
            options = options.replaceAll("red=", "c1=");
            options = options.replaceAll("green=", "c2=");
            options = options.replaceAll("blue=", "c3=");
            options = options.replaceAll("gray=", "c4=");
            Macro.setOptions(options);
        }
        GenericDialog gd = new GenericDialog("Merge Channels");
        String title = titles.length > 0 && !macro ? titles[0] : none;
        gd.addChoice("C1 (red):", titles, title);
        title = titles.length > 1 && !macro ? titles[1] : none;
        gd.addChoice("C2 (green):", titles, title);
        title = titles.length > 2 && !macro ? titles[2] : none;
        gd.addChoice("C3 (blue):", titles, title);
        title = titles.length > 3 && !macro ? titles[3] : none;
        gd.addChoice("C4 (gray):", titles, title);
        title = titles.length > 4 && !macro ? titles[4] : none;
        gd.addChoice("C5 (cyan):", titles, title);
        title = titles.length > 5 && !macro ? titles[5] : none;
        gd.addChoice("C6 (magenta):", titles, title);
        title = titles.length > 6 && !macro ? titles[6] : none;
        gd.addChoice("C7 (yellow):", titles, title);
        gd.addCheckbox("Create composite", createComposite);
        gd.addCheckbox("Keep source images", keep);
        gd.addCheckbox("Ignore source LUTs", this.ignoreLuts);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int maxChannels = 7;
        int[] index = new int[maxChannels];
        int i2 = 0;
        while (i2 < maxChannels) {
            index[i2] = gd.getNextChoiceIndex();
            ++i2;
        }
        createComposite = gd.getNextBoolean();
        keep = gd.getNextBoolean();
        this.ignoreLuts = gd.getNextBoolean();
        if (!IJ.isMacro()) {
            staticCreateComposite = createComposite;
            staticKeep = keep;
            staticIgnoreLuts = this.ignoreLuts;
        }
        ImagePlus[] images = new ImagePlus[maxChannels];
        int stackSize = 0;
        int width = 0;
        int height = 0;
        int bitDepth = 0;
        int slices = 0;
        int frames = 0;
        int i3 = 0;
        while (i3 < maxChannels) {
            if (index[i3] < wList.length) {
                images[i3] = WindowManager.getImage(wList[index[i3]]);
                if (width == 0) {
                    width = images[i3].getWidth();
                    height = images[i3].getHeight();
                    stackSize = images[i3].getStackSize();
                    bitDepth = images[i3].getBitDepth();
                    slices = images[i3].getNSlices();
                    frames = images[i3].getNFrames();
                }
            }
            ++i3;
        }
        if (width == 0) {
            this.error("There must be at least one source image or stack.");
            return;
        }
        boolean mergeHyperstacks = false;
        int i4 = 0;
        while (i4 < maxChannels) {
            ImagePlus img = images[i4];
            if (img != null) {
                if (img.getStackSize() != stackSize) {
                    this.error("The source stacks must have the same number of images.");
                    return;
                }
                if (img.isHyperStack()) {
                    CompositeImage ci;
                    if (img.isComposite() && (ci = (CompositeImage)img).getMode() != 1) {
                        ci.setMode(1);
                        img.updateAndDraw();
                        if (!IJ.isMacro()) {
                            IJ.run("Channels Tool...");
                        }
                        return;
                    }
                    if (bitDepth == 24) {
                        this.error("Source hyperstacks cannot be RGB.");
                        return;
                    }
                    if (img.getNChannels() > 1) {
                        this.error("Source hyperstacks cannot have more than 1 channel.");
                        return;
                    }
                    if (img.getNSlices() != slices || img.getNFrames() != frames) {
                        this.error("Source hyperstacks must have the same dimensions.");
                        return;
                    }
                    mergeHyperstacks = true;
                }
                if (img.getWidth() != width || images[i4].getHeight() != height) {
                    this.error("The source images or stacks must have the same width and height.");
                    return;
                }
                if (createComposite && img.getBitDepth() != bitDepth) {
                    this.error("The source images must have the same bit depth.");
                    return;
                }
            }
            ++i4;
        }
        ImageStack[] stacks = new ImageStack[maxChannels];
        int i5 = 0;
        while (i5 < maxChannels) {
            stacks[i5] = images[i5] != null ? images[i5].getStack() : null;
            ++i5;
        }
        String macroOptions = Macro.getOptions();
        boolean fourChannelRGB = false;
        int i6 = 3;
        while (i6 < maxChannels) {
            if (!createComposite && stacks[i6] != null) {
                fourChannelRGB = true;
            }
            ++i6;
        }
        if (fourChannelRGB) {
            createComposite = true;
        }
        i6 = 3;
        while (i6 < maxChannels) {
            if (stacks[i6] != null) {
                createComposite = true;
            }
            ++i6;
        }
        i6 = 0;
        while (i6 < maxChannels) {
            if (images[i6] != null && images[i6].getBitDepth() == 24) {
                createComposite = false;
            }
            ++i6;
        }
        if (createComposite || mergeHyperstacks) {
            imp2 = this.mergeHyperstacks(images, keep);
            if (imp2 == null) {
                return;
            }
        } else {
            ImageStack rgb = this.mergeStacks(width, height, stackSize, stacks[0], stacks[1], stacks[2], keep);
            imp2 = new ImagePlus("RGB", rgb);
        }
        i = 0;
        while (i < images.length) {
            if (images[i] != null) {
                imp2.setCalibration(images[i].getCalibration());
                break;
            }
            ++i;
        }
        if (!keep) {
            i = 0;
            while (i < maxChannels) {
                if (images[i] != null) {
                    images[i].changes = false;
                    images[i].close();
                }
                ++i;
            }
        }
        if (fourChannelRGB) {
            if (imp2.getStackSize() == 1) {
                imp2 = imp2.flatten();
                imp2.setTitle("RGB");
            } else {
                imp2.setTitle("RGB");
                IJ.run(imp2, "RGB Color", "slices");
            }
        }
        imp2.show();
    }

    public ImagePlus mergeHyperstacks(ImagePlus[] images, boolean keep) {
        int n = images.length;
        int channels = 0;
        int i = 0;
        while (i < n) {
            if (images[i] != null) {
                ++channels;
            }
            ++i;
        }
        if (channels < 2) {
            return null;
        }
        ImagePlus[] images2 = new ImagePlus[channels];
        Color[] defaultColors = new Color[]{Color.red, Color.green, Color.blue, Color.white, Color.cyan, Color.magenta, Color.yellow};
        Color[] colors = new Color[channels];
        int j = 0;
        int i2 = 0;
        while (i2 < n) {
            if (images[i2] != null) {
                images2[j] = images[i2];
                if (i2 < defaultColors.length) {
                    colors[j] = defaultColors[i2];
                }
                ++j;
            }
            ++i2;
        }
        images = images2;
        ImageStack[] stacks = new ImageStack[channels];
        int i3 = 0;
        while (i3 < channels) {
            ImagePlus imp2 = images[i3];
            if (this.isDuplicate(i3, images)) {
                imp2 = imp2.duplicate();
            }
            stacks[i3] = imp2.getStack();
            ++i3;
        }
        ImagePlus imp = images[0];
        int w = imp.getWidth();
        int h = imp.getHeight();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        ImageStack stack2 = new ImageStack(w, h);
        int[] index = new int[channels];
        int t = 0;
        while (t < frames) {
            int z = 0;
            while (z < slices) {
                int c = 0;
                while (c < channels) {
                    ImageProcessor ip = stacks[c].getProcessor(index[c] + 1);
                    if (keep) {
                        ip = ip.duplicate();
                    }
                    stack2.addSlice(null, ip);
                    if (keep) {
                        int n2 = c;
                        index[n2] = index[n2] + 1;
                    } else {
                        stacks[c].deleteSlice(1);
                    }
                    ++c;
                }
                ++z;
            }
            ++t;
        }
        String title = imp.getTitle();
        title = title.startsWith("C1-") ? title.substring(3) : (frames > 1 ? "Merged" : "Composite");
        ImagePlus imp2 = new ImagePlus(title, stack2);
        imp2.setDimensions(channels, slices, frames);
        imp2 = new CompositeImage(imp2, 1);
        boolean allGrayLuts = true;
        int c = 0;
        while (c < channels) {
            if (images[c].getProcessor().isColorLut()) {
                allGrayLuts = false;
                break;
            }
            ++c;
        }
        c = 0;
        while (c < channels) {
            ImageProcessor ip = images[c].getProcessor();
            IndexColorModel cm = (IndexColorModel)ip.getColorModel();
            LUT lut = null;
            if (c < colors.length && colors[c] != null && (this.ignoreLuts || allGrayLuts)) {
                lut = LUT.createLutFromColor(colors[c]);
                lut.min = ip.getMin();
                lut.max = ip.getMax();
            } else {
                lut = new LUT(cm, ip.getMin(), ip.getMax());
            }
            ((CompositeImage)imp2).setChannelLut(lut, c + 1);
            ++c;
        }
        imp2.setOpenAsHyperStack(true);
        return imp2;
    }

    private boolean isDuplicate(int index, ImagePlus[] images) {
        boolean count = false;
        int i = 0;
        while (i < index) {
            if (images[index] == images[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ImagePlus createComposite(int w, int h, int d, ImageStack[] stacks, boolean keep) {
        ImagePlus[] images = new ImagePlus[stacks.length];
        int i = 0;
        while (i < stacks.length) {
            images[i] = new ImagePlus("" + i, stacks[i]);
            ++i;
        }
        return this.mergeHyperstacks(images, keep);
    }

    public static ImageStack mergeStacks(ImageStack red, ImageStack green, ImageStack blue, boolean keepSource) {
        RGBStackMerge merge = new RGBStackMerge();
        return merge.mergeStacks(red.getWidth(), red.getHeight(), red.getSize(), red, green, blue, keepSource);
    }

    public ImageStack mergeStacks(int w, int h, int d, ImageStack red, ImageStack green, ImageStack blue, boolean keep) {
        ImageStack rgb = new ImageStack(w, h);
        int inc = d / 10;
        if (inc < 1) {
            inc = 1;
        }
        int slice = 1;
        this.blank = new byte[w * h];
        boolean invertedRed = red != null ? red.getProcessor(1).isInvertedLut() : false;
        boolean invertedGreen = green != null ? green.getProcessor(1).isInvertedLut() : false;
        boolean invertedBlue = blue != null ? blue.getProcessor(1).isInvertedLut() : false;
        try {
            int i = 1;
            while (i <= d) {
                ColorProcessor cp = new ColorProcessor(w, h);
                byte[] redPixels = this.getPixels(red, slice, 0);
                byte[] greenPixels = this.getPixels(green, slice, 1);
                byte[] bluePixels = this.getPixels(blue, slice, 2);
                if (invertedRed) {
                    redPixels = this.invert(redPixels);
                }
                if (invertedGreen) {
                    greenPixels = this.invert(greenPixels);
                }
                if (invertedBlue) {
                    bluePixels = this.invert(bluePixels);
                }
                cp.setRGB(redPixels, greenPixels, bluePixels);
                if (keep) {
                    ++slice;
                } else {
                    if (red != null) {
                        red.deleteSlice(1);
                    }
                    if (green != null && green != red) {
                        green.deleteSlice(1);
                    }
                    if (blue != null && blue != red && blue != green) {
                        blue.deleteSlice(1);
                    }
                }
                rgb.addSlice(null, cp);
                if (i % inc == 0) {
                    IJ.showProgress((double)i / (double)d);
                }
                ++i;
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Merge Stacks");
            IJ.showProgress(1.0);
        }
        return rgb;
    }

    byte[] getPixels(ImageStack stack, int slice, int color) {
        if (stack == null) {
            return this.blank;
        }
        Object pixels = stack.getPixels(slice);
        if (!(pixels instanceof int[])) {
            if (pixels instanceof byte[]) {
                return (byte[])pixels;
            }
            ImageProcessor ip = stack.getProcessor(slice);
            ip = ip.convertToByte(true);
            return (byte[])ip.getPixels();
        }
        int size = stack.getWidth() * stack.getHeight();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ColorProcessor cp = (ColorProcessor)stack.getProcessor(slice);
        cp.getRGB(r, g, b);
        switch (color) {
            case 0: {
                return r;
            }
            case 1: {
                return g;
            }
            case 2: {
                return b;
            }
        }
        return null;
    }

    byte[] invert(byte[] pixels) {
        byte[] pixels2 = new byte[pixels.length];
        System.arraycopy(pixels, 0, pixels2, 0, pixels.length);
        int i = 0;
        while (i < pixels2.length) {
            pixels2[i] = (byte)(255 - pixels2[i] & 0xFF);
            ++i;
        }
        return pixels2;
    }

    void error(String msg) {
        IJ.error("Merge Channels", msg);
    }
}

