/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;

abstract class CompilerTool {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    CompilerTool() {
    }

    public static CompilerTool getDefault() {
        JavaxCompilerTool javax = new JavaxCompilerTool();
        if (javax.isSupported()) {
            return javax;
        }
        LegacyCompilerTool legacy = new LegacyCompilerTool();
        if (legacy.isSupported()) {
            return legacy;
        }
        return null;
    }

    public abstract boolean compile(List var1, List var2, StringWriter var3);

    protected abstract Object getJavac() throws Exception;

    public boolean isSupported() {
        try {
            return this.getJavac() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class JavaxCompilerTool
    extends CompilerTool {
        protected static Class charsetC;
        protected static Class diagnosticListenerC;
        protected static Class javaFileManagerC;
        protected static Class toolProviderC;

        public boolean compile(List sources, List options, StringWriter log) {
            try {
                Object javac = this.getJavac();
                Class[] classArray = new Class[3];
                classArray[0] = diagnosticListenerC;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.Locale");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz;
                classArray[2] = charsetC;
                Class[] getStandardFileManagerTypes = classArray;
                Method getStandardFileManager = javac.getClass().getMethod("getStandardFileManager", getStandardFileManagerTypes);
                Object fileManager = getStandardFileManager.invoke(javac, new Object[3]);
                Class[] getJavaFileObjectsFromStringsTypes = new Class[]{};
                Method getJavaFileObjectsFromStrings = fileManager.getClass().getMethod("getJavaFileObjectsFromStrings", getJavaFileObjectsFromStringsTypes);
                Object compilationUnits = getJavaFileObjectsFromStrings.invoke(fileManager, sources);
                Class[] classArray2 = new Class[3];
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.io.Writer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray2[0] = clazz2;
                classArray2[1] = javaFileManagerC;
                classArray2[2] = diagnosticListenerC;
                Class[] getTaskParamTypes = classArray2;
                Method getTask = javac.getClass().getMethod("getTask", getTaskParamTypes);
                Object[] objectArray = new Object[6];
                objectArray[0] = log;
                objectArray[1] = fileManager;
                objectArray[3] = options;
                objectArray[5] = compilationUnits;
                Object task = getTask.invoke(javac, objectArray);
                Method call = task.getClass().getMethod("call", new Class[0]);
                Object result = call.invoke(task, new Object[0]);
                return Boolean.TRUE.equals(result);
            }
            catch (Exception e) {
                PrintWriter printer = new PrintWriter(log);
                e.printStackTrace(printer);
                printer.flush();
                return false;
            }
        }

        protected Object getJavac() throws Exception {
            if (charsetC == null) {
                charsetC = Class.forName("java.nio.charset.Charset");
            }
            if (diagnosticListenerC == null) {
                diagnosticListenerC = Class.forName("javax.tools.DiagnosticListener");
            }
            if (javaFileManagerC == null) {
                javaFileManagerC = Class.forName("javax.tools.JavaFileManager");
            }
            if (toolProviderC == null) {
                toolProviderC = Class.forName("javax.tools.ToolProvider");
            }
            Method get = toolProviderC.getMethod("getSystemJavaCompiler", new Class[0]);
            return get.invoke(null, new Object[0]);
        }
    }

    public static class LegacyCompilerTool
    extends CompilerTool {
        protected static Class javacC;

        boolean areErrors(String s) {
            boolean errors;
            boolean bl = errors = s != null && s.length() > 0;
            if (errors && s.indexOf("1 warning") > 0 && s.indexOf("[deprecation] show()") > 0) {
                errors = false;
            }
            return errors;
        }

        public boolean compile(List sources, List options, StringWriter log) {
            try {
                String[] args = new String[sources.size() + options.size()];
                int argsIndex = 0;
                int optionsIndex = 0;
                while (optionsIndex < options.size()) {
                    args[argsIndex++] = (String)options.get(optionsIndex);
                    ++optionsIndex;
                }
                int sourcesIndex = 0;
                while (sourcesIndex < sources.size()) {
                    args[argsIndex++] = (String)sources.get(sourcesIndex);
                    ++sourcesIndex;
                }
                Object javac = this.getJavac();
                Class[] classArray = new Class[2];
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.io.PrintWriter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class[] compileTypes = classArray;
                Method compile = javacC.getMethod("compile", compileTypes);
                PrintWriter printer = new PrintWriter(log);
                Object result = compile.invoke(javac, args, printer);
                printer.flush();
                return Integer.valueOf("0").equals(result) | this.areErrors(log.toString());
            }
            catch (Exception e) {
                e.printStackTrace(new PrintWriter(log));
                return false;
            }
        }

        protected Object getJavac() throws Exception {
            if (javacC == null) {
                javacC = Class.forName("com.sun.tools.javac.Main");
            }
            return javacC.newInstance();
        }
    }
}

