/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;

public class BMP_Writer
implements PlugIn {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int padWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 0;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] intBitmap;
    private byte[] byteBitmap;
    private FileOutputStream fo;
    private BufferedOutputStream bfo;
    ImagePlus imp;

    public void run(String path) {
        IJ.showProgress(0.0);
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        try {
            this.writeImage(this.imp, path);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("BMP Writer", "An error occured writing the file.\n \n" + msg);
        }
        IJ.showProgress(1.0);
        IJ.showStatus("");
    }

    void writeImage(ImagePlus imp, String path) throws Exception {
        if (imp.getBitDepth() == 24) {
            this.biBitCount = 24;
        } else {
            this.biBitCount = 8;
            LookUpTable lut = imp.createLut();
            this.biClrUsed = lut.getMapSize();
            this.bfOffBits += this.biClrUsed * 4;
        }
        if (path == null || path.equals("")) {
            String prompt = "Save as " + this.biBitCount + " bit BMP";
            SaveDialog sd = new SaveDialog(prompt, imp.getTitle(), ".bmp");
            if (sd.getFileName() == null) {
                return;
            }
            path = String.valueOf(sd.getDirectory()) + sd.getFileName();
        }
        imp.startTiming();
        this.saveBitmap(path, imp.getImage(), imp.getWidth(), imp.getHeight());
    }

    public void saveBitmap(String parFilename, Image parImage, int parWidth, int parHeight) throws Exception {
        this.fo = new FileOutputStream(parFilename);
        this.bfo = new BufferedOutputStream(this.fo);
        this.save(parImage, parWidth, parHeight);
        this.bfo.close();
        this.fo.close();
    }

    private void save(Image parImage, int parWidth, int parHeight) throws Exception {
        this.convertImage(parImage, parWidth, parHeight);
        this.writeBitmapFileHeader();
        this.writeBitmapInfoHeader();
        if (this.biBitCount == 8) {
            this.writeBitmapPalette();
        }
        this.writeBitmap();
    }

    private void writeBitmapPalette() throws Exception {
        LookUpTable lut = this.imp.createLut();
        byte[] g = lut.getGreens();
        byte[] r = lut.getReds();
        byte[] b = lut.getBlues();
        int i = 0;
        while (i < lut.getMapSize()) {
            this.bfo.write(b[i]);
            this.bfo.write(g[i]);
            this.bfo.write(r[i]);
            this.bfo.write(0);
            ++i;
        }
    }

    private boolean convertImage(Image parImage, int parWidth, int parHeight) {
        if (this.biBitCount == 24) {
            this.intBitmap = (int[])this.imp.getProcessor().getPixels();
        } else {
            this.byteBitmap = (byte[])this.imp.getProcessor().convertToByte(true).getPixels();
        }
        this.biWidth = parWidth;
        this.biHeight = parHeight;
        int pad = this.biBitCount == 24 ? 4 - this.biWidth * 3 % 4 : 4 - this.biWidth % 4;
        if (pad == 4) {
            pad = 0;
        }
        this.padWidth = this.biWidth * (this.biBitCount == 24 ? 3 : 1) + pad;
        return true;
    }

    private void writeBitmap() throws Exception {
        byte[] rgb = new byte[3];
        int pad = this.biBitCount == 24 ? 4 - this.biWidth * 3 % 4 : 4 - this.biWidth % 4;
        if (pad == 4) {
            pad = 0;
        }
        int counter = 0;
        int row = this.biHeight;
        while (row > 0) {
            if (row % 20 == 0) {
                IJ.showProgress((double)(this.biHeight - row) / (double)this.biHeight);
            }
            int col = 0;
            while (col < this.biWidth) {
                if (this.biBitCount == 24) {
                    int value = this.intBitmap[(row - 1) * this.biWidth + col];
                    rgb[0] = (byte)(value & 0xFF);
                    rgb[1] = (byte)(value >> 8 & 0xFF);
                    rgb[2] = (byte)(value >> 16 & 0xFF);
                    this.bfo.write(rgb);
                } else {
                    this.bfo.write(this.byteBitmap[(row - 1) * this.biWidth + col]);
                }
                ++counter;
                ++col;
            }
            int i = 1;
            while (i <= pad) {
                this.bfo.write(0);
                ++i;
            }
            counter += pad;
            --row;
        }
    }

    private void writeBitmapFileHeader() throws Exception {
        this.fo.write(this.bfType);
        this.bfSize = this.bfOffBits + this.padWidth * this.biHeight;
        this.fo.write(this.intToDWord(this.bfSize));
        this.fo.write(this.intToWord(this.bfReserved1));
        this.fo.write(this.intToWord(this.bfReserved2));
        this.fo.write(this.intToDWord(this.bfOffBits));
    }

    private void writeBitmapInfoHeader() throws Exception {
        this.fo.write(this.intToDWord(this.biSize));
        this.fo.write(this.intToDWord(this.biWidth));
        this.fo.write(this.intToDWord(this.biHeight));
        this.fo.write(this.intToWord(this.biPlanes));
        this.fo.write(this.intToWord(this.biBitCount));
        this.fo.write(this.intToDWord(this.biCompression));
        this.fo.write(this.intToDWord(this.biSizeImage));
        this.fo.write(this.intToDWord(this.biXPelsPerMeter));
        this.fo.write(this.intToDWord(this.biYPelsPerMeter));
        this.fo.write(this.intToDWord(this.biClrUsed));
        this.fo.write(this.intToDWord(this.biClrImportant));
    }

    private byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }
}

