/*
 * Decompiled with CFR 0.152.
 */
package ij.measure;

public class SplineFitter {
    private double[] y2;
    private static int EXTEND_BY = 7;
    private int extendBy;
    private float[] xpoints;
    private float[] ypoints;
    private int npoints;
    private int[] ixpoints;
    private int[] iypoints;

    public SplineFitter(int[] x, int[] y, int n) {
        this.initSpline(x, y, n);
    }

    public SplineFitter(float[] x, float[] y, int n, boolean closed) {
        this.initSpline(x, y, n, closed);
    }

    public SplineFitter(float[] x, float[] y, int n) {
        this.initSpline(x, y, n, false);
    }

    private void initSpline(int[] x, int[] y, int n) {
        this.y2 = new double[n];
        double[] u = new double[n];
        int i = 1;
        while (i < n - 1) {
            double sig = ((double)x[i] - (double)x[i - 1]) / ((double)x[i + 1] - (double)x[i - 1]);
            double p = sig * this.y2[i - 1] + 2.0;
            this.y2[i] = (sig - 1.0) / p;
            u[i] = ((double)y[i + 1] - (double)y[i]) / (double)(x[i + 1] - x[i]) - ((double)y[i] - (double)y[i - 1]) / (double)(x[i] - x[i - 1]);
            u[i] = (6.0 * u[i] / (double)(x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
            ++i;
        }
        double un = 0.0;
        double qn = 0.0;
        this.y2[n - 1] = (un - qn * u[n - 2]) / (qn * this.y2[n - 2] + 1.0);
        int k = n - 2;
        while (k >= 0) {
            this.y2[k] = this.y2[k] * this.y2[k + 1] + u[k];
            --k;
        }
        this.ixpoints = x;
        this.iypoints = y;
        this.npoints = n;
    }

    private void initSpline(float[] x, float[] y, int n, boolean closed) {
        if (closed) {
            this.extendBy = EXTEND_BY;
            if (this.extendBy > n) {
                this.extendBy = n;
            }
            int n2 = n + 2 * this.extendBy;
            float[] xx = new float[n2];
            float[] yy = new float[n2];
            int i = 0;
            while (i < n2) {
                xx[i] = i;
                ++i;
            }
            i = 0;
            while (i < this.extendBy) {
                yy[i] = y[n - (this.extendBy - i)];
                ++i;
            }
            i = this.extendBy;
            while (i < this.extendBy + n) {
                yy[i] = y[i - this.extendBy];
                ++i;
            }
            i = this.extendBy + n;
            while (i < n2) {
                yy[i] = y[i - (this.extendBy + n)];
                ++i;
            }
            n = n2;
            x = xx;
            y = yy;
        }
        this.y2 = new double[n];
        double[] u = new double[n];
        int i = 1;
        while (i < n - 1) {
            double sig = ((double)x[i] - (double)x[i - 1]) / ((double)x[i + 1] - (double)x[i - 1]);
            double p = sig * this.y2[i - 1] + 2.0;
            this.y2[i] = (sig - 1.0) / p;
            u[i] = ((double)y[i + 1] - (double)y[i]) / (double)(x[i + 1] - x[i]) - ((double)y[i] - (double)y[i - 1]) / (double)(x[i] - x[i - 1]);
            u[i] = (6.0 * u[i] / (double)(x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
            ++i;
        }
        double un = 0.0;
        double qn = 0.0;
        this.y2[n - 1] = (un - qn * u[n - 2]) / (qn * this.y2[n - 2] + 1.0);
        int k = n - 2;
        while (k >= 0) {
            this.y2[k] = this.y2[k] * this.y2[k + 1] + u[k];
            --k;
        }
        this.xpoints = x;
        this.ypoints = y;
        this.npoints = n;
    }

    public double evalSpline(double xp) {
        if (this.xpoints != null) {
            return this.evalSpline(this.xpoints, this.ypoints, this.npoints, xp + (double)this.extendBy);
        }
        return this.evalSpline(this.ixpoints, this.iypoints, this.npoints, xp);
    }

    public double evalSpline(int[] x, int[] y, int n, double xp) {
        int klo = 0;
        int khi = n - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if ((double)x[k] > xp) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = x[khi] - x[klo];
        if (h == 0.0) {
            return 0.0;
        }
        double a = ((double)x[khi] - xp) / h;
        double b = (xp - (double)x[klo]) / h;
        if (this.y2 == null) {
            return 0.0;
        }
        return a * (double)y[klo] + b * (double)y[khi] + ((a * a * a - a) * this.y2[klo] + (b * b * b - b) * this.y2[khi]) * (h * h) / 6.0;
    }

    public double evalSpline(float[] x, float[] y, int n, double xp) {
        int klo = 0;
        int khi = n - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if ((double)x[k] > xp) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = x[khi] - x[klo];
        if (h == 0.0) {
            return 0.0;
        }
        double a = ((double)x[khi] - xp) / h;
        double b = (xp - (double)x[klo]) / h;
        if (this.y2 == null) {
            return 0.0;
        }
        return a * (double)y[klo] + b * (double)y[khi] + ((a * a * a - a) * this.y2[klo] + (b * b * b - b) * this.y2[khi]) * (h * h) / 6.0;
    }
}

