/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.util.Java2;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;

public class PointRoi
extends PolygonRoi {
    private static Font font;
    private static int fontSize;
    private double saveMag;
    private boolean hideLabels;

    static {
        fontSize = 9;
    }

    public PointRoi(int[] ox, int[] oy, int points) {
        super(PointRoi.itof(ox), PointRoi.itof(oy), points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(float[] ox, float[] oy, int points) {
        super(ox, oy, points, 10);
        ++this.width;
        ++this.height;
    }

    public PointRoi(FloatPolygon poly) {
        this(poly.xpoints, poly.ypoints, poly.npoints);
    }

    public PointRoi(Polygon poly) {
        this(PointRoi.itof(poly.xpoints), PointRoi.itof(poly.ypoints), poly.npoints);
    }

    public PointRoi(int ox, int oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(double ox, double oy) {
        super(PointRoi.makeXArray(ox, null), PointRoi.makeYArray(oy, null), 1, 10);
        this.width = 1;
        this.height = 1;
    }

    public PointRoi(int sx, int sy, ImagePlus imp) {
        super(PointRoi.makeXArray(sx, imp), PointRoi.makeYArray(sy, imp), 1, 10);
        this.setImage(imp);
        this.width = 1;
        this.height = 1;
        if (imp != null) {
            imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        if (Recorder.record && !Recorder.scriptMode()) {
            Recorder.record("makePoint", this.x, this.y);
        }
    }

    static float[] itof(int[] arr) {
        if (arr == null) {
            return null;
        }
        int n = arr.length;
        float[] temp = new float[n];
        int i = 0;
        while (i < n) {
            temp[i] = arr[i];
            ++i;
        }
        return temp;
    }

    static float[] makeXArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenXD((int)value) : value)};
        return array;
    }

    static float[] makeYArray(double value, ImagePlus imp) {
        float[] array = new float[]{(float)(imp != null ? imp.getCanvas().offScreenYD((int)value) : value)};
        return array;
    }

    void handleMouseMove(int ox, int oy) {
    }

    protected void handleMouseUp(int sx, int sy) {
        super.handleMouseUp(sx, sy);
        this.modifyRoi();
    }

    public void draw(Graphics g) {
        this.updatePolygon();
        if (this.ic != null) {
            this.mag = this.ic.getMagnification();
        }
        int size2 = 2;
        if (!Prefs.noPointLabels && !this.hideLabels && this.nPoints > 1) {
            fontSize = 9;
            if (this.mag > 1.0) {
                fontSize = (int)(((this.mag - 1.0) / 3.0 + 1.0) * 9.0);
            }
            if (fontSize > 18) {
                fontSize = 18;
            }
            if (font == null || this.mag != this.saveMag) {
                font = new Font("SansSerif", 0, fontSize);
            }
            g.setFont(font);
            if (fontSize > 9) {
                Java2.setAntialiasedText(g, true);
            }
            this.saveMag = this.mag;
        }
        int i = 0;
        while (i < this.nPoints) {
            this.drawPoint(g, this.xp2[i] - size2, this.yp2[i] - size2, i + 1);
            ++i;
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    void drawPoint(Graphics g, int x, int y, int n) {
        g.setColor(this.fillColor != null ? this.fillColor : Color.white);
        g.drawLine(x - 4, y + 2, x + 8, y + 2);
        g.drawLine(x + 2, y - 4, x + 2, y + 8);
        g.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        g.fillRect(x + 1, y + 1, 3, 3);
        if (!Prefs.noPointLabels && !this.hideLabels && this.nPoints > 1) {
            g.drawString("" + n, x + 6, y + fontSize + 4);
        }
        g.setColor(Color.black);
        g.drawRect(x, y, 4, 4);
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(Analyzer.markWidth);
        int i = 0;
        while (i < this.nPoints) {
            ip.moveTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
            ip.lineTo(this.x + (int)this.xpf[i], this.y + (int)this.ypf[i]);
            ++i;
        }
    }

    public PointRoi addPoint(double x, double y) {
        FloatPolygon poly = this.getFloatPolygon();
        poly.addPoint(x, y);
        PointRoi p = new PointRoi(poly.xpoints, poly.ypoints, poly.npoints);
        p.setHideLabels(this.hideLabels);
        IJ.showStatus("count=" + poly.npoints);
        return p;
    }

    public PointRoi addPoint(int x, int y) {
        return this.addPoint((double)x, (double)y);
    }

    public PointRoi subtractPoints(Roi roi) {
        Polygon points = this.getPolygon();
        Polygon poly = roi.getPolygon();
        Polygon points2 = new Polygon();
        int i = 0;
        while (i < points.npoints) {
            if (!poly.contains(points.xpoints[i], points.ypoints[i])) {
                points2.addPoint(points.xpoints[i], points.ypoints[i]);
            }
            ++i;
        }
        if (points2.npoints == 0) {
            return null;
        }
        return new PointRoi(points2.xpoints, points2.ypoints, points2.npoints);
    }

    public ImageProcessor getMask() {
        if (this.cachedMask != null && this.cachedMask.getPixels() != null) {
            return this.cachedMask;
        }
        ByteProcessor mask = new ByteProcessor(this.width, this.height);
        int i = 0;
        while (i < this.nPoints) {
            ((ImageProcessor)mask).putPixel((int)this.xpf[i], (int)this.ypf[i], 255);
            ++i;
        }
        this.cachedMask = mask;
        return mask;
    }

    public boolean contains(int x, int y) {
        int i = 0;
        while (i < this.nPoints) {
            if ((float)x == (float)this.x + this.xpf[i] && (float)y == (float)this.y + this.ypf[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setHideLabels(boolean hideLabels) {
        this.hideLabels = hideLabels;
    }

    public boolean subPixelResolution() {
        return true;
    }

    public String toString() {
        if (this.nPoints > 1) {
            return "Roi[Points, count=" + this.nPoints + "]";
        }
        return "Roi[Point, x=" + this.x + ", y=" + this.y + "]";
    }
}

