/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.controlpanel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.ColorRoutines;
import de.muntjak.tinylookandfeel.controlpanel.NumericTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;

public class PSColorChooser
extends JDialog {
    private Color inColor;
    private Color outColor;
    private static PSColorChooser myInstance;
    private ColorSelector colorSelector;
    private HueSelector hueSelector;
    private TwoColorField twoColorField;
    private NumericTextField redField;
    private NumericTextField greenField;
    private NumericTextField blueField;
    private NumericTextField satField;
    private NumericTextField briField;
    private NumericTextField hueField;
    private JButton ok;
    private boolean spinnerUpdate = false;
    private static Cursor cs_cursor;
    private static BufferedImage brightmask;
    private static GraphicsConfiguration conf;

    private static Cursor loadCursor() {
        ImageIcon img = null;
        Cursor c = null;
        Dimension size = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
        if (size.width == 32) {
            img = PSColorChooser.loadImageIcon("/de/muntjak/tinylookandfeel/icons/cs32.gif");
            c = Toolkit.getDefaultToolkit().createCustomCursor(img.getImage(), new Point(15, 15), "cs_cursor");
        } else if (size.width == 16) {
            img = PSColorChooser.loadImageIcon("/de/muntjak/tinylookandfeel/icons/cs16.gif");
            c = Toolkit.getDefaultToolkit().createCustomCursor(img.getImage(), new Point(7, 7), "cs_cursor");
        }
        return c;
    }

    private static BufferedImage loadBrightmask() {
        ImageIcon img = PSColorChooser.loadImageIcon("/de/muntjak/tinylookandfeel/icons/brightmask.png");
        int w = img.getIconWidth();
        int h = img.getIconHeight();
        BufferedImage bimg = conf.createCompatibleImage(w, h, 3);
        Graphics g = bimg.getGraphics();
        g.drawImage(img.getImage(), 0, 0, w, h, 0, 0, w, h, null);
        return bimg;
    }

    protected static ImageIcon loadImageIcon(String fn) {
        return new ImageIcon(PSColorChooser.class.getResource(fn));
    }

    private PSColorChooser(Frame frame, Color inColor) {
        super(frame, "PSColorChooser", true);
        this.setDefaultCloseOperation(1);
        this.inColor = inColor;
        this.outColor = inColor;
        this.setupUI(frame, inColor);
    }

    public static Color showColorChooser(Frame frame, Color inColor) {
        if (myInstance == null) {
            myInstance = new PSColorChooser(frame, inColor);
        }
        myInstance.setColor(inColor);
        myInstance.setVisible(true);
        return PSColorChooser.myInstance.outColor;
    }

    public static void deleteInstance() {
        myInstance = null;
    }

    public void setColor(Color c) {
        this.spinnerUpdate = true;
        this.outColor = this.inColor = c;
        int hue = ColorRoutines.getHue(c);
        int sat = ColorRoutines.getSaturation(c);
        int bri = ColorRoutines.getBrightness(c);
        this.satField.setValue(sat);
        this.briField.setValue(bri);
        this.hueField.setValue(hue);
        this.redField.setValue(c.getRed());
        this.greenField.setValue(c.getGreen());
        this.blueField.setValue(c.getBlue());
        this.colorSelector.setColor(c);
        this.hueSelector.setHue(hue);
        this.twoColorField.setUpperColor(c);
        this.twoColorField.setLowerColor(c);
        this.spinnerUpdate = false;
    }

    private void colorChanged(Color c) {
        this.spinnerUpdate = true;
        int hue = ColorRoutines.getHue(c);
        int sat = ColorRoutines.getSaturation(c);
        int bri = ColorRoutines.getBrightness(c);
        this.satField.setValue(sat);
        this.briField.setValue(bri);
        this.hueField.setValue(hue);
        this.redField.setValue(c.getRed());
        this.greenField.setValue(c.getGreen());
        this.blueField.setValue(c.getBlue());
        this.twoColorField.setUpperColor(c);
        this.spinnerUpdate = false;
    }

    private void hueChanged(int hue) {
        this.spinnerUpdate = true;
        int sat = this.satField.getValue();
        int bri = this.briField.getValue();
        this.hueField.setValue(hue);
        Color c = Color.getHSBColor((float)hue / 360.0f, (float)sat / 100.0f, (float)bri / 100.0f);
        this.redField.setValue(c.getRed());
        this.greenField.setValue(c.getGreen());
        this.blueField.setValue(c.getBlue());
        this.twoColorField.setUpperColor(c);
        this.colorSelector.setColor(c);
        this.spinnerUpdate = false;
    }

    private void setupUI(Frame frame, Color inColor) {
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel p2 = new JPanel(new BorderLayout());
        JPanel p3 = new JPanel(new FlowLayout(0, 6, 7));
        int hue = ColorRoutines.getHue(inColor);
        this.colorSelector = new ColorSelector(inColor);
        p3.add(this.colorSelector);
        p1.add((Component)p3, "West");
        p3 = new JPanel(new FlowLayout(0, 6, 3));
        this.hueSelector = new HueSelector(hue);
        p3.add(this.hueSelector);
        p1.add((Component)p3, "Center");
        p2.add((Component)p1, "Center");
        p1 = new JPanel(new BorderLayout());
        p3 = new JPanel(new FlowLayout(0, 6, 7));
        this.twoColorField = new TwoColorField(inColor);
        p3.add(this.twoColorField);
        p1.add((Component)p3, "North");
        p3 = new JPanel(new FlowLayout(0, 6, 7));
        p3.add(this.createNumericTextFields());
        p1.add((Component)p3, "Center");
        p2.add((Component)p1, "East");
        this.getContentPane().add((Component)p2, "North");
        p3 = new JPanel(new FlowLayout(2, 12, 4));
        p3.setBorder(new EtchedBorder());
        JButton b = new JButton("Cancel");
        b.addActionListener(new CancelAction());
        p3.add(b);
        b = new JButton("OK");
        b.addActionListener(new OKAction());
        this.getRootPane().setDefaultButton(b);
        p3.add(b);
        this.getContentPane().add((Component)p3, "South");
        this.pack();
        Dimension size = this.getSize();
        this.setLocation(frame.getLocationOnScreen().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocationOnScreen().y + (frame.getHeight() - this.getSize().height) / 2);
    }

    private JPanel createNumericTextFields() {
        RGBAction rgbAction = new RGBAction();
        HSBAction hsbAction = new HSBAction();
        JPanel p2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 0, 4, 2);
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        p2.add((Component)new JLabel("H:"), gc);
        ++gc.gridx;
        this.hueField = new NumericTextField(3, 0, 0, 360);
        this.hueField.addActionListener(hsbAction);
        p2.add((Component)this.hueField, gc);
        gc.gridx = 0;
        ++gc.gridy;
        p2.add((Component)new JLabel("S:"), gc);
        ++gc.gridx;
        this.satField = new NumericTextField(3, 0, 0, 100);
        this.satField.addActionListener(hsbAction);
        p2.add((Component)this.satField, gc);
        gc.gridx = 0;
        ++gc.gridy;
        p2.add((Component)new JLabel("B:"), gc);
        ++gc.gridx;
        this.briField = new NumericTextField(3, 0, 0, 100);
        this.briField.addActionListener(hsbAction);
        p2.add((Component)this.briField, gc);
        gc.insets = new Insets(8, 0, 4, 2);
        gc.gridx = 0;
        ++gc.gridy;
        p2.add((Component)new JLabel("R:"), gc);
        ++gc.gridx;
        this.redField = new NumericTextField(3, 0, 0, 255);
        this.redField.addActionListener(rgbAction);
        p2.add((Component)this.redField, gc);
        gc.gridx = 0;
        ++gc.gridy;
        gc.insets = new Insets(0, 0, 4, 2);
        p2.add((Component)new JLabel("G:"), gc);
        ++gc.gridx;
        this.greenField = new NumericTextField(3, 0, 0, 255);
        this.greenField.addActionListener(rgbAction);
        p2.add((Component)this.greenField, gc);
        gc.gridx = 0;
        ++gc.gridy;
        p2.add((Component)new JLabel("B:"), gc);
        ++gc.gridx;
        this.blueField = new NumericTextField(3, 0, 0, 255);
        this.blueField.addActionListener(rgbAction);
        p2.add((Component)this.blueField, gc);
        return p2;
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        conf = ge.getDefaultScreenDevice().getDefaultConfiguration();
        brightmask = PSColorChooser.loadBrightmask();
        cs_cursor = PSColorChooser.loadCursor();
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PSColorChooser.this.outColor = null;
            PSColorChooser.this.setVisible(false);
        }
    }

    class OKAction
    implements ActionListener {
        OKAction() {
        }

        public void actionPerformed(ActionEvent e) {
            PSColorChooser.this.setVisible(false);
        }
    }

    class HSBAction
    implements ActionListener {
        HSBAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PSColorChooser.this.spinnerUpdate) {
                return;
            }
            int h = PSColorChooser.this.hueField.getValue();
            int s = PSColorChooser.this.satField.getValue();
            int b = PSColorChooser.this.briField.getValue();
            Color c = Color.getHSBColor((float)h / 360.0f, (float)s / 100.0f, (float)b / 100.0f);
            PSColorChooser.this.twoColorField.setUpperColor(c);
            PSColorChooser.this.spinnerUpdate = true;
            PSColorChooser.this.redField.setValue(c.getRed());
            PSColorChooser.this.greenField.setValue(c.getGreen());
            PSColorChooser.this.blueField.setValue(c.getBlue());
            PSColorChooser.this.spinnerUpdate = false;
            PSColorChooser.this.hueSelector.setHue(h);
            PSColorChooser.this.colorSelector.setColor(c);
        }
    }

    class RGBAction
    implements ActionListener {
        RGBAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (PSColorChooser.this.spinnerUpdate) {
                return;
            }
            int r = PSColorChooser.this.redField.getValue();
            int g = PSColorChooser.this.greenField.getValue();
            int b = PSColorChooser.this.blueField.getValue();
            Color c = new Color(r, g, b);
            PSColorChooser.this.twoColorField.setUpperColor(c);
            PSColorChooser.this.spinnerUpdate = true;
            int hue = ColorRoutines.getHue(c);
            PSColorChooser.this.hueField.setValue(hue);
            PSColorChooser.this.satField.setValue(ColorRoutines.getSaturation(c));
            PSColorChooser.this.briField.setValue(ColorRoutines.getBrightness(c));
            PSColorChooser.this.spinnerUpdate = false;
            PSColorChooser.this.hueSelector.setHue(hue);
            PSColorChooser.this.colorSelector.setColor(c);
        }
    }

    class HueSelector
    extends JPanel {
        private Color darkColor = new Color(128, 128, 128);
        private Dimension size = new Dimension(35, 266);
        private float hue;
        private int arrowY;
        private Vector listeners;

        HueSelector(int hue) {
            this.hue = (float)((double)hue / 360.0);
            this.addMouseListener(new Mousey());
            this.addMouseMotionListener(new MouseyDrag());
        }

        void setHue(int hue) {
            this.hue = (float)((double)hue / 360.0);
            this.repaint(0L);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics g) {
            g.setColor(Theme.backColor[Theme.style].getColor());
            g.fillRect(0, 0, 35, 266);
            this.drawArrows(g);
            g.setColor(this.darkColor);
            g.drawLine(6, 3, 27, 3);
            g.drawLine(6, 3, 6, 261);
            g.setColor(Color.WHITE);
            g.drawLine(6, 262, 28, 262);
            g.drawLine(28, 3, 28, 261);
            g.setColor(Color.BLACK);
            g.drawRect(7, 4, 20, 257);
            int x1 = 8;
            int x2 = 26;
            int y1 = 5;
            for (int y = 0; y < 256; ++y) {
                float h = (float)((double)(255 - y) / 255.0);
                g.setColor(Color.getHSBColor(h, 1.0f, 1.0f));
                g.drawLine(x1, y + y1, x2, y + y1);
            }
        }

        private void drawArrows(Graphics g) {
            this.arrowY = 260 - (int)((double)this.hue * 255.0);
            g.setColor(Color.BLACK);
            g.drawLine(0, this.arrowY - 5, 0, this.arrowY + 5);
            g.drawLine(1, this.arrowY - 4, 1, this.arrowY - 4);
            g.drawLine(2, this.arrowY - 3, 2, this.arrowY - 3);
            g.drawLine(3, this.arrowY - 2, 3, this.arrowY - 2);
            g.drawLine(4, this.arrowY - 1, 4, this.arrowY - 1);
            g.drawLine(5, this.arrowY, 5, this.arrowY);
            g.drawLine(0, this.arrowY + 5, 0, this.arrowY + 5);
            g.drawLine(1, this.arrowY + 4, 1, this.arrowY + 4);
            g.drawLine(2, this.arrowY + 3, 2, this.arrowY + 3);
            g.drawLine(3, this.arrowY + 2, 3, this.arrowY + 2);
            g.drawLine(4, this.arrowY + 1, 4, this.arrowY + 1);
            g.drawLine(34, this.arrowY - 5, 34, this.arrowY + 5);
            g.drawLine(33, this.arrowY - 4, 33, this.arrowY - 4);
            g.drawLine(32, this.arrowY - 3, 32, this.arrowY - 3);
            g.drawLine(31, this.arrowY - 2, 31, this.arrowY - 2);
            g.drawLine(30, this.arrowY - 1, 30, this.arrowY - 1);
            g.drawLine(29, this.arrowY, 29, this.arrowY);
            g.drawLine(34, this.arrowY + 5, 34, this.arrowY + 5);
            g.drawLine(33, this.arrowY + 4, 33, this.arrowY + 4);
            g.drawLine(32, this.arrowY + 3, 32, this.arrowY + 3);
            g.drawLine(31, this.arrowY + 2, 31, this.arrowY + 2);
            g.drawLine(30, this.arrowY + 1, 30, this.arrowY + 1);
        }

        class MouseyDrag
        extends MouseMotionAdapter {
            MouseyDrag() {
            }

            public void mouseDragged(MouseEvent e) {
                int y = e.getY() - 5;
                if (y < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                HueSelector.this.hue = (float)((double)(255 - y) / 255.0);
                HueSelector.this.repaint();
                PSColorChooser.this.hueChanged((int)((double)HueSelector.this.hue * 360.0));
            }
        }

        class Mousey
        extends MouseAdapter {
            Mousey() {
            }

            public void mousePressed(MouseEvent e) {
                if (e.getY() < 5 || e.getY() > 260) {
                    return;
                }
                HueSelector.this.hue = (float)((double)(255 - (e.getY() - 5)) / 255.0);
                HueSelector.this.repaint();
                PSColorChooser.this.hueChanged((int)((double)HueSelector.this.hue * 360.0));
            }
        }
    }

    class TwoColorField
    extends JPanel {
        private Dimension size = new Dimension(60, 68);
        private Color upperColor;
        private Color lowerColor;

        TwoColorField(Color c) {
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.upperColor = c;
            this.lowerColor = c;
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        void setUpperColor(Color c) {
            this.upperColor = c;
            PSColorChooser.this.outColor = c;
            this.repaint(0L);
        }

        void setLowerColor(Color c) {
            this.lowerColor = c;
            this.repaint(0L);
        }

        public void paint(Graphics g) {
            super.paintBorder(g);
            g.setColor(this.upperColor);
            g.fillRect(1, 1, 58, 33);
            g.setColor(this.lowerColor);
            g.fillRect(1, 34, 58, 33);
        }
    }

    class ColorSelector
    extends JPanel {
        private Dimension size = new Dimension(258, 258);
        private float hue;
        private int h;
        private int s;
        private int b;
        private int circleX;
        private int circleY;
        private Vector listeners;
        private Color theColor;
        private boolean mousePressed = false;

        ColorSelector(Color c) {
            this.h = ColorRoutines.getHue(c);
            this.s = ColorRoutines.getSaturation(c) * 255 / 100;
            this.b = ColorRoutines.getBrightness(c) * 255 / 100;
            this.hue = (float)((double)this.h / 360.0);
            this.theColor = c;
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.addMouseListener(new Mousey());
            this.addMouseMotionListener(new MouseyDrag());
            this.setCursor(cs_cursor);
        }

        void setColor(Color c) {
            this.h = PSColorChooser.this.hueField.getValue();
            this.s = PSColorChooser.this.satField.getValue() * 255 / 100;
            this.b = PSColorChooser.this.briField.getValue() * 255 / 100;
            this.hue = (float)((double)this.h / 360.0);
            this.repaint(0L);
        }

        public Dimension getPreferredSize() {
            return this.size;
        }

        public void paint(Graphics g) {
            super.paintBorder(g);
            if (this.mousePressed) {
                g.setClip(this.circleX, this.circleY, 11, 11);
            }
            for (int x = 0; x < 256; ++x) {
                float sat = (float)((double)x / 255.0);
                Color c = Color.getHSBColor(this.hue, sat, 1.0f);
                g.setColor(c);
                g.drawLine(x + 1, 1, x + 1, 256);
            }
            g.drawImage(brightmask, 1, 1, this);
            this.circleX = this.s - 4;
            this.circleY = 255 - this.b - 4;
            if (this.mousePressed) {
                g.setClip(this.circleX, this.circleY, 11, 11);
            }
            if (this.b < 160) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(Color.BLACK);
            }
            g.drawLine(this.circleX + 3, this.circleY, this.circleX + 7, this.circleY);
            g.drawLine(this.circleX + 3, this.circleY + 10, this.circleX + 7, this.circleY + 10);
            g.drawLine(this.circleX, this.circleY + 3, this.circleX, this.circleY + 7);
            g.drawLine(this.circleX + 10, this.circleY + 3, this.circleX + 10, this.circleY + 7);
            g.drawLine(this.circleX + 2, this.circleY + 1, this.circleX + 2, this.circleY + 1);
            g.drawLine(this.circleX + 8, this.circleY + 1, this.circleX + 8, this.circleY + 1);
            g.drawLine(this.circleX + 1, this.circleY + 2, this.circleX + 1, this.circleY + 2);
            g.drawLine(this.circleX + 9, this.circleY + 2, this.circleX + 9, this.circleY + 2);
            g.drawLine(this.circleX + 1, this.circleY + 8, this.circleX + 1, this.circleY + 8);
            g.drawLine(this.circleX + 9, this.circleY + 8, this.circleX + 9, this.circleY + 8);
            g.drawLine(this.circleX + 2, this.circleY + 9, this.circleX + 2, this.circleY + 9);
            g.drawLine(this.circleX + 8, this.circleY + 9, this.circleX + 8, this.circleY + 9);
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        class MouseyDrag
        extends MouseMotionAdapter {
            MouseyDrag() {
            }

            public void mouseDragged(MouseEvent e) {
                ColorSelector.this.s = e.getX() - 1;
                if (ColorSelector.this.s < 0) {
                    ColorSelector.this.s = 0;
                } else if (ColorSelector.this.s > 255) {
                    ColorSelector.this.s = 255;
                }
                int y = e.getY() - 1;
                if (y < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                ColorSelector.this.b = 255 - y;
                ColorSelector.this.paint(ColorSelector.this.getGraphics());
                ColorSelector.this.theColor = Color.getHSBColor(ColorSelector.this.hue, (float)((double)ColorSelector.this.s / 255.0), (float)((double)ColorSelector.this.b / 255.0));
                PSColorChooser.this.colorChanged(ColorSelector.this.theColor);
            }
        }

        class Mousey
        extends MouseAdapter {
            Mousey() {
            }

            public void mousePressed(MouseEvent e) {
                if (e.getX() < 1 || e.getX() > 256) {
                    return;
                }
                if (e.getY() < 1 || e.getY() > 256) {
                    return;
                }
                ColorSelector.this.s = e.getX() - 1;
                if (ColorSelector.this.s < 0) {
                    ColorSelector.this.s = 0;
                } else if (ColorSelector.this.s > 255) {
                    ColorSelector.this.s = 255;
                }
                int y = e.getY() - 1;
                if (y < 0) {
                    y = 0;
                } else if (y > 255) {
                    y = 255;
                }
                ColorSelector.this.mousePressed = true;
                ColorSelector.this.b = 255 - y;
                ColorSelector.this.paint(ColorSelector.this.getGraphics());
                ColorSelector.this.theColor = Color.getHSBColor(ColorSelector.this.hue, (float)((double)ColorSelector.this.s / 255.0), (float)((double)ColorSelector.this.b / 255.0));
                PSColorChooser.this.colorChanged(ColorSelector.this.theColor);
            }

            public void mouseReleased(MouseEvent e) {
                ColorSelector.this.mousePressed = false;
            }
        }
    }
}

