/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class TinySpinnerButtonUI
extends TinyButtonUI {
    private int orientation;
    protected static Dimension winSize = new Dimension(18, 8);
    protected static Dimension xpSize = new Dimension(15, 8);

    public static ComponentUI createUI(JComponent c) {
        throw new IllegalStateException("Must not be used this way.");
    }

    TinySpinnerButtonUI(int type) {
        this.orientation = type;
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        if (!button.isEnabled()) {
            g.setColor(Theme.spinnerButtDisabledColor[Theme.style].getColor());
        } else if (button.getModel().isPressed()) {
            g.setColor(Theme.spinnerButtPressedColor[Theme.style].getColor());
        } else if (button.getModel().isRollover()) {
            g.setColor(Theme.spinnerButtRolloverColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerButtColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyButton(g, button);
                break;
            }
            case 1: {
                this.drawWinButton(g, button);
                break;
            }
            case 2: {
                this.drawXpButton(g, button);
            }
        }
        if (!button.isEnabled()) {
            g.setColor(Theme.spinnerArrowDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerArrowColor[Theme.style].getColor());
        }
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyArrow(g, button);
                break;
            }
            case 1: {
                this.drawWinArrow(g, button);
                break;
            }
            case 2: {
                this.drawXpArrow(g, button);
            }
        }
    }

    private void drawTinyButton(Graphics g, AbstractButton b) {
    }

    private void drawWinButton(Graphics g, AbstractButton b) {
        int y1;
        g.fillRect(0, 0, b.getWidth(), b.getHeight());
        int x2 = b.getSize().width - 3;
        int y2 = this.orientation == 1 ? b.getSize().height - 1 : b.getSize().height - 3;
        int n = y1 = this.orientation == 1 ? 2 : 0;
        if (b.getModel().isPressed()) {
            g.setColor(Theme.spinnerDarkColor[Theme.style].getColor());
            g.drawRect(0, y1, x2, y2 - y1);
            return;
        }
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerLightColor[Theme.style].getColor());
        }
        g.drawLine(1, y1 + 1, x2 - 2, y1 + 1);
        g.drawLine(1, y1 + 2, 1, y2 - 2);
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerDarkColor[Theme.style].getColor());
        }
        g.drawLine(1, y2 - 1, x2 - 1, y2 - 1);
        g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 2);
        if (!b.isEnabled()) {
            g.setColor(Theme.spinnerBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.spinnerBorderColor[Theme.style].getColor());
        }
        g.drawLine(0, y2, x2, y2);
        g.drawLine(x2, y1, x2, y2);
    }

    private void drawXpButton(Graphics g, AbstractButton b) {
        ColorUIResource borderColor = Theme.borderColor[Theme.style].getColor();
        ColorUIResource innerColor = Theme.whiteBorderColor[Theme.style].getColor();
        int h = b.getSize().height;
        int w = b.getSize().width;
        boolean isEnabled = b.isEnabled();
        boolean isRollover = b.getModel().isRollover();
        boolean isPressed = b.getModel().isPressed();
        ColorUIResource pressedLightColor = Theme.pressedLightColor[Theme.style].getColor();
        ColorUIResource pressedDarkColor = Theme.pressedDarkColor[Theme.style].getColor();
        ColorUIResource rolloverLightColor = Theme.rolloverLightColor[Theme.style].getColor();
        ColorUIResource rolloverDarkColor = Theme.rolloverDarkColor[Theme.style].getColor();
        ColorUIResource normalLightColor = Theme.normalLightColor[Theme.style].getColor();
        ColorUIResource normalDarkColor = Theme.normalDarkColor[Theme.style].getColor();
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint spinnerBg = new GradientPaint(0.0f, 0.0f, normalLightColor, 0.0f, h, normalDarkColor);
        GradientPaint HighLight = new GradientPaint(2.0f, 2.0f, new Color(1.0f, 1.0f, 1.0f, 0.6f), 0.0f, h / 2, new Color(1.0f, 1.0f, 1.0f, 0.2f));
        GradientPaint spinnerCover = new GradientPaint(0.0f, 0.0f, rolloverLightColor, 0.0f, h, rolloverDarkColor);
        GradientPaint spinnerPressed = new GradientPaint(0.0f, 0.0f, pressedLightColor, 0.0f, h, pressedDarkColor);
        g2.setPaint(spinnerBg);
        g2.fillRoundRect(2, 2, w - 4, h - 4, 3, 3);
        g2.setPaint(HighLight);
        g2.fillRect(2, 2, w - 4, (h - 4) / 2);
        g2.setColor(borderColor);
        g2.drawRoundRect(0, 0, w - 1, h - 1, 3, 3);
        g2.setColor(innerColor);
        g2.drawRoundRect(1, 1, w - 3, h - 3, 3, 3);
        if (isRollover) {
            g2.setPaint(spinnerCover);
            g2.fillRoundRect(2, 2, w - 4, h - 4, 3, 3);
        } else if (isPressed) {
            g2.setPaint(spinnerPressed);
            g2.fillRoundRect(2, 2, w - 4, h - 4, 3, 3);
        } else if (!isEnabled) {
            g2.setColor(Theme.spinnerBorderDisabledColor[Theme.style].getColor());
            g2.fillRoundRect(2, 2, w - 4, h - 4, 3, 3);
        }
    }

    private void drawTinyArrow(Graphics g, AbstractButton b) {
    }

    private void drawWinArrow(Graphics g, AbstractButton b) {
        int x = 6;
        int y = (b.getSize().height - 2) / 2;
        y = this.orientation == 1 ? ++y : --y;
        if (b.getModel().isPressed()) {
            ++y;
            ++x;
        }
        switch (this.orientation) {
            case 1: {
                g.drawLine(x + 1, y, x + 1, y);
                g.drawLine(x, y + 1, x + 2, y + 1);
                break;
            }
            case 5: {
                g.drawLine(x + 1, y + 1, x + 1, y + 1);
                g.drawLine(x, y, x + 2, y);
            }
        }
    }

    private void drawXpArrow(Graphics g, AbstractButton b) {
        int y = (b.getSize().height - 6) / 2;
        switch (this.orientation) {
            case 1: {
                g.drawLine(7, --y + 2, 7, y + 2);
                g.drawLine(6, y + 3, 8, y + 3);
                g.drawLine(5, y + 4, 9, y + 4);
                g.drawLine(4, y + 5, 6, y + 5);
                g.drawLine(8, y + 5, 10, y + 5);
                break;
            }
            case 5: {
                g.drawLine(4, y + 2, 6, y + 2);
                g.drawLine(8, y + 2, 10, y + 2);
                g.drawLine(5, y + 3, 9, y + 3);
                g.drawLine(6, y + 4, 8, y + 4);
                g.drawLine(7, y + 5, 7, y + 5);
            }
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                return xpSize;
            }
            case 1: {
                return winSize;
            }
        }
        return xpSize;
    }
}

