/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;

public class MenuItemIconFactory
implements Serializable {
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuArrowIcon;
    private static final Dimension menuCheckIconSize;
    private static final Dimension menuArrowIconSize;

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    static {
        menuCheckIconSize = new Dimension(10, 10);
        menuArrowIconSize = new Dimension(4, 8);
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private MenuArrowIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            g.translate(x, y);
            if (!model.isEnabled()) {
                g.setColor(Theme.menuDisabledFgColor[Theme.style].getColor());
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(Theme.menuSelectedTextColor[Theme.style].getColor());
            } else {
                g.setColor(b.getForeground());
            }
            if (c.getComponentOrientation().isLeftToRight()) {
                g.drawLine(0, 0, 0, 7);
                g.drawLine(1, 1, 1, 6);
                g.drawLine(2, 2, 2, 5);
                g.drawLine(3, 3, 3, 4);
            } else {
                g.drawLine(4, 0, 4, 7);
                g.drawLine(3, 1, 3, 6);
                g.drawLine(2, 2, 2, 5);
                g.drawLine(1, 3, 1, 4);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                if (isPressed || isArmed) {
                    g.setColor(Theme.menuIconRolloverColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.menuIconColor[Theme.style].getColor());
                }
            } else {
                g.setColor(Theme.menuIconDisabledColor[Theme.style].getColor());
            }
            g.drawLine(3, 0, 6, 0);
            g.drawLine(9, 3, 9, 6);
            g.drawLine(3, 9, 6, 9);
            g.drawLine(0, 3, 0, 6);
            g.drawLine(1, 1, 2, 1);
            g.drawLine(7, 1, 8, 1);
            g.drawLine(1, 8, 2, 8);
            g.drawLine(7, 8, 8, 8);
            g.drawLine(1, 2, 1, 2);
            g.drawLine(8, 2, 8, 2);
            g.drawLine(1, 7, 1, 7);
            g.drawLine(8, 7, 8, 7);
            if (isSelected) {
                g.drawLine(4, 3, 5, 3);
                g.drawLine(3, 4, 6, 4);
                g.drawLine(3, 5, 6, 5);
                g.drawLine(4, 6, 5, 6);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem item = (JMenuItem)c;
            ButtonModel model = item.getModel();
            boolean isSelected = model.isSelected();
            if (!isSelected) {
                return;
            }
            boolean isEnabled = model.isEnabled();
            boolean isPressed = model.isPressed();
            boolean isArmed = model.isArmed();
            g.translate(x, y);
            if (isEnabled) {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(Theme.menuIconRolloverColor[Theme.style].getColor());
                } else {
                    g.setColor(Theme.menuIconColor[Theme.style].getColor());
                }
            } else {
                g.setColor(Theme.menuIconDisabledColor[Theme.style].getColor());
            }
            g.drawLine(2, 4, 2, 6);
            g.drawLine(3, 5, 3, 7);
            g.drawLine(4, 6, 4, 8);
            g.drawLine(5, 5, 5, 7);
            g.drawLine(6, 4, 6, 6);
            g.drawLine(7, 3, 7, 5);
            g.drawLine(8, 2, 8, 4);
            if (!isEnabled && Theme.derivedStyle[Theme.style] == 1) {
                g.setColor(Theme.menuIconShadowColor[Theme.style].getColor());
                g.drawLine(9, 3, 9, 5);
                g.drawLine(8, 5, 8, 6);
                g.drawLine(7, 6, 7, 7);
                g.drawLine(6, 7, 6, 8);
                g.drawLine(5, 8, 5, 9);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }
    }
}

