/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel.helpers;

import com.fr.third.v2.org.apache.poi.ss.util.CellReference;
import com.fr.third.v2.org.apache.poi.xssf.model.SingleXmlCells;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCell;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRow;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSingleXmlCell;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXmlCellPr;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXmlPr;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.STXmlDataType;

public class XSSFSingleXmlCell {
    private CTSingleXmlCell singleXmlCell;
    private SingleXmlCells parent;

    public XSSFSingleXmlCell(CTSingleXmlCell singleXmlCell, SingleXmlCells parent) {
        this.singleXmlCell = singleXmlCell;
        this.parent = parent;
    }

    public XSSFCell getReferencedCell() {
        XSSFCell cell = null;
        CellReference cellReference = new CellReference(this.singleXmlCell.getR());
        XSSFRow row = this.parent.getXSSFSheet().getRow(cellReference.getRow());
        if (row == null) {
            row = this.parent.getXSSFSheet().createRow(cellReference.getRow());
        }
        if ((cell = row.getCell(cellReference.getCol())) == null) {
            cell = row.createCell(cellReference.getCol());
        }
        return cell;
    }

    public String getXpath() {
        CTXmlCellPr xmlCellPr = this.singleXmlCell.getXmlCellPr();
        CTXmlPr xmlPr = xmlCellPr.getXmlPr();
        String xpath = xmlPr.getXpath();
        return xpath;
    }

    public long getMapId() {
        return this.singleXmlCell.getXmlCellPr().getXmlPr().getMapId();
    }

    public STXmlDataType.Enum getXmlDataType() {
        CTXmlCellPr xmlCellPr = this.singleXmlCell.getXmlCellPr();
        CTXmlPr xmlPr = xmlCellPr.getXmlPr();
        return xmlPr.getXmlDataType();
    }
}

