/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel;

import com.fr.third.v2.org.apache.poi.POIXMLDocumentPart;
import com.fr.third.v2.org.apache.poi.POIXMLTypeLoader;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageRelationship;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Row;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Sheet;
import com.fr.third.v2.org.apache.poi.ss.util.AreaReference;
import com.fr.third.v2.org.apache.poi.ss.util.CellReference;
import com.fr.third.v2.org.apache.poi.util.Internal;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import com.fr.third.v2.org.apache.xmlbeans.XmlOptions;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCacheField;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCacheFields;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPivotCacheDefinition;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.namespace.QName;

public class XSSFPivotCacheDefinition
extends POIXMLDocumentPart {
    private CTPivotCacheDefinition ctPivotCacheDefinition;

    public XSSFPivotCacheDefinition() {
        this.ctPivotCacheDefinition = CTPivotCacheDefinition.Factory.newInstance();
        this.createDefaultValues();
    }

    protected XSSFPivotCacheDefinition(PackagePart part) throws IOException {
        super(part);
        this.readFrom(part.getInputStream());
    }

    @Deprecated
    protected XSSFPivotCacheDefinition(PackagePart part, PackageRelationship rel) throws IOException {
        this(part);
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            XmlOptions options = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            options.setLoadReplaceDocumentElement(null);
            this.ctPivotCacheDefinition = CTPivotCacheDefinition.Factory.parse(is, options);
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    @Internal
    public CTPivotCacheDefinition getCTPivotCacheDefinition() {
        return this.ctPivotCacheDefinition;
    }

    private void createDefaultValues() {
        this.ctPivotCacheDefinition.setCreatedVersion((short)3);
        this.ctPivotCacheDefinition.setMinRefreshableVersion((short)3);
        this.ctPivotCacheDefinition.setRefreshedVersion((short)3);
        this.ctPivotCacheDefinition.setRefreshedBy("Apache POI");
        this.ctPivotCacheDefinition.setRefreshedDate(new Date().getTime());
        this.ctPivotCacheDefinition.setRefreshOnLoad(true);
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        XmlOptions xmlOptions = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTPivotCacheDefinition.type.getName().getNamespaceURI(), "pivotCacheDefinition"));
        this.ctPivotCacheDefinition.save(out, xmlOptions);
        out.close();
    }

    protected void createCacheFields(Sheet sheet) {
        AreaReference ar = new AreaReference(this.ctPivotCacheDefinition.getCacheSource().getWorksheetSource().getRef());
        CellReference firstCell = ar.getFirstCell();
        CellReference lastCell = ar.getLastCell();
        int columnStart = firstCell.getCol();
        short columnEnd = lastCell.getCol();
        Row row = sheet.getRow(firstCell.getRow());
        CTCacheFields cFields = this.ctPivotCacheDefinition.getCacheFields() != null ? this.ctPivotCacheDefinition.getCacheFields() : this.ctPivotCacheDefinition.addNewCacheFields();
        for (int i = columnStart; i <= columnEnd; ++i) {
            CTCacheField cf = cFields.addNewCacheField();
            if (i == columnEnd) {
                cFields.setCount(cFields.sizeOfCacheFieldArray());
            }
            cf.setNumFmtId(0L);
            Cell cell = row.getCell(i);
            cell.setCellType(1);
            cf.setName(row.getCell(i).getStringCellValue());
            cf.addNewSharedItems();
        }
    }
}

