/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel;

import com.fr.third.v2.com.microsoft.schemas.vml.CTShape;
import com.fr.third.v2.org.apache.poi.ss.usermodel.ClientAnchor;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Comment;
import com.fr.third.v2.org.apache.poi.ss.usermodel.RichTextString;
import com.fr.third.v2.org.apache.poi.ss.util.CellAddress;
import com.fr.third.v2.org.apache.poi.ss.util.CellReference;
import com.fr.third.v2.org.apache.poi.xssf.model.CommentsTable;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRichTextString;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import java.math.BigInteger;

public class XSSFComment
implements Comment {
    private final CTComment _comment;
    private final CommentsTable _comments;
    private final CTShape _vmlShape;
    private XSSFRichTextString _str;

    public XSSFComment(CommentsTable comments, CTComment comment, CTShape vmlShape) {
        this._comment = comment;
        this._comments = comments;
        this._vmlShape = vmlShape;
        if (vmlShape != null && vmlShape.sizeOfClientDataArray() > 0) {
            CellReference ref = new CellReference(comment.getRef());
            vmlShape.getClientDataArray(0).setRowArray(0, new BigInteger(String.valueOf(ref.getRow())));
            vmlShape.getClientDataArray(0).setColumnArray(0, new BigInteger(String.valueOf(ref.getCol())));
            vmlShape.getClientDataList().toString();
        }
    }

    public String getAuthor() {
        return this._comments.getAuthor((int)this._comment.getAuthorId());
    }

    public void setAuthor(String author) {
        this._comment.setAuthorId(this._comments.findAuthor(author));
    }

    public int getColumn() {
        return new CellReference(this._comment.getRef()).getCol();
    }

    public int getRow() {
        return new CellReference(this._comment.getRef()).getRow();
    }

    public boolean isVisible() {
        boolean visible = false;
        if (this._vmlShape != null) {
            String style = this._vmlShape.getStyle();
            visible = style != null && style.indexOf("visibility:visible") != -1;
        }
        return visible;
    }

    public void setVisible(boolean visible) {
        if (this._vmlShape != null) {
            String style = visible ? "position:absolute;visibility:visible" : "position:absolute;visibility:hidden";
            this._vmlShape.setStyle(style);
        }
    }

    public void setColumn(int col) {
        CellAddress oldRef = new CellAddress(this._comment.getRef());
        CellAddress ref = new CellAddress(this.getRow(), col);
        this._comment.setRef(ref.formatAsString());
        this._comments.referenceUpdated(oldRef, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setColumnArray(new BigInteger[]{new BigInteger(String.valueOf(col))});
            this._vmlShape.getClientDataList().toString();
        }
    }

    public void setRow(int row) {
        CellAddress oldRef = new CellAddress(this._comment.getRef());
        CellAddress ref = new CellAddress(row, this.getColumn());
        this._comment.setRef(ref.formatAsString());
        this._comments.referenceUpdated(oldRef, this._comment);
        if (this._vmlShape != null) {
            this._vmlShape.getClientDataArray(0).setRowArray(0, new BigInteger(String.valueOf(row)));
            this._vmlShape.getClientDataList().toString();
        }
    }

    public XSSFRichTextString getString() {
        CTRst rst;
        if (this._str == null && (rst = this._comment.getText()) != null) {
            this._str = new XSSFRichTextString(this._comment.getText());
        }
        return this._str;
    }

    public void setString(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        this._str = (XSSFRichTextString)string;
        this._comment.setText(this._str.getCTRst());
    }

    public void setString(String string) {
        this.setString(new XSSFRichTextString(string));
    }

    public ClientAnchor getClientAnchor() {
        String position = this._vmlShape.getClientDataArray(0).getAnchorArray(0);
        int[] pos = new int[8];
        int i = 0;
        for (String s : position.split(",")) {
            pos[i++] = Integer.parseInt(s.trim());
        }
        XSSFClientAnchor ca = new XSSFClientAnchor(pos[1] * 9525, pos[3] * 9525, pos[5] * 9525, pos[7] * 9525, pos[0], pos[2], pos[4], pos[6]);
        return ca;
    }

    protected CTComment getCTComment() {
        return this._comment;
    }

    protected CTShape getCTShape() {
        return this._vmlShape;
    }
}

