/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.model;

import com.fr.third.v2.org.apache.poi.POIXMLDocumentPart;
import com.fr.third.v2.org.apache.poi.POIXMLTypeLoader;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageRelationship;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import com.fr.third.v2.org.apache.xmlbeans.XmlOptions;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSst;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.SstDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedStringsTable
extends POIXMLDocumentPart {
    private final List<CTRst> strings = new ArrayList<CTRst>();
    private final Map<String, Integer> stmap = new HashMap<String, Integer>();
    private int count;
    private int uniqueCount;
    private SstDocument _sstDoc;
    private static final XmlOptions options = new XmlOptions();

    public SharedStringsTable() {
        this._sstDoc = SstDocument.Factory.newInstance();
        this._sstDoc.addNewSst();
    }

    public SharedStringsTable(PackagePart part) throws IOException {
        super(part);
        this.readFrom(part.getInputStream());
    }

    public SharedStringsTable(PackagePart part, PackageRelationship rel) throws IOException {
        this(part);
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            int cnt = 0;
            this._sstDoc = SstDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            CTSst sst = this._sstDoc.getSst();
            this.count = (int)sst.getCount();
            this.uniqueCount = (int)sst.getUniqueCount();
            for (CTRst st : sst.getSiArray()) {
                this.stmap.put(this.getKey(st), cnt);
                this.strings.add(st);
                ++cnt;
            }
        }
        catch (XmlException e) {
            throw new IOException(e);
        }
    }

    private String getKey(CTRst st) {
        return st.xmlText(options);
    }

    public CTRst getEntryAt(int idx) {
        return this.strings.get(idx);
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public int addEntry(CTRst st) {
        String s = this.getKey(st);
        ++this.count;
        if (this.stmap.containsKey(s)) {
            return this.stmap.get(s);
        }
        ++this.uniqueCount;
        CTRst newSt = this._sstDoc.getSst().addNewSi();
        newSt.set(st);
        int idx = this.strings.size();
        this.stmap.put(s, idx);
        this.strings.add(newSt);
        return idx;
    }

    public List<CTRst> getItems() {
        return this.strings;
    }

    public void writeTo(OutputStream out) throws IOException {
        XmlOptions options = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        options.setSaveCDataLengthThreshold(1000000);
        options.setSaveCDataEntityCountThreshold(-1);
        CTSst sst = this._sstDoc.getSst();
        sst.setCount(this.count);
        sst.setUniqueCount(this.uniqueCount);
        this._sstDoc.save(out, options);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    static {
        options.put("SAVE_INNER");
        options.put("SAVE_AGGRESSIVE_NAMESPACES");
        options.put("SAVE_USE_DEFAULT_NAMESPACE");
        options.setSaveImplicitNamespaces(Collections.singletonMap("", "http://schemas.openxmlformats.org/spreadsheetml/2006/main"));
    }
}

