/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.eventusermodel;

import com.fr.third.v2.org.apache.poi.openxml4j.opc.OPCPackage;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageRelationship;
import com.fr.third.v2.org.apache.poi.util.SAXHelper;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRelation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlySharedStringsTable
extends DefaultHandler {
    private int count;
    private int uniqueCount;
    private List<String> strings;
    private StringBuffer characters;
    private boolean tIsOpen;

    public ReadOnlySharedStringsTable(OPCPackage pkg) throws IOException, SAXException {
        ArrayList<PackagePart> parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.size() > 0) {
            PackagePart sstPart = parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    public ReadOnlySharedStringsTable(PackagePart part) throws IOException, SAXException {
        this.readFrom(part.getInputStream());
    }

    @Deprecated
    public ReadOnlySharedStringsTable(PackagePart part, PackageRelationship rel_ignored) throws IOException, SAXException {
        this(part);
    }

    public void readFrom(InputStream is) throws IOException, SAXException {
        if (is.available() > 0) {
            InputSource sheetSource = new InputSource(is);
            try {
                XMLReader sheetParser = SAXHelper.newXMLReader();
                sheetParser.setContentHandler(this);
                sheetParser.parse(sheetSource);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public String getEntryAt(int idx) {
        return this.strings.get(idx);
    }

    public List<String> getItems() {
        return this.strings;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("sst".equals(localName)) {
            String uniqueCount;
            String count = attributes.getValue("count");
            if (count != null) {
                this.count = Integer.parseInt(count);
            }
            if ((uniqueCount = attributes.getValue("uniqueCount")) != null) {
                this.uniqueCount = Integer.parseInt(uniqueCount);
            }
            this.strings = new ArrayList<String>(this.uniqueCount);
            this.characters = new StringBuffer();
        } else if ("si".equals(localName)) {
            this.characters.setLength(0);
        } else if ("t".equals(localName)) {
            this.tIsOpen = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("si".equals(localName)) {
            this.strings.add(this.characters.toString());
        } else if ("t".equals(localName)) {
            this.tIsOpen = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tIsOpen) {
            this.characters.append(ch, start, length);
        }
    }
}

