/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.formula;

import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationCell;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationSheet;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationTracker;
import com.fr.third.v2.org.apache.poi.ss.formula.EvaluationWorkbook;
import com.fr.third.v2.org.apache.poi.ss.formula.WorkbookEvaluator;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ValueEval;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Ptg;

final class SheetRefEvaluator {
    private final WorkbookEvaluator _bookEvaluator;
    private final EvaluationTracker _tracker;
    private final int _sheetIndex;
    private EvaluationSheet _sheet;

    public SheetRefEvaluator(WorkbookEvaluator bookEvaluator, EvaluationTracker tracker, int sheetIndex) {
        if (sheetIndex < 0) {
            throw new IllegalArgumentException("Invalid sheetIndex: " + sheetIndex + ".");
        }
        this._bookEvaluator = bookEvaluator;
        this._tracker = tracker;
        this._sheetIndex = sheetIndex;
    }

    public String getSheetName() {
        return this._bookEvaluator.getSheetName(this._sheetIndex);
    }

    public ValueEval getEvalForCell(int rowIndex, int columnIndex) {
        return this._bookEvaluator.evaluateReference(this.getSheet(), this._sheetIndex, rowIndex, columnIndex, this._tracker);
    }

    private EvaluationSheet getSheet() {
        if (this._sheet == null) {
            this._sheet = this._bookEvaluator.getSheet(this._sheetIndex);
        }
        return this._sheet;
    }

    public boolean isSubTotal(int rowIndex, int columnIndex) {
        boolean subtotal = false;
        EvaluationCell cell = this.getSheet().getCell(rowIndex, columnIndex);
        if (cell != null && cell.getCellType() == 2) {
            EvaluationWorkbook wb = this._bookEvaluator.getWorkbook();
            for (Ptg ptg : wb.getFormulaTokens(cell)) {
                FuncVarPtg f;
                if (!(ptg instanceof FuncVarPtg) || !"SUBTOTAL".equals((f = (FuncVarPtg)ptg).getName())) continue;
                subtotal = true;
                break;
            }
        }
        return subtotal;
    }
}

