/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.formula;

import com.fr.third.v2.org.apache.poi.ss.formula.OperationEvaluationContext;
import com.fr.third.v2.org.apache.poi.ss.formula.UserDefinedFunction;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ConcatEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.FunctionEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.IntersectionEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.PercentEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.RangeEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.RelationalOperationEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.TwoOperandNumericOperation;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.UnaryMinusEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.UnaryPlusEval;
import com.fr.third.v2.org.apache.poi.ss.formula.eval.ValueEval;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.Function;
import com.fr.third.v2.org.apache.poi.ss.formula.functions.Indirect;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AddPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.ConcatPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.DividePtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.EqualPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.GreaterEqualPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.GreaterThanPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.IntersectionPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.LessEqualPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.LessThanPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.MultiplyPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.NotEqualPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.OperationPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.PercentPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.PowerPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.RangePtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.SubtractPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.UnaryMinusPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.UnaryPlusPtg;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OperationEvaluatorFactory {
    private static final Map<OperationPtg, Function> _instancesByPtgClass = OperationEvaluatorFactory.initialiseInstancesMap();

    private OperationEvaluatorFactory() {
    }

    private static Map<OperationPtg, Function> initialiseInstancesMap() {
        HashMap<OperationPtg, Function> m = new HashMap<OperationPtg, Function>(32);
        OperationEvaluatorFactory.put(m, EqualPtg.instance, RelationalOperationEval.EqualEval);
        OperationEvaluatorFactory.put(m, GreaterEqualPtg.instance, RelationalOperationEval.GreaterEqualEval);
        OperationEvaluatorFactory.put(m, GreaterThanPtg.instance, RelationalOperationEval.GreaterThanEval);
        OperationEvaluatorFactory.put(m, LessEqualPtg.instance, RelationalOperationEval.LessEqualEval);
        OperationEvaluatorFactory.put(m, LessThanPtg.instance, RelationalOperationEval.LessThanEval);
        OperationEvaluatorFactory.put(m, NotEqualPtg.instance, RelationalOperationEval.NotEqualEval);
        OperationEvaluatorFactory.put(m, ConcatPtg.instance, ConcatEval.instance);
        OperationEvaluatorFactory.put(m, AddPtg.instance, TwoOperandNumericOperation.AddEval);
        OperationEvaluatorFactory.put(m, DividePtg.instance, TwoOperandNumericOperation.DivideEval);
        OperationEvaluatorFactory.put(m, MultiplyPtg.instance, TwoOperandNumericOperation.MultiplyEval);
        OperationEvaluatorFactory.put(m, PercentPtg.instance, PercentEval.instance);
        OperationEvaluatorFactory.put(m, PowerPtg.instance, TwoOperandNumericOperation.PowerEval);
        OperationEvaluatorFactory.put(m, SubtractPtg.instance, TwoOperandNumericOperation.SubtractEval);
        OperationEvaluatorFactory.put(m, UnaryMinusPtg.instance, UnaryMinusEval.instance);
        OperationEvaluatorFactory.put(m, UnaryPlusPtg.instance, UnaryPlusEval.instance);
        OperationEvaluatorFactory.put(m, RangePtg.instance, RangeEval.instance);
        OperationEvaluatorFactory.put(m, IntersectionPtg.instance, IntersectionEval.instance);
        return m;
    }

    private static void put(Map<OperationPtg, Function> m, OperationPtg ptgKey, Function instance) {
        Constructor<?>[] cc = ptgKey.getClass().getDeclaredConstructors();
        if (cc.length > 1 || !Modifier.isPrivate(cc[0].getModifiers())) {
            throw new RuntimeException("Failed to verify instance (" + ptgKey.getClass().getName() + ") is a singleton.");
        }
        m.put(ptgKey, instance);
    }

    public static ValueEval evaluate(OperationPtg ptg, ValueEval[] args, OperationEvaluationContext ec) {
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        Function result = _instancesByPtgClass.get(ptg);
        if (result != null) {
            return result.evaluate(args, ec.getRowIndex(), (short)ec.getColumnIndex());
        }
        if (ptg instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg fptg = (AbstractFunctionPtg)ptg;
            short functionIndex = fptg.getFunctionIndex();
            switch (functionIndex) {
                case 148: {
                    return Indirect.instance.evaluate(args, ec);
                }
                case 255: {
                    return UserDefinedFunction.instance.evaluate(args, ec);
                }
            }
            return FunctionEval.getBasicFunction(functionIndex).evaluate(args, ec.getRowIndex(), (short)ec.getColumnIndex());
        }
        throw new RuntimeException("Unexpected operation ptg class (" + ptg.getClass().getName() + ")");
    }
}

