/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.poifs.crypt.agile;

import com.fr.third.v2.org.apache.poi.EncryptedDocumentException;
import com.fr.third.v2.org.apache.poi.poifs.crypt.ChunkedCipherInputStream;
import com.fr.third.v2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import com.fr.third.v2.org.apache.poi.poifs.crypt.CryptoFunctions;
import com.fr.third.v2.org.apache.poi.poifs.crypt.Decryptor;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionHeader;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionVerifier;
import com.fr.third.v2.org.apache.poi.poifs.crypt.HashAlgorithm;
import com.fr.third.v2.org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import com.fr.third.v2.org.apache.poi.poifs.crypt.agile.AgileEncryptionInfoBuilder;
import com.fr.third.v2.org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.v2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AgileDecryptor
extends Decryptor {
    private long _length = -1L;
    protected static final byte[] kVerifierInputBlock = new byte[]{-2, -89, -46, 118, 59, 75, -98, 121};
    protected static final byte[] kHashedVerifierBlock = new byte[]{-41, -86, 15, 109, 48, 97, 52, 78};
    protected static final byte[] kCryptoKeyBlock = new byte[]{20, 110, 11, -25, -85, -84, -48, -42};
    protected static final byte[] kIntegrityKeyBlock = new byte[]{95, -78, -83, 1, 12, -71, -31, -10};
    protected static final byte[] kIntegrityValueBlock = new byte[]{-96, 103, 127, 2, -78, 44, -124, 51};

    protected AgileDecryptor(AgileEncryptionInfoBuilder builder) {
        super(builder);
    }

    public boolean verifyPassword(String password) throws GeneralSecurityException {
        AgileEncryptionVerifier ver = (AgileEncryptionVerifier)this.builder.getVerifier();
        AgileEncryptionHeader header = (AgileEncryptionHeader)this.builder.getHeader();
        HashAlgorithm hashAlgo = header.getHashAlgorithmEx();
        CipherAlgorithm cipherAlgo = header.getCipherAlgorithm();
        int blockSize = header.getBlockSize();
        int keySize = header.getKeySize() / 8;
        byte[] pwHash = CryptoFunctions.hashPassword(password, ver.getHashAlgorithm(), ver.getSalt(), ver.getSpinCount());
        byte[] verfierInputEnc = AgileDecryptor.hashInput(this.builder, pwHash, kVerifierInputBlock, ver.getEncryptedVerifier(), 2);
        this.setVerifier(verfierInputEnc);
        MessageDigest hashMD = CryptoFunctions.getMessageDigest(hashAlgo);
        byte[] verifierHash = hashMD.digest(verfierInputEnc);
        byte[] verifierHashDec = AgileDecryptor.hashInput(this.builder, pwHash, kHashedVerifierBlock, ver.getEncryptedVerifierHash(), 2);
        verifierHashDec = CryptoFunctions.getBlock0(verifierHashDec, hashAlgo.hashSize);
        byte[] keyspec = AgileDecryptor.hashInput(this.builder, pwHash, kCryptoKeyBlock, ver.getEncryptedKey(), 2);
        keyspec = CryptoFunctions.getBlock0(keyspec, keySize);
        SecretKeySpec secretKey = new SecretKeySpec(keyspec, ver.getCipherAlgorithm().jceId);
        byte[] vec = CryptoFunctions.generateIv(hashAlgo, header.getKeySalt(), kIntegrityKeyBlock, blockSize);
        Cipher cipher = CryptoFunctions.getCipher(secretKey, cipherAlgo, ver.getChainingMode(), vec, 2);
        byte[] hmacKey = cipher.doFinal(header.getEncryptedHmacKey());
        hmacKey = CryptoFunctions.getBlock0(hmacKey, hashAlgo.hashSize);
        vec = CryptoFunctions.generateIv(hashAlgo, header.getKeySalt(), kIntegrityValueBlock, blockSize);
        cipher = CryptoFunctions.getCipher(secretKey, cipherAlgo, ver.getChainingMode(), vec, 2);
        byte[] hmacValue = cipher.doFinal(header.getEncryptedHmacValue());
        hmacValue = CryptoFunctions.getBlock0(hmacValue, hashAlgo.hashSize);
        if (Arrays.equals(verifierHashDec, verifierHash)) {
            this.setSecretKey(secretKey);
            this.setIntegrityHmacKey(hmacKey);
            this.setIntegrityHmacValue(hmacValue);
            return true;
        }
        return false;
    }

    public boolean verifyPassword(KeyPair keyPair, X509Certificate x509) throws GeneralSecurityException {
        AgileEncryptionVerifier ver = (AgileEncryptionVerifier)this.builder.getVerifier();
        AgileEncryptionHeader header = (AgileEncryptionHeader)this.builder.getHeader();
        HashAlgorithm hashAlgo = header.getHashAlgorithmEx();
        CipherAlgorithm cipherAlgo = header.getCipherAlgorithm();
        int blockSize = header.getBlockSize();
        AgileEncryptionVerifier.AgileCertificateEntry ace = null;
        for (AgileEncryptionVerifier.AgileCertificateEntry aceEntry : ver.getCertificates()) {
            if (!x509.equals(aceEntry.x509)) continue;
            ace = aceEntry;
            break;
        }
        if (ace == null) {
            return false;
        }
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, keyPair.getPrivate());
        byte[] keyspec = cipher.doFinal(ace.encryptedKey);
        SecretKeySpec secretKey = new SecretKeySpec(keyspec, ver.getCipherAlgorithm().jceId);
        Mac x509Hmac = CryptoFunctions.getMac(hashAlgo);
        x509Hmac.init(secretKey);
        byte[] certVerifier = x509Hmac.doFinal(ace.x509.getEncoded());
        byte[] vec = CryptoFunctions.generateIv(hashAlgo, header.getKeySalt(), kIntegrityKeyBlock, blockSize);
        cipher = CryptoFunctions.getCipher(secretKey, cipherAlgo, ver.getChainingMode(), vec, 2);
        byte[] hmacKey = cipher.doFinal(header.getEncryptedHmacKey());
        hmacKey = CryptoFunctions.getBlock0(hmacKey, hashAlgo.hashSize);
        vec = CryptoFunctions.generateIv(hashAlgo, header.getKeySalt(), kIntegrityValueBlock, blockSize);
        cipher = CryptoFunctions.getCipher(secretKey, cipherAlgo, ver.getChainingMode(), vec, 2);
        byte[] hmacValue = cipher.doFinal(header.getEncryptedHmacValue());
        hmacValue = CryptoFunctions.getBlock0(hmacValue, hashAlgo.hashSize);
        if (Arrays.equals(ace.certVerifier, certVerifier)) {
            this.setSecretKey(secretKey);
            this.setIntegrityHmacKey(hmacKey);
            this.setIntegrityHmacValue(hmacValue);
            return true;
        }
        return false;
    }

    protected static int getNextBlockSize(int inputLen, int blockSize) {
        int fillSize;
        for (fillSize = blockSize; fillSize < inputLen; fillSize += blockSize) {
        }
        return fillSize;
    }

    protected static byte[] hashInput(EncryptionInfoBuilder builder, byte[] pwHash, byte[] blockKey, byte[] inputKey, int cipherMode) {
        EncryptionVerifier ver = builder.getVerifier();
        AgileDecryptor dec = (AgileDecryptor)builder.getDecryptor();
        int keySize = dec.getKeySizeInBytes();
        int blockSize = dec.getBlockSizeInBytes();
        HashAlgorithm hashAlgo = ver.getHashAlgorithm();
        byte[] salt = ver.getSalt();
        byte[] intermedKey = CryptoFunctions.generateKey(pwHash, hashAlgo, blockKey, keySize);
        SecretKeySpec skey = new SecretKeySpec(intermedKey, ver.getCipherAlgorithm().jceId);
        byte[] iv = CryptoFunctions.generateIv(hashAlgo, salt, null, blockSize);
        Cipher cipher = CryptoFunctions.getCipher(skey, ver.getCipherAlgorithm(), ver.getChainingMode(), iv, cipherMode);
        try {
            inputKey = CryptoFunctions.getBlock0(inputKey, AgileDecryptor.getNextBlockSize(inputKey.length, blockSize));
            byte[] hashFinal = cipher.doFinal(inputKey);
            return hashFinal;
        }
        catch (GeneralSecurityException e) {
            throw new EncryptedDocumentException(e);
        }
    }

    public InputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        DocumentInputStream dis = dir.createDocumentInputStream("EncryptedPackage");
        this._length = dis.readLong();
        return new AgileCipherInputStream(dis, this._length);
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("EcmaDecryptor.getDataStream() was not called");
        }
        return this._length;
    }

    protected static Cipher initCipherForBlock(Cipher existing, int block, boolean lastChunk, EncryptionInfoBuilder builder, SecretKey skey, int encryptionMode) throws GeneralSecurityException {
        EncryptionHeader header = builder.getHeader();
        if (existing == null || lastChunk) {
            String padding = lastChunk ? "PKCS5Padding" : "NoPadding";
            existing = CryptoFunctions.getCipher(skey, header.getCipherAlgorithm(), header.getChainingMode(), header.getKeySalt(), encryptionMode, padding);
        }
        byte[] blockKey = new byte[4];
        LittleEndian.putInt(blockKey, 0, block);
        byte[] iv = CryptoFunctions.generateIv(header.getHashAlgorithmEx(), header.getKeySalt(), blockKey, header.getBlockSize());
        AlgorithmParameterSpec aps = header.getCipherAlgorithm() == CipherAlgorithm.rc2 ? new RC2ParameterSpec(skey.getEncoded().length * 8, iv) : new IvParameterSpec(iv);
        existing.init(encryptionMode, (Key)skey, aps);
        return existing;
    }

    private class AgileCipherInputStream
    extends ChunkedCipherInputStream {
        public AgileCipherInputStream(DocumentInputStream stream, long size) throws GeneralSecurityException {
            super(stream, size, 4096);
        }

        protected Cipher initCipherForBlock(Cipher cipher, int block) throws GeneralSecurityException {
            return AgileDecryptor.initCipherForBlock(cipher, block, false, AgileDecryptor.this.builder, AgileDecryptor.this.getSecretKey(), 2);
        }
    }
}

