/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi;

import com.fr.third.v2.org.apache.poi.hpsf.DocumentSummaryInformation;
import com.fr.third.v2.org.apache.poi.hpsf.HPSFException;
import com.fr.third.v2.org.apache.poi.hpsf.MutablePropertySet;
import com.fr.third.v2.org.apache.poi.hpsf.PropertySet;
import com.fr.third.v2.org.apache.poi.hpsf.PropertySetFactory;
import com.fr.third.v2.org.apache.poi.hpsf.SummaryInformation;
import com.fr.third.v2.org.apache.poi.hpsf.WritingNotSupportedException;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.v2.org.apache.poi.util.Internal;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class POIDocument {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    protected DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized = false;

    protected POIDocument(DirectoryNode dir) {
        this.directory = dir;
    }

    protected POIDocument(OPOIFSFileSystem fs) {
        this(fs.getRoot());
    }

    protected POIDocument(NPOIFSFileSystem fs) {
        this(fs.getRoot());
    }

    protected POIDocument(POIFSFileSystem fs) {
        this(fs.getRoot());
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    public void createInformationProperties() {
        if (!this.initialized) {
            this.readProperties();
        }
        if (this.sInf == null) {
            this.sInf = PropertySetFactory.newSummaryInformation();
        }
        if (this.dsInf == null) {
            this.dsInf = PropertySetFactory.newDocumentSummaryInformation();
        }
    }

    protected void readProperties() {
        PropertySet ps = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (ps != null && ps instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)ps;
        } else if (ps != null) {
            logger.log(5, "DocumentSummaryInformation property set came back with wrong class - ", ps.getClass());
        }
        ps = this.getPropertySet("\u0005SummaryInformation");
        if (ps instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)ps;
        } else if (ps != null) {
            logger.log(5, "SummaryInformation property set came back with wrong class - ", ps.getClass());
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String setName) {
        return this.getPropertySet(setName, null);
    }

    protected PropertySet getPropertySet(String setName, EncryptionInfo encryptionInfo) {
        DocumentInputStream dis;
        DirectoryNode dirNode = this.directory;
        NPOIFSFileSystem encPoifs = null;
        if (encryptionInfo != null) {
            try {
                InputStream is = encryptionInfo.getDecryptor().getDataStream(this.directory);
                encPoifs = new NPOIFSFileSystem(is);
                is.close();
                dirNode = encPoifs.getRoot();
            }
            catch (Exception e) {
                logger.log(7, new Object[]{"Error getting encrypted property set with name " + setName, e});
                return null;
            }
        }
        if (dirNode == null || !dirNode.hasEntry(setName)) {
            return null;
        }
        try {
            dis = dirNode.createDocumentInputStream(dirNode.getEntry(setName));
        }
        catch (IOException ie) {
            logger.log(5, new Object[]{"Error getting property set with name " + setName + "\n" + ie});
            return null;
        }
        try {
            PropertySet set = PropertySetFactory.create(dis);
            if (encPoifs != null) {
                encPoifs.close();
            }
            return set;
        }
        catch (IOException ie) {
            logger.log(5, new Object[]{"Error creating property set with name " + setName + "\n" + ie});
        }
        catch (HPSFException he) {
            logger.log(5, new Object[]{"Error creating property set with name " + setName + "\n" + he});
        }
        return null;
    }

    protected void writeProperties() throws IOException {
        throw new IllegalStateException("In-place write is not yet supported");
    }

    protected void writeProperties(NPOIFSFileSystem outFS) throws IOException {
        this.writeProperties(outFS, null);
    }

    protected void writeProperties(NPOIFSFileSystem outFS, List<String> writtenEntries) throws IOException {
        DocumentSummaryInformation dsi;
        SummaryInformation si = this.getSummaryInformation();
        if (si != null) {
            this.writePropertySet("\u0005SummaryInformation", si, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005SummaryInformation");
            }
        }
        if ((dsi = this.getDocumentSummaryInformation()) != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", dsi, outFS);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String name, PropertySet set, NPOIFSFileSystem outFS) throws IOException {
        try {
            MutablePropertySet mSet = new MutablePropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write(bOut);
            byte[] data = bOut.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            outFS.createDocument(bIn, name);
            logger.log(3, new Object[]{"Wrote property set " + name + " of size " + data.length});
        }
        catch (WritingNotSupportedException wnse) {
            logger.log(7, new Object[]{"Couldn't write property set with name " + name + " as not supported by HPSF yet"});
        }
    }

    public abstract void write(OutputStream var1) throws IOException;

    @Internal
    public DirectoryNode getDirectory() {
        return this.directory;
    }
}

