/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.jobs;

import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeJob
implements Job {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String PROP_COMMAND = "command";
    public static final String PROP_PARAMETERS = "parameters";
    public static final String PROP_WAIT_FOR_PROCESS = "waitForProcess";
    public static final String PROP_CONSUME_STREAMS = "consumeStreams";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getMergedJobDataMap();
        String command = data.getString(PROP_COMMAND);
        String parameters = data.getString(PROP_PARAMETERS);
        if (parameters == null) {
            parameters = "";
        }
        boolean wait = true;
        if (data.containsKey(PROP_WAIT_FOR_PROCESS)) {
            wait = data.getBooleanValue(PROP_WAIT_FOR_PROCESS);
        }
        boolean consumeStreams = false;
        if (data.containsKey(PROP_CONSUME_STREAMS)) {
            consumeStreams = data.getBooleanValue(PROP_CONSUME_STREAMS);
        }
        Integer exitCode = this.runNativeCommand(command, parameters, wait, consumeStreams);
        context.setResult(exitCode);
    }

    protected Log getLog() {
        return this.log;
    }

    private Integer runNativeCommand(String command, String parameters, boolean wait, boolean consumeStreams) throws JobExecutionException {
        String[] cmd = null;
        String[] args = new String[2];
        Integer result = null;
        args[0] = command;
        args[1] = parameters;
        try {
            int i;
            String osName = System.getProperty("os.name");
            if (osName.equals("Windows NT")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows 95")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "command.com";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows 2003")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows 2000")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Windows XP")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                for (i = 0; i < args.length; ++i) {
                    cmd[i + 2] = args[i];
                }
            } else if (osName.equals("Linux")) {
                if (cmd == null) {
                    cmd = new String[]{"/bin/sh", "-c", args[0] + " " + args[1]};
                }
            } else {
                cmd = args;
            }
            Runtime rt = Runtime.getRuntime();
            this.getLog().info("About to run" + cmd[0] + " " + cmd[1] + " " + (cmd.length > 2 ? cmd[2] : "") + " ...");
            Process proc = rt.exec(cmd);
            StreamConsumer stdoutConsumer = new StreamConsumer(proc.getInputStream(), "stdout");
            if (consumeStreams) {
                StreamConsumer stderrConsumer = new StreamConsumer(proc.getErrorStream(), "stderr");
                stdoutConsumer.start();
                stderrConsumer.start();
            }
            if (wait) {
                result = new Integer(proc.waitFor());
            }
        }
        catch (Exception x) {
            throw new JobExecutionException("Error launching native command: ", (Throwable)x, false);
        }
        return result;
    }

    class StreamConsumer
    extends Thread {
        InputStream is;
        String type;

        public StreamConsumer(InputStream inputStream, String type) {
            this.is = inputStream;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(this.is));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (this.type.equalsIgnoreCase("stderr")) {
                    NativeJob.this.getLog().warn(this.type + ">" + line);
                    continue;
                }
                NativeJob.this.getLog().info(this.type + ">" + line);
            }
            Object var4_4 = null;
            if (br == null) return;
            try {
                br.close();
                return;
            }
            catch (Exception ignore) {}
            return;
            {
                catch (IOException ioe) {
                    NativeJob.this.getLog().error("Error consuming " + this.type + " stream of spawned process.", ioe);
                    Object var4_5 = null;
                    if (br == null) return;
                    try {
                        br.close();
                        return;
                    }
                    catch (Exception ignore) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (br == null) throw throwable;
                try {
                    br.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

