/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.quartz.core;

import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.Trigger;
import com.fr.third.org.quartz.core.QuartzScheduler;
import com.fr.third.org.quartz.core.QuartzSchedulerThread;
import com.fr.third.org.quartz.spi.SchedulerSignaler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchedulerSignalerImpl
implements SchedulerSignaler {
    Log log = LogFactory.getLog(SchedulerSignalerImpl.class);
    protected QuartzScheduler sched;
    protected QuartzSchedulerThread schedThread;

    public SchedulerSignalerImpl(QuartzScheduler sched, QuartzSchedulerThread schedThread) {
        this.sched = sched;
        this.schedThread = schedThread;
        this.log.info("Initialized Scheduler Signaller of type: " + this.getClass());
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) {
        try {
            this.sched.notifyTriggerListenersMisfired(trigger);
        }
        catch (SchedulerException se) {
            this.sched.getLog().error("Error notifying listeners of trigger misfire.", se);
            this.sched.notifySchedulerListenersError("Error notifying listeners of trigger misfire.", se);
        }
    }

    public void notifySchedulerListenersFinalized(Trigger trigger) {
        this.sched.notifySchedulerListenersFinalized(trigger);
    }

    public void signalSchedulingChange(long candidateNewNextFireTime) {
        this.schedThread.signalSchedulingChange(candidateNewNextFireTime);
    }
}

