/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.util;

import com.fr.third.org.hsqldb.util.SqlTool;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class SqlToolSprayer {
    public static String LS = System.getProperty("line.separator");
    private static String SYNTAX_MSG = "SYNTAX:  java [-D...] SqlToolSprayer 'SQL;' [urlid1 urlid2...]\nSystem properties you may use [default values]:\n    sqltoolsprayer.period (in ms.) [500]\n    sqltoolsprayer.maxtime (in ms.) [0]\n    sqltoolsprayer.monfile (filepath) [none]\n    sqltoolsprayer.rcfile (filepath) [none.  SqlTool default used.]\n    sqltoolsprayer.propfile (filepath) [none]";

    public static void main(String[] sa) {
        if (sa.length < 1) {
            System.err.println(SYNTAX_MSG);
            System.exit(4);
        }
        long period = System.getProperty("sqltoolsprayer.period") == null ? 500 : Integer.parseInt(System.getProperty("sqltoolsprayer.period"));
        long maxtime = System.getProperty("sqltoolsprayer.maxtime") == null ? 0 : Integer.parseInt(System.getProperty("sqltoolsprayer.maxtime"));
        String rcFile = System.getProperty("sqltoolsprayer.rcfile");
        String propfile = System.getProperty("sqltoolsprayer.propfile");
        File monitorFile = System.getProperty("sqltoolsprayer.monfile") == null ? null : new File(System.getProperty("sqltoolsprayer.monfile"));
        ArrayList<String> urlids = new ArrayList<String>();
        if (propfile != null) {
            try {
                SqlToolSprayer.getUrlsFromPropFile(propfile, urlids);
            }
            catch (Exception e) {
                System.err.println("Failed to load property file '" + propfile + "':  " + e);
                System.exit(3);
            }
        }
        for (int i = 1; i < sa.length; ++i) {
            urlids.add(sa[i]);
        }
        boolean[] status = new boolean[urlids.size()];
        for (int i = 0; i < status.length; ++i) {
            status[i] = false;
        }
        String[] withRcArgs = new String[]{"--sql", sa[0], "--rcfile", rcFile, null};
        String[] withoutRcArgs = new String[]{"--sql", sa[0], null};
        String[] sqlToolArgs = rcFile == null ? withoutRcArgs : withRcArgs;
        boolean onefailed = false;
        long startTime = new Date().getTime();
        while (true) {
            if (monitorFile != null && !monitorFile.exists()) {
                System.err.println("Required file is gone:  " + monitorFile);
                System.exit(2);
            }
            onefailed = false;
            for (int i = 0; i < status.length; ++i) {
                if (status[i]) continue;
                sqlToolArgs[sqlToolArgs.length - 1] = (String)urlids.get(i);
                try {
                    new SqlTool();
                    SqlTool.objectMain(sqlToolArgs);
                    status[i] = true;
                    System.err.println("Success for instance '" + urlids.get(i) + "'");
                    continue;
                }
                catch (SqlTool.SqlToolException se) {
                    onefailed = true;
                }
            }
            if (!onefailed || maxtime == 0L || new Date().getTime() > startTime + maxtime) break;
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException ie) {}
        }
        ArrayList failedUrlids = new ArrayList();
        for (int i = 0; i < status.length; ++i) {
            if (status[i]) continue;
            failedUrlids.add(urlids.get(i));
        }
        if (failedUrlids.size() > 0) {
            System.err.println("Failed instances:   " + failedUrlids);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void getUrlsFromPropFile(String fileName, ArrayList al) throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream(fileName));
        int i = -1;
        String val;
        while ((val = p.getProperty("server.urlid." + ++i)) != null) {
            al.add(val);
        }
        return;
    }

    static {
        if (!LS.equals("\n")) {
            SYNTAX_MSG = SYNTAX_MSG.replaceAll("\n", LS);
        }
    }
}

