/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.store;

import com.fr.third.org.hsqldb.store.ValuePoolHashMap;
import java.math.BigDecimal;
import java.sql.Date;

public class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static ValuePoolHashMap datePool;
    static final int DEFAULT_VALUE_POOL_SIZE = 10000;
    static final int[] defaultPoolLookupSize;
    static final int POOLS_COUNT;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] sizeArray = defaultPoolLookupSize;
        int sizeFactor = 2;
        Class clazz = ValuePool.class;
        synchronized (clazz) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[POOLS_COUNT];
            for (int i = 0; i < POOLS_COUNT; ++i) {
                int size = sizeArray[i];
                ValuePool.poolList[i] = new ValuePoolHashMap(size, size * sizeFactor, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            datePool = poolList[5];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool(int[] sizeArray, int sizeFactor) {
        Class clazz = ValuePool.class;
        synchronized (clazz) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].resetCapacity(sizeArray[i] * sizeFactor, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool() {
        Class clazz = ValuePool.class;
        synchronized (clazz) {
            ValuePool.resetPool(defaultPoolLookupSize, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool() {
        Class clazz = ValuePool.class;
        synchronized (clazz) {
            for (int i = 0; i < POOLS_COUNT; ++i) {
                poolList[i].clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInt(int val) {
        ValuePoolHashMap valuePoolHashMap = intPool;
        synchronized (valuePoolHashMap) {
            return intPool.getOrAddInteger(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(long val) {
        ValuePoolHashMap valuePoolHashMap = longPool;
        synchronized (valuePoolHashMap) {
            return longPool.getOrAddLong(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(long val) {
        ValuePoolHashMap valuePoolHashMap = doublePool;
        synchronized (valuePoolHashMap) {
            return doublePool.getOrAddDouble(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String val) {
        if (val == null || val.length() > maxStringLength) {
            return val;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDate(long val) {
        ValuePoolHashMap valuePoolHashMap = datePool;
        synchronized (valuePoolHashMap) {
            return datePool.getOrAddDate(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimal(BigDecimal val) {
        if (val == null) {
            return val;
        }
        ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
        synchronized (valuePoolHashMap) {
            return (BigDecimal)bigdecimalPool.getOrAddObject(val);
        }
    }

    public static Boolean getBoolean(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        defaultPoolLookupSize = new int[]{10000, 10000, 10000, 10000, 10000, 10000};
        POOLS_COUNT = defaultPoolLookupSize.length;
        ValuePool.initPool();
    }
}

