/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb.persist;

import com.fr.third.org.hsqldb.persist.LockFile;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

final class NIOLockFile
extends LockFile {
    public static final long MAX_LOCK_REGION = Long.MAX_VALUE;
    public static final long MAX_NFS_LOCK_REGION = 0x40000000L;
    public static final long MIN_LOCK_REGION = 16L;
    public static final boolean POSIX_MANDITORY_FILELOCK_DEFAULT = false;
    public static final String POSIX_MANDITORY_FILELOCK_PROPERTY = "hsqldb.lockfile.posix.manditory.filelock";
    private volatile FileLock fileLock;

    NIOLockFile() {
    }

    public boolean isPosixManditoryFileLock() {
        boolean manditory = false;
        try {
            manditory = "true".equalsIgnoreCase(System.getProperty(POSIX_MANDITORY_FILELOCK_PROPERTY, manditory ? "true" : "false"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return manditory;
    }

    protected boolean doOptionalLockActions() {
        return this.aquireFileLock();
    }

    protected boolean doOptionalReleaseActions() {
        return this.releaseFileLock();
    }

    public boolean isValid() {
        try {
            return super.isValid() && this.fileLock != null && this.fileLock.isValid();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String toStringImpl() {
        return "fileLock = " + this.fileLock;
    }

    private boolean aquireFileLock() {
        RandomAccessFile lraf = this.raf;
        boolean success = false;
        try {
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    return true;
                }
                this.releaseFileLock();
            }
            if (this.isPosixManditoryFileLock()) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "g+s,g-x", this.file.getPath()});
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.fileLock = lraf.getChannel().tryLock(0L, 16L, false);
            success = this.fileLock != null && this.fileLock.isValid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!success) {
            this.releaseFileLock();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseFileLock() {
        boolean success = false;
        if (this.fileLock == null) {
            success = true;
        } else {
            try {
                this.fileLock.release();
                success = true;
            }
            catch (Exception exception) {
            }
            finally {
                this.fileLock = null;
            }
        }
        return success;
    }
}

