/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.BaseTable;
import com.fr.third.org.hsqldb.CachedDataRow;
import com.fr.third.org.hsqldb.CachedRow;
import com.fr.third.org.hsqldb.Column;
import com.fr.third.org.hsqldb.Constraint;
import com.fr.third.org.hsqldb.Database;
import com.fr.third.org.hsqldb.DatabaseURL;
import com.fr.third.org.hsqldb.Expression;
import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.HsqlNameManager;
import com.fr.third.org.hsqldb.Index;
import com.fr.third.org.hsqldb.Node;
import com.fr.third.org.hsqldb.NumberSequence;
import com.fr.third.org.hsqldb.Parser;
import com.fr.third.org.hsqldb.Record;
import com.fr.third.org.hsqldb.Result;
import com.fr.third.org.hsqldb.Row;
import com.fr.third.org.hsqldb.Select;
import com.fr.third.org.hsqldb.Session;
import com.fr.third.org.hsqldb.Tokenizer;
import com.fr.third.org.hsqldb.Trace;
import com.fr.third.org.hsqldb.TriggerDef;
import com.fr.third.org.hsqldb.index.RowIterator;
import com.fr.third.org.hsqldb.lib.ArrayUtil;
import com.fr.third.org.hsqldb.lib.HashMappedList;
import com.fr.third.org.hsqldb.lib.HashSet;
import com.fr.third.org.hsqldb.lib.HsqlArrayList;
import com.fr.third.org.hsqldb.lib.Iterator;
import com.fr.third.org.hsqldb.lib.StringUtil;
import com.fr.third.org.hsqldb.persist.CachedObject;
import com.fr.third.org.hsqldb.persist.DataFileCache;
import com.fr.third.org.hsqldb.persist.PersistentStore;
import com.fr.third.org.hsqldb.rowio.RowInputInterface;
import com.fr.third.org.hsqldb.store.ValuePool;
import java.io.IOException;

public class Table
extends BaseTable {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW = 7;
    static final int SYSTEM_VIEW = 8;
    public HashMappedList columnList;
    private int[] primaryKeyCols;
    private int[] primaryKeyTypes;
    private int[] primaryKeyColsSequence;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    Constraint[] constraintList;
    HsqlArrayList[] triggerLists;
    private int[] colTypes;
    int[] colSizes;
    private int[] colScales;
    private boolean[] colNullable;
    Expression[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    boolean sqlEnforceSize;
    protected int columnCount;
    public Database database;
    protected DataFileCache cache;
    protected HsqlNameManager.HsqlName tableName;
    private int tableType;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected boolean isText;
    protected boolean isMemory;
    private boolean isView;
    protected boolean isLogged;
    protected int indexType;
    protected boolean onCommitPreserve;
    PersistentStore rowStore;
    Index[] indexList;
    HashSet constraintPath;
    HashMappedList tableUpdateList;

    Table(Database db, HsqlNameManager.HsqlName name, int type) throws HsqlException {
        this.database = db;
        this.sqlEnforceSize = db.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(null, 0L, 1L, -5);
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        switch (type) {
            case 1: {
                this.isTemp = true;
                this.isMemory = true;
                break;
            }
            case 0: {
                this.isMemory = true;
                break;
            }
            case 4: {
                if (DatabaseURL.isFileBasedDatabaseType(db.getType())) {
                    this.cache = db.logger.getCache();
                    this.isCached = true;
                    this.isLogged = !this.database.isFilesReadOnly();
                    this.indexType = 1;
                    this.rowStore = new RowStore();
                    break;
                }
                type = 3;
            }
            case 3: {
                this.isMemory = true;
                this.isLogged = !this.database.isFilesReadOnly();
                break;
            }
            case 2: {
                this.isMemory = true;
                this.isTemp = true;
                break;
            }
            case 5: {
                if (!DatabaseURL.isFileBasedDatabaseType(db.getType())) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.indexType = 2;
                this.rowStore = new RowStore();
                break;
            }
            case 6: {
                if (!DatabaseURL.isFileBasedDatabaseType(db.getType())) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.indexType = 2;
                this.rowStore = new RowStore();
                break;
            }
            case 7: 
            case 8: {
                this.isView = true;
            }
        }
        this.tableType = type;
        this.tableName = name;
        this.primaryKeyCols = null;
        this.primaryKeyTypes = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = new Index[0];
        this.constraintList = new Constraint[0];
        this.triggerLists = new HsqlArrayList[12];
        if (db.isFilesReadOnly() && this.isFileBased()) {
            this.setIsReadOnly(true);
        }
    }

    boolean equals(Session session, String name) {
        return this.tableName.name.equals(name);
    }

    boolean equals(String name) {
        return this.tableName.name.equals(name);
    }

    boolean equals(HsqlNameManager.HsqlName name) {
        return this.tableName.equals(name);
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isDataReadOnly();
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    protected void setIsReadOnly(boolean newReadOnly) {
        this.isReadOnly = newReadOnly;
        this.database.setMetaDirty(true);
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isDataReadOnly()) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean value) throws HsqlException {
        if (!value && this.database.isFilesReadOnly() && this.isFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = value;
    }

    boolean isFileBased() {
        return this.isCached || this.isText;
    }

    protected void setDataSource(Session s, String source, boolean isDesc, boolean newFile) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    public void setHeader(String header) throws HsqlException {
        throw Trace.error(150);
    }

    public String getHeader() {
        return null;
    }

    public boolean isConnected() {
        return true;
    }

    public void connect(Session session) throws HsqlException {
        throw Trace.error(255);
    }

    public void disconnect(Session session) throws HsqlException {
        throw Trace.error(255);
    }

    void addConstraint(Constraint c) {
        int position = c.constType == 4 ? 0 : this.constraintList.length;
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, c, position, 1);
    }

    Constraint[] getConstraints() {
        return this.constraintList;
    }

    Constraint getPrimaryConstraint() {
        return this.primaryKeyCols.length == 0 ? null : this.constraintList[0];
    }

    Index getUniqueConstraintIndexForColumns(int[] col) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), col, col.length, true)) {
            return this.getPrimaryIndex();
        }
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getType() != 2 || !ArrayUtil.areEqual(c.getMainColumns(), col, col.length, true)) continue;
            return c.getMainIndex();
        }
        return null;
    }

    Constraint getConstraintForColumns(Table tablemain, int[] colmain, int[] colref) {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (!c.isEquivalent(tablemain, colmain, this, colref)) continue;
            return c;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] cols) {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (!c.isEquivalent(cols, 2)) continue;
            return c;
        }
        return null;
    }

    Constraint getUniqueOrPKConstraintForIndex(Index index) {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getMainIndex() != index || c.getType() != 2 && c.getType() != 4) continue;
            return c;
        }
        return null;
    }

    int getNextConstraintIndex(int from, int type) {
        int size = this.constraintList.length;
        for (int i = from; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getType() != type) continue;
            return i;
        }
        return -1;
    }

    void addColumn(Column column) throws HsqlException {
        if (this.findColumn(column.columnName.name) >= 0) {
            throw Trace.error(27, column.columnName.name);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.columnCount;
        }
        if (this.primaryKeyCols != null) {
            Trace.doAssert(false, "Table.addColumn");
        }
        this.columnList.add(column.columnName.name, column);
        ++this.columnCount;
    }

    void addColumns(Result.ResultMetaData metadata, int count) throws HsqlException {
        for (int i = 0; i < count; ++i) {
            Column column = new Column(this.database.nameManager.newHsqlName(metadata.colLabels[i], metadata.isLabelQuoted[i]), true, metadata.colTypes[i], metadata.colSizes[i], metadata.colScales[i], false, null);
            this.addColumn(column);
        }
    }

    void addColumns(Select select) throws HsqlException {
        int colCount = select.iResultLen;
        for (int i = 0; i < colCount; ++i) {
            Expression e = select.exprColumns[i];
            Column column = new Column(this.database.nameManager.newHsqlName(e.getAlias(), e.isAliasQuoted()), true, e.getDataType(), e.getColumnSize(), e.getColumnScale(), false, null);
            this.addColumn(column);
        }
    }

    public HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    public int getId() {
        return this.tableName.hashCode();
    }

    void rename(Session session, String newname, boolean isquoted) throws HsqlException {
        String oldname = this.tableName.name;
        this.tableName.rename(newname, isquoted);
        this.renameTableInCheckConstraints(session, oldname, newname);
    }

    int getInternalColumnCount() {
        return this.columnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table t = new Table(this.database, this.tableName, this.tableType);
        t.onCommitPreserve = this.onCommitPreserve;
        return t;
    }

    void checkColumnsMatch(int[] col, Table other, int[] othercol) throws HsqlException {
        if (col.length != othercol.length) {
            throw Trace.error(5);
        }
        for (int i = 0; i < col.length; ++i) {
            if (col[i] >= this.columnCount || othercol[i] >= other.columnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(col[i]).getType() == other.getColumn(othercol[i]).getType()) continue;
            throw Trace.error(57);
        }
    }

    Table moveDefinition(int[] removeIndex, Column newColumn, int colIndex, int adjust) throws HsqlException {
        int[] primarykey;
        Table tn = this.duplicate();
        for (int i = 0; i < this.columnCount + 1; ++i) {
            if (i == colIndex) {
                if (adjust == 0) {
                    if (newColumn != null) {
                        tn.addColumn(newColumn);
                        continue;
                    }
                } else if (adjust > 0) {
                    tn.addColumn(newColumn);
                } else if (adjust < 0) continue;
            }
            if (i == this.columnCount) break;
            tn.addColumn(this.getColumn(i));
        }
        int[] nArray = primarykey = this.primaryKeyCols.length == 0 ? null : this.primaryKeyCols;
        if (primarykey != null) {
            int[] newpk = ArrayUtil.toAdjustedColumnArray(primarykey, colIndex, adjust);
            if (primarykey.length != newpk.length) {
                throw Trace.error(25);
            }
            primarykey = newpk;
        }
        tn.createPrimaryKey(this.getIndex(0).getName(), primarykey, false);
        tn.constraintList = this.constraintList;
        Index idx = null;
        if (removeIndex != null) {
            idx = this.getIndex(removeIndex, colIndex);
        }
        if (idx != null) {
            if (idx.isConstraint()) {
                throw Trace.error(252);
            }
            throw Trace.error(123);
        }
        for (int i = 1; i < this.indexList.length; ++i) {
            if (removeIndex != null && ArrayUtil.find(removeIndex, i) != -1) continue;
            tn.createAdjustedIndex(this.indexList[i], colIndex, adjust);
        }
        tn.triggerLists = this.triggerLists;
        return tn;
    }

    Index getIndex(int[] exclude, int colIndex) {
        for (int i = 1; i < this.indexList.length; ++i) {
            Index idx;
            int[] cols;
            if (exclude != null && ArrayUtil.find(exclude, i) != -1 || ArrayUtil.find(cols = (idx = this.indexList[i]).getColumns(), colIndex) == -1) continue;
            return idx;
        }
        return null;
    }

    private void copyIndexes(Table tn, int removeIndex, int colIndex, int adjust) throws HsqlException {
        for (int i = 1; i < this.getIndexCount(); ++i) {
            Index newidx;
            Index idx = this.indexList[i];
            if (removeIndex == i || (newidx = tn.createAdjustedIndex(idx, colIndex, adjust)) != null) continue;
            throw Trace.error(123);
        }
    }

    Table moveDefinitionPK(int[] pkCols, boolean withIdentity) throws HsqlException {
        int i;
        if (this.hasPrimaryKey() && pkCols != null || !this.hasPrimaryKey() && pkCols == null) {
            throw Trace.error(25);
        }
        Table tn = this.duplicate();
        for (i = 0; i < this.columnCount; ++i) {
            tn.addColumn(this.getColumn(i).duplicate(withIdentity));
        }
        tn.createPrimaryKey(this.getIndex(0).getName(), pkCols, true);
        tn.constraintList = this.constraintList;
        for (i = 1; i < this.getIndexCount(); ++i) {
            Index idx = this.getIndex(i);
            tn.createAdjustedIndex(idx, -1, 0);
        }
        tn.triggerLists = this.triggerLists;
        return tn;
    }

    void updateConstraintsTables(Session session, Table old, int colindex, int adjust) throws HsqlException {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            c.replaceTable(old, this, colindex, adjust);
            if (c.constType != 3) continue;
            this.recompileCheckConstraint(session, c);
        }
    }

    private void recompileCheckConstraints(Session session) throws HsqlException {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.constType != 3) continue;
            this.recompileCheckConstraint(session, c);
        }
    }

    private void recompileCheckConstraint(Session session, Constraint c) throws HsqlException {
        Expression condition;
        String ddl = c.core.check.getDDL();
        Tokenizer tokenizer = new Tokenizer(ddl);
        Parser parser = new Parser(session, this.database, tokenizer);
        c.core.check = condition = parser.parseExpression();
        condition.setLikeOptimised();
        Select s = Expression.getCheckSelect(session, this, condition);
        c.core.checkFilter = s.tFilter[0];
        c.core.checkFilter.setAsCheckFilter();
        c.core.mainTable = this;
    }

    void checkColumnInCheckConstraint(String colname) throws HsqlException {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.constType != 3 || !c.hasColumn(this, colname)) continue;
            throw Trace.error(197, c.getName());
        }
    }

    void checkColumnInFKConstraint(int colIndex) throws HsqlException {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (!c.hasColumn(colIndex) || c.getType() != 1 && c.getType() != 0) continue;
            throw Trace.error(197, c.getName().name);
        }
    }

    void checkColumnInFKConstraint(int colIndex, int actionType) throws HsqlException {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (!c.hasColumn(colIndex) || c.getType() != 0 || actionType != c.getUpdateAction() && actionType != c.getDeleteAction()) continue;
            throw Trace.error(197, c.getName().name);
        }
    }

    private void renameColumnInCheckConstraints(String oldname, String newname, boolean isquoted) throws HsqlException {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.constType != 3) continue;
            Expression.Collector coll = new Expression.Collector();
            coll.addAll(c.core.check, 2);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                if (e.getColumnName() != oldname) continue;
                e.setColumnName(newname, isquoted);
            }
        }
    }

    private void renameTableInCheckConstraints(Session session, String oldname, String newname) throws HsqlException {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.constType != 3) continue;
            Expression.Collector coll = new Expression.Collector();
            coll.addAll(c.core.check, 2);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Expression e = (Expression)it.next();
                if (e.getTableName() != oldname) continue;
                e.setTableName(newname);
            }
        }
        this.recompileCheckConstraints(session);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getIndexCount() {
        return this.indexList.length;
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String c) throws HsqlException {
        int i = this.findColumn(c);
        if (i == -1) {
            throw Trace.error(28, c);
        }
        return i;
    }

    int findColumn(String c) {
        int index = this.columnList.getIndex(c);
        return index;
    }

    public Index getPrimaryIndex() {
        return this.getIndex(0);
    }

    public int[] getPrimaryKey() {
        return this.primaryKeyCols;
    }

    public int[] getPrimaryKeyTypes() {
        return this.primaryKeyTypes;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyCols.length != 0;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    void setBestRowIdentifiers() {
        int[] briCols = null;
        int briColsCount = 0;
        boolean isStrict = false;
        int nNullCount = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.columnList.size()];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index = this.indexList[i];
            int[] cols = index.getColumns();
            int colsCount = index.getVisibleColumns();
            if (i == 0) {
                if (!this.hasPrimaryKey()) continue;
                isStrict = true;
            }
            if (this.bestIndexForColumn[cols[0]] == -1) {
                this.bestIndexForColumn[cols[0]] = i;
            }
            if (!index.isUnique()) {
                if (this.bestIndex != null) continue;
                this.bestIndex = index;
                continue;
            }
            int nnullc = 0;
            for (int j = 0; j < colsCount; ++j) {
                if (this.colNullable[cols[j]]) continue;
                ++nnullc;
            }
            if (this.bestIndex != null) {
                this.bestIndex = index;
            }
            if (nnullc == colsCount) {
                if (briCols != null && briColsCount == nNullCount && colsCount >= briColsCount) continue;
                briCols = cols;
                briColsCount = colsCount;
                nNullCount = colsCount;
                isStrict = true;
                continue;
            }
            if (isStrict || briCols != null && colsCount >= briColsCount && nnullc <= nNullCount) continue;
            briCols = cols;
            briColsCount = colsCount;
            nNullCount = nnullc;
        }
        this.bestRowIdentifierCols = briCols == null || briColsCount == briCols.length ? briCols : ArrayUtil.arraySlice(briCols, 0, briColsCount);
        this.bestRowIdentifierStrict = isStrict;
        if (this.hasPrimaryKey()) {
            this.bestIndex = this.getPrimaryIndex();
        }
    }

    void setDefaultExpression(int columnIndex, Expression def) {
        Column column = this.getColumn(columnIndex);
        column.setDefaultExpression(def);
        this.colDefaults[columnIndex] = column.getDefaultExpression();
        this.resetDefaultsFlag();
    }

    void resetDefaultsFlag() {
        this.hasDefaultValues = false;
        for (int i = 0; i < this.columnCount; ++i) {
            this.hasDefaultValues = this.hasDefaultValues || this.colDefaults[i] != null;
        }
    }

    DataFileCache getCache() {
        return this.cache;
    }

    Index getIndexForColumn(Session session, int column) {
        int i = this.bestIndexForColumn[column];
        if (i == -1 && (this.tableType == 1 || this.tableType == 0)) {
            try {
                HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX");
                this.createIndex(session, new int[]{column}, indexName, false, false, false);
                i = this.bestIndexForColumn[column];
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return i == -1 ? null : this.getIndex(i);
    }

    Index getIndexForColumns(boolean[] columnCheck) {
        Index indexChoice = null;
        int colCount = 0;
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index = this.indexList[i];
            boolean result = ArrayUtil.containsAllTrueElements(columnCheck, index.colCheck);
            if (!result || index.getVisibleColumns() <= colCount) continue;
            colCount = index.getVisibleColumns();
            indexChoice = index;
        }
        return indexChoice;
    }

    Index getIndexForColumns(int[] col, boolean unique) throws HsqlException {
        int count = this.getIndexCount();
        for (int i = 0; i < count; ++i) {
            Index currentindex = this.getIndex(i);
            int[] indexcol = currentindex.getColumns();
            if (!ArrayUtil.haveEqualArrays(indexcol, col, col.length) || unique && !currentindex.isUnique()) continue;
            return currentindex;
        }
        return null;
    }

    public int[] getIndexRootsArray() {
        int[] roots = new int[this.getIndexCount()];
        for (int i = 0; i < this.getIndexCount(); ++i) {
            roots[i] = this.indexList[i].getRoot();
        }
        return roots;
    }

    String getIndexRoots() {
        String roots = StringUtil.getList(this.getIndexRootsArray(), " ", "");
        StringBuffer s = new StringBuffer(roots);
        s.append(' ');
        s.append(this.identitySequence.peek());
        return s.toString();
    }

    public void setIndexRoots(int[] roots) throws HsqlException {
        Trace.check(this.isCached, 22);
        for (int i = 0; i < this.getIndexCount(); ++i) {
            int root = roots[i];
            CachedRow r = null;
            if (root != -1) {
                r = (CachedRow)this.rowStore.get(root);
            }
            Node f = null;
            if (r != null) {
                f = r.getNode(i);
            }
            this.indexList[i].setRoot(null, f);
        }
    }

    void setIndexRoots(String s) throws HsqlException {
        Trace.check(this.isCached, 22);
        Tokenizer t = new Tokenizer(s);
        int[] roots = new int[this.getIndexCount()];
        for (int i = 0; i < this.getIndexCount(); ++i) {
            int v;
            roots[i] = v = t.getInt();
        }
        this.setIndexRoots(roots);
        long v = t.getBigint();
        this.identitySequence.reset(v);
    }

    void createPrimaryKey(int[] cols) throws HsqlException {
        this.createPrimaryKey(null, cols, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName indexName, int[] columns, boolean columnsNotNull) throws HsqlException {
        int i;
        if (this.primaryKeyCols != null) {
            Trace.doAssert(false, "Table.createPrimaryKey(column)");
        }
        if (columns == null) {
            columns = new int[]{};
        } else {
            for (i = 0; i < columns.length; ++i) {
                if (columnsNotNull) {
                    this.getColumn(columns[i]).setNullable(false);
                }
                this.getColumn(columns[i]).setPrimaryKey(true);
            }
        }
        this.primaryKeyCols = columns;
        this.colTypes = new int[this.columnCount];
        this.colDefaults = new Expression[this.columnCount];
        this.colSizes = new int[this.columnCount];
        this.colScales = new int[this.columnCount];
        this.colNullable = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        for (i = 0; i < this.columnCount; ++i) {
            this.setColumnTypeVars(i);
        }
        this.primaryKeyTypes = new int[this.primaryKeyCols.length];
        ArrayUtil.copyColumnValues(this.colTypes, this.primaryKeyCols, this.primaryKeyTypes);
        this.primaryKeyColsSequence = new int[this.primaryKeyCols.length];
        ArrayUtil.fillSequence(this.primaryKeyColsSequence);
        this.resetDefaultsFlag();
        HsqlNameManager.HsqlName name = indexName != null ? indexName : this.database.nameManager.newAutoName("IDX");
        this.createPrimaryIndex(columns, name);
        this.setBestRowIdentifiers();
    }

    void setColumnTypeVars(int i) {
        Column column = this.getColumn(i);
        this.colTypes[i] = column.getType();
        this.colSizes[i] = column.getSize();
        this.colScales[i] = column.getScale();
        this.colNullable[i] = column.isNullable();
        this.defaultColumnMap[i] = i;
        if (column.isIdentity()) {
            this.identitySequence.reset(column.identityStart, column.identityIncrement);
        }
        this.colDefaults[i] = column.getDefaultExpression();
    }

    HsqlNameManager.HsqlName makeSysPKName() throws HsqlException {
        return this.database.nameManager.newAutoName("PK");
    }

    void createPrimaryIndex(int[] pkcols, HsqlNameManager.HsqlName name) throws HsqlException {
        int[] pkcoltypes = new int[pkcols.length];
        for (int j = 0; j < pkcols.length; ++j) {
            pkcoltypes[j] = this.colTypes[pkcols[j]];
        }
        Index newindex = new Index(this.database, name, this, pkcols, pkcoltypes, true, true, true, false, pkcols, pkcoltypes, this.isTemp);
        this.addIndex(newindex);
    }

    private Index createAdjustedIndex(Index index, int colindex, int adjust) throws HsqlException {
        int[] indexcolumns = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] colarr = ArrayUtil.toAdjustedColumnArray(indexcolumns, colindex, adjust);
        if (colarr.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(colarr, index.getName(), index.isUnique(), index.isConstraint, index.isForward);
    }

    Index createIndex(Session session, int[] column, HsqlNameManager.HsqlName name, boolean unique, boolean constraint, boolean forward) throws HsqlException {
        int newindexNo = this.createIndexStructureGetNo(column, name, unique, constraint, forward);
        Index newindex = this.indexList[newindexNo];
        Index primaryindex = this.getPrimaryIndex();
        RowIterator it = primaryindex.firstRow(session);
        int rowCount = 0;
        HsqlException error = null;
        try {
            while (it.hasNext()) {
                Row row = it.next();
                Node backnode = row.getNode(newindexNo - 1);
                Node newnode = Node.newNode(row, newindexNo, this);
                newnode.nNext = backnode.nNext;
                backnode.nNext = newnode;
                ++rowCount;
                newindex.insert(session, row, newindexNo);
            }
            return newindex;
        }
        catch (OutOfMemoryError e) {
            error = Trace.error(72);
        }
        catch (HsqlException e) {
            error = e;
        }
        it = primaryindex.firstRow(session);
        for (int i = 0; i < rowCount; ++i) {
            Row row = it.next();
            Node backnode = row.getNode(0);
            int j = newindexNo;
            while (--j > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, newindexNo, -1);
        this.setBestRowIdentifiers();
        throw error;
    }

    Index createIndexStructure(int[] columns, HsqlNameManager.HsqlName name, boolean unique, boolean constraint, boolean forward) throws HsqlException {
        int i = this.createIndexStructureGetNo(columns, name, unique, constraint, forward);
        return this.indexList[i];
    }

    int createIndexStructureGetNo(int[] column, HsqlNameManager.HsqlName name, boolean unique, boolean constraint, boolean forward) throws HsqlException {
        if (this.primaryKeyCols == null) {
            Trace.doAssert(false, "createIndex");
        }
        int s = column.length;
        int[] col = new int[s];
        int[] type = new int[s];
        for (int j = 0; j < s; ++j) {
            col[j] = column[j];
            type[j] = this.colTypes[col[j]];
        }
        int[] pkcols = this.getPrimaryKey();
        int[] pktypes = this.getPrimaryKeyTypes();
        Index newindex = new Index(this.database, name, this, col, type, false, unique, constraint, forward, pkcols, pktypes, this.isTemp);
        int indexNo = this.addIndex(newindex);
        this.setBestRowIdentifiers();
        return indexNo;
    }

    private int addIndex(Index index) {
        int i;
        for (i = 0; i < this.indexList.length; ++i) {
            Index current = this.indexList[i];
            int order = index.getIndexOrderValue() - current.getIndexOrderValue();
            if (order < 0) break;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, i, 1);
        return i;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String indexname, HashSet ignore, boolean dropPK) throws HsqlException {
        Index index = this.getIndex(indexname);
        if (index == null) {
            throw Trace.error(26, indexname);
        }
        if (!dropPK && index.equals(this.getIndex(0))) {
            throw Trace.error(25, indexname);
        }
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (ignore != null && ignore.contains(c)) continue;
            if (c.isIndexFK(index)) {
                throw Trace.error(50, indexname);
            }
            if (!c.isIndexUnique(index)) continue;
            throw Trace.error(56, indexname);
        }
    }

    public boolean isEmpty(Session session) {
        if (this.getIndexCount() == 0) {
            return true;
        }
        return this.getIndex(0).isEmpty(session);
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.columnCount];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.columnCount];
    }

    public Object[] getEmptyRowData() {
        return new Object[this.columnCount];
    }

    Object[] getNewRowData(Session session, boolean[] exists) throws HsqlException {
        Object[] data = new Object[this.columnCount];
        if (exists != null && this.hasDefaultValues) {
            for (int i = 0; i < this.columnCount; ++i) {
                Expression def = this.colDefaults[i];
                if (exists[i] || def == null) continue;
                data[i] = def.getValue(session, this.colTypes[i]);
            }
        }
        return data;
    }

    void dropIndex(Session session, String indexname) throws HsqlException {
        int todrop = this.getIndexIndex(indexname);
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, todrop, -1);
        this.setBestRowIdentifiers();
        this.dropIndexFromRows(session, todrop);
    }

    void dropIndexFromRows(Session session, int index) throws HsqlException {
        RowIterator it = this.getPrimaryIndex().firstRow(session);
        while (it.hasNext()) {
            Row row = it.next();
            int i = index - 1;
            Node backnode = row.getNode(0);
            while (i-- > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
    }

    void moveData(Session session, Table from, int colindex, int adjust) throws HsqlException {
        Object colvalue = null;
        Column column = null;
        if (adjust >= 0 && colindex != -1) {
            column = this.getColumn(colindex);
            colvalue = column.getDefaultValue(session);
        }
        RowIterator it = from.getPrimaryIndex().firstRow(session);
        while (it.hasNext()) {
            Row row = it.next();
            Object[] o = row.getData();
            Object[] data = this.getEmptyRowData();
            if (adjust == 0 && colindex != -1) {
                colvalue = Column.convertObject(session, o[colindex], column.getType(), column.getSize(), column.getScale());
            }
            ArrayUtil.copyAdjustArray(o, data, colvalue, colindex, adjust);
            this.setIdentityColumn(session, data);
            this.enforceNullConstraints(data);
            Row newrow = this.newRow(data);
            this.indexRow(session, newrow);
        }
        from.drop();
    }

    int insert(Session session, Result ins) throws HsqlException {
        Record ni = ins.rRoot;
        int count = 0;
        this.fireAll(session, 3);
        while (ni != null) {
            this.insertRow(session, ni.data);
            ni = ni.next;
            ++count;
        }
        this.fireAll(session, 0);
        return count;
    }

    void insert(Session session, Object[] data) throws HsqlException {
        this.fireAll(session, 3);
        this.insertRow(session, data);
        this.fireAll(session, 0);
    }

    private void insertRow(Session session, Object[] data) throws HsqlException {
        if (this.triggerLists[9] != null) {
            this.fireAll(session, 9, null, data);
        }
        this.setIdentityColumn(session, data);
        this.checkRowDataInsert(session, data);
        this.insertNoCheck(session, data);
        if (this.triggerLists[6] != null) {
            this.fireAll(session, 6, null, data);
            this.checkRowDataInsert(session, data);
        }
    }

    void insertIntoTable(Session session, Result result) throws HsqlException {
        this.insertResult(session, result);
        if (!this.isLogged) {
            return;
        }
        Record r = result.rRoot;
        while (r != null) {
            this.database.logger.writeInsertStatement(session, this, r.data);
            r = r.next;
        }
    }

    private void insertNoCheck(Session session, Object[] data) throws HsqlException {
        Row row = this.newRow(data);
        this.indexRow(session, row);
        if (session != null) {
            session.addInsertAction(this, row);
        }
        if (this.isLogged) {
            this.database.logger.writeInsertStatement(session, this, data);
        }
    }

    public void insertNoCheckFromLog(Session session, Object[] data) throws HsqlException {
        Row r = this.newRow(data);
        this.updateIdentityValue(data);
        this.indexRow(session, r);
        if (session != null) {
            session.addInsertAction(this, r);
        }
    }

    void insertNoCheckRollback(Session session, Row row, boolean log) throws HsqlException {
        Row newrow = this.restoreRow(row);
        this.indexRow(session, newrow);
        if (log && this.isLogged) {
            this.database.logger.writeInsertStatement(session, this, row.getData());
        }
    }

    int insertSys(Result ins) throws HsqlException {
        Record ni = ins.rRoot;
        int count = 0;
        while (ni != null) {
            this.insertData(null, ni.data);
            ni = ni.next;
            ++count;
        }
        return count;
    }

    int insertResult(Session session, Result ins) throws HsqlException {
        Record ni = ins.rRoot;
        int count = 0;
        while (ni != null) {
            Object[] newData = (Object[])ArrayUtil.resizeArrayIfDifferent(ni.data, this.columnCount);
            this.insertData(session, newData);
            ni = ni.next;
            ++count;
        }
        return count;
    }

    public void insertFromScript(Object[] data) throws HsqlException {
        this.updateIdentityValue(data);
        this.insertData(null, data);
    }

    public void insertData(Session session, Object[] data) throws HsqlException {
        Row row = this.newRow(data);
        this.indexRow(session, row);
        this.commitRowToStore(row);
    }

    public void insertSys(Object[] data) throws HsqlException {
        Row row = this.newRow(data);
        this.indexRow(null, row);
    }

    protected void insertFromTextSource(CachedRow row) throws HsqlException {
        Object[] data = row.getData();
        this.updateIdentityValue(data);
        this.enforceFieldValueLimits(data, this.defaultColumnMap);
        this.enforceNullConstraints(data);
        this.indexRow(null, row);
    }

    protected void enforceNullConstraints(Object[] data) throws HsqlException {
        for (int i = 0; i < this.columnCount; ++i) {
            if (data[i] != null || this.colNullable[i]) continue;
            Trace.throwerror(10, "column: " + this.getColumn((int)i).columnName.name + " table: " + this.tableName.name);
        }
    }

    protected void setIdentityColumn(Session session, Object[] data) throws HsqlException {
        if (this.identityColumn != -1) {
            Number id = (Number)data[this.identityColumn];
            if (id == null) {
                id = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                data[this.identityColumn] = id;
            } else {
                this.identitySequence.getValue(id.longValue());
            }
            if (session != null) {
                session.setLastIdentity(id);
            }
        }
    }

    protected void updateIdentityValue(Object[] data) throws HsqlException {
        Number id;
        if (this.identityColumn != -1 && (id = (Number)data[this.identityColumn]) != null) {
            this.identitySequence.getValue(id.longValue());
        }
    }

    void enforceFieldValueLimits(Object[] data, int[] cols) throws HsqlException {
        if (this.sqlEnforceSize) {
            if (cols == null) {
                cols = this.defaultColumnMap;
            }
            for (int i = 0; i < cols.length; ++i) {
                int colindex = cols[i];
                if (this.colTypes[colindex] != 93 && this.colSizes[colindex] == 0 || data[colindex] == null) continue;
                data[colindex] = Column.enforceSize(data[colindex], this.colTypes[colindex], this.colSizes[colindex], this.colScales[colindex], true);
            }
        }
    }

    void fireAll(Session session, int trigVecIndx, Object[] oldrow, Object[] newrow) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList trigVec = this.triggerLists[trigVecIndx];
        if (trigVec == null) {
            return;
        }
        int size = trigVec.size();
        for (int i = 0; i < size; ++i) {
            TriggerDef td = (TriggerDef)trigVec.get(i);
            td.pushPair(session, oldrow, newrow);
        }
    }

    void fireAll(Session session, int trigVecIndex) {
        if (this.triggerLists[trigVecIndex] != null) {
            this.fireAll(session, trigVecIndex, null, null);
        }
    }

    void addTrigger(TriggerDef trigDef) {
        if (this.triggerLists[trigDef.vectorIndex] == null) {
            this.triggerLists[trigDef.vectorIndex] = new HsqlArrayList();
        }
        this.triggerLists[trigDef.vectorIndex].add(trigDef);
    }

    void dropTrigger(String name) {
        int numTrigs = 12;
        for (int tv = 0; tv < numTrigs; ++tv) {
            HsqlArrayList v = this.triggerLists[tv];
            if (v == null) continue;
            for (int tr = v.size() - 1; tr >= 0; --tr) {
                TriggerDef td = (TriggerDef)v.get(tr);
                if (!td.name.name.equals(name)) continue;
                v.remove(tr);
                td.terminate();
            }
            if (!v.isEmpty()) continue;
            this.triggerLists[tv] = null;
        }
    }

    void dropTriggers() {
        int numTrigs = 12;
        for (int tv = 0; tv < numTrigs; ++tv) {
            HsqlArrayList v = this.triggerLists[tv];
            if (v == null) continue;
            for (int tr = v.size() - 1; tr >= 0; --tr) {
                TriggerDef td = (TriggerDef)v.get(tr);
                td.terminate();
            }
            this.triggerLists[tv] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCascadeDelete(Session session, Table table, HashMappedList tableUpdateLists, Row row, boolean delete, HashSet path) throws HsqlException {
        int size = table.constraintList.length;
        block5: for (int i = 0; i < size; ++i) {
            RowIterator refiterator;
            Constraint c = table.constraintList[i];
            if (c.getType() != 1 || c.getRef() == null || !(refiterator = c.findFkRef(session, row.getData(), delete)).hasNext()) continue;
            try {
                Row refrow;
                boolean hasref;
                if (c.core.deleteAction == 3) {
                    Row refrow2;
                    if (c.core.mainTable == c.core.refTable && row.equals(refrow2 = refiterator.next())) continue;
                    throw Trace.error(8, 100, new Object[]{c.core.fkName.name, c.core.refTable.getName().name});
                }
                Table reftable = c.getRef();
                boolean bl = hasref = reftable.getNextConstraintIndex(0, 1) != -1;
                if (!delete && !hasref) continue;
                Index refindex = c.getRefIndex();
                int[] m_columns = c.getMainColumns();
                int[] r_columns = c.getRefColumns();
                Object[] mdata = row.getData();
                boolean isUpdate = c.getDeleteAction() == 2 || c.getDeleteAction() == 4;
                HashMappedList rowSet = null;
                if (isUpdate && (rowSet = (HashMappedList)tableUpdateLists.get(reftable)) == null) {
                    rowSet = new HashMappedList();
                    tableUpdateLists.add(reftable, rowSet);
                }
                while ((refrow = refiterator.next()) != null && !refrow.isCascadeDeleted()) {
                    if (refindex.compareRowNonUnique(session, mdata, m_columns, refrow.getData()) != 0) {
                        continue block5;
                    }
                    if (isUpdate) {
                        int j;
                        Object[] rnd = reftable.getEmptyRowData();
                        System.arraycopy(refrow.getData(), 0, rnd, 0, rnd.length);
                        if (c.getDeleteAction() == 2) {
                            for (j = 0; j < r_columns.length; ++j) {
                                rnd[r_columns[j]] = null;
                            }
                        } else {
                            for (j = 0; j < r_columns.length; ++j) {
                                Column col = reftable.getColumn(r_columns[j]);
                                rnd[r_columns[j]] = col.getDefaultValue(session);
                            }
                        }
                        if (hasref && path.add(c)) {
                            Table.checkCascadeUpdate(session, reftable, null, refrow, rnd, r_columns, null, path);
                            path.remove(c);
                        }
                        if (delete && (reftable != table || !refrow.equals(row))) {
                            Table.mergeUpdate(rowSet, refrow, rnd, r_columns);
                        }
                    } else if (hasref) {
                        if (reftable != table) {
                            if (path.add(c)) {
                                Table.checkCascadeDelete(session, reftable, tableUpdateLists, refrow, delete, path);
                                path.remove(c);
                            }
                        } else if (refrow != row) {
                            Table.checkCascadeDelete(session, reftable, tableUpdateLists, refrow, delete, path);
                        }
                    }
                    if (!delete || isUpdate || refrow.isCascadeDeleted()) continue;
                    reftable.deleteNoRefCheck(session, refrow);
                }
                continue;
            }
            finally {
                refiterator.release();
            }
        }
    }

    static void checkCascadeUpdate(Session session, Table table, HashMappedList tableUpdateLists, Row orow, Object[] nrow, int[] cols, Table ref, HashSet path) throws HsqlException {
        int size = table.constraintList.length;
        for (int i = 0; i < size; ++i) {
            RowIterator refiterator;
            int[] common;
            Constraint c = table.constraintList[i];
            if (c.getType() == 0 && c.getRef() != null) {
                if (ref != null && c.getMain() == ref || ArrayUtil.countCommonElements(cols, c.getRefColumns()) == 0) continue;
                c.hasMainRef(session, nrow);
                continue;
            }
            if (c.getType() != 1 || c.getRef() == null || (common = ArrayUtil.commonElements(cols, c.getMainColumns())) == null) continue;
            int[] m_columns = c.getMainColumns();
            int[] r_columns = c.getRefColumns();
            boolean nochange = true;
            for (int j = 0; j < m_columns.length; ++j) {
                if (orow.getData()[m_columns[j]].equals(nrow[m_columns[j]])) continue;
                nochange = false;
                break;
            }
            if (nochange || !(refiterator = c.findFkRef(session, orow.getData(), false)).hasNext()) continue;
            if (c.core.updateAction == 3) {
                throw Trace.error(8, 100, new Object[]{c.core.fkName.name, c.core.refTable.getName().name});
            }
            Table reftable = c.getRef();
            boolean hasref = reftable.getNextConstraintIndex(0, 1) != -1;
            Index refindex = c.getRefIndex();
            HashMappedList rowSet = (HashMappedList)tableUpdateLists.get(reftable);
            if (rowSet == null) {
                rowSet = new HashMappedList();
                tableUpdateLists.add(reftable, rowSet);
            }
            Row refrow = refiterator.next();
            while (refrow != null && refindex.compareRowNonUnique(session, orow.getData(), m_columns, refrow.getData()) == 0) {
                int j;
                Object[] rnd = reftable.getEmptyRowData();
                System.arraycopy(refrow.getData(), 0, rnd, 0, rnd.length);
                if (c.getUpdateAction() == 2) {
                    for (j = 0; j < r_columns.length; ++j) {
                        rnd[r_columns[j]] = null;
                    }
                } else if (c.getUpdateAction() == 4) {
                    for (j = 0; j < r_columns.length; ++j) {
                        Column col = reftable.getColumn(r_columns[j]);
                        rnd[r_columns[j]] = col.getDefaultValue(session);
                    }
                    if (path.add(c)) {
                        Table.checkCascadeUpdate(session, reftable, tableUpdateLists, refrow, rnd, r_columns, null, path);
                        path.remove(c);
                    }
                } else {
                    for (j = 0; j < m_columns.length; ++j) {
                        rnd[r_columns[j]] = nrow[m_columns[j]];
                    }
                    if (path.add(c)) {
                        Table.checkCascadeUpdate(session, reftable, tableUpdateLists, refrow, rnd, common, table, path);
                        path.remove(c);
                    }
                }
                Table.mergeUpdate(rowSet, refrow, rnd, r_columns);
                refrow = refiterator.next();
            }
        }
    }

    static void mergeUpdate(HashMappedList rowSet, Row row, Object[] newData, int[] cols) {
        Object[] data = (Object[])rowSet.get(row);
        if (data != null) {
            for (int j = 0; j < cols.length; ++j) {
                data[cols[j]] = newData[cols[j]];
            }
        } else {
            rowSet.add(row, newData);
        }
    }

    static boolean mergeKeepUpdate(Session session, HashMappedList rowSet, int[] cols, int[] colTypes, Row row, Object[] newData) throws HsqlException {
        Object[] data = (Object[])rowSet.get(row);
        if (data != null) {
            if (Index.compareRows(session, row.getData(), newData, cols, colTypes) != 0 && Index.compareRows(session, newData, data, cols, colTypes) != 0) {
                return false;
            }
            for (int j = 0; j < cols.length; ++j) {
                newData[cols[j]] = data[cols[j]];
            }
            rowSet.put(row, newData);
        } else {
            rowSet.add(row, newData);
        }
        return true;
    }

    static void clearUpdateLists(HashMappedList tableUpdateList) {
        for (int i = 0; i < tableUpdateList.size(); ++i) {
            HashMappedList updateList = (HashMappedList)tableUpdateList.get(i);
            updateList.clear();
        }
    }

    int delete(Session session, HsqlArrayList deleteList) throws HsqlException {
        HashMappedList updateList;
        Table table;
        Row row;
        int i;
        HashSet path = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList tUpdateList = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        if (this.database.isReferentialIntegrity()) {
            for (i = 0; i < deleteList.size(); ++i) {
                row = (Row)deleteList.get(i);
                path.clear();
                Table.checkCascadeDelete(session, this, tUpdateList, row, false, path);
            }
        }
        this.database.txManager.checkDelete(session, deleteList);
        for (i = 0; i < tUpdateList.size(); ++i) {
            table = (Table)tUpdateList.getKey(i);
            updateList = (HashMappedList)tUpdateList.get(i);
            this.database.txManager.checkDelete(session, updateList);
        }
        this.fireAll(session, 4);
        if (this.database.isReferentialIntegrity()) {
            for (i = 0; i < deleteList.size(); ++i) {
                row = (Row)deleteList.get(i);
                path.clear();
                Table.checkCascadeDelete(session, this, tUpdateList, row, true, path);
            }
        }
        for (i = 0; i < deleteList.size(); ++i) {
            row = (Row)deleteList.get(i);
            if (row.isCascadeDeleted()) continue;
            this.deleteNoRefCheck(session, row);
        }
        for (i = 0; i < tUpdateList.size(); ++i) {
            table = (Table)tUpdateList.getKey(i);
            updateList = (HashMappedList)tUpdateList.get(i);
            table.updateRowSet(session, updateList, null, false);
            updateList.clear();
        }
        this.fireAll(session, 1);
        path.clear();
        this.constraintPath = path;
        this.tableUpdateList = tUpdateList;
        return deleteList.size();
    }

    private void deleteNoRefCheck(Session session, Row row) throws HsqlException {
        Object[] data = row.getData();
        this.fireAll(session, 10, data, null);
        this.deleteNoCheck(session, row, true);
        this.fireAll(session, 7, data, null);
    }

    private void deleteNoCheck(Session session, Row row, boolean log) throws HsqlException {
        if (row.isCascadeDeleted()) {
            return;
        }
        Object[] data = row.getData();
        row = row.getUpdatedRow();
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            Node node = row.getNode(i);
            this.indexList[i].delete(session, node);
        }
        row.delete();
        if (session != null) {
            session.addDeleteAction(this, row);
        }
        if (log && this.isLogged) {
            this.database.logger.writeDeleteStatement(session, this, data);
        }
    }

    public void deleteNoCheckFromLog(Session session, Object[] data) throws HsqlException {
        RowIterator it;
        Row row = null;
        if (this.hasPrimaryKey()) {
            it = this.getPrimaryIndex().findFirstRow(session, data, this.primaryKeyColsSequence);
            row = it.next();
        } else if (this.bestIndex == null) {
            it = this.getPrimaryIndex().firstRow(session);
            while ((row = it.next()) != null && Index.compareRows(session, row.getData(), data, this.defaultColumnMap, this.colTypes) != 0) {
            }
        } else {
            it = this.bestIndex.findFirstRow(session, data, this.bestIndex.getVisibleColumns());
            while ((row = it.next()) != null) {
                Object[] rowdata = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, data, this.bestIndex.getColumns(), rowdata) != 0) {
                    row = null;
                    break;
                }
                if (Index.compareRows(session, rowdata, data, this.defaultColumnMap, this.colTypes) != 0) continue;
                break;
            }
        }
        if (row == null) {
            return;
        }
        this.database.txManager.checkDelete(session, row);
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            Node node = row.getNode(i);
            this.indexList[i].delete(session, node);
        }
        row.delete();
        if (session != null) {
            session.addDeleteAction(this, row);
        }
    }

    void deleteNoCheckRollback(Session session, Row row, boolean log) throws HsqlException {
        row = this.indexList[0].findRow(session, row);
        for (int i = this.indexList.length - 1; i >= 0; --i) {
            Node node = row.getNode(i);
            this.indexList[i].delete(session, node);
        }
        row.delete();
        this.removeRowFromStore(row);
        if (log && this.isLogged) {
            this.database.logger.writeDeleteStatement(session, this, row.getData());
        }
    }

    int update(Session session, HashMappedList updateList, int[] cols) throws HsqlException {
        HashMappedList updateListT;
        Table table;
        int i;
        Row row;
        Object[] data;
        int i2;
        HashSet path = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList tUpdateList = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        for (i2 = 0; i2 < updateList.size(); ++i2) {
            data = (Object[])updateList.get(i2);
            this.setIdentityColumn(session, data);
            this.enforceFieldValueLimits(data, cols);
            this.enforceNullConstraints(data);
        }
        if (this.database.isReferentialIntegrity()) {
            for (i2 = 0; i2 < updateList.size(); ++i2) {
                data = (Object[])updateList.get(i2);
                row = (Row)updateList.getKey(i2);
                Table.checkCascadeUpdate(session, this, tUpdateList, row, data, cols, null, path);
            }
        }
        this.fireAll(session, 5);
        HashMappedList triggeredList = (HashMappedList)tUpdateList.get(this);
        if (triggeredList != null) {
            for (int i3 = 0; i3 < triggeredList.size(); ++i3) {
                row = (Row)triggeredList.getKey(i3);
                Object[] data2 = (Object[])triggeredList.get(i3);
                Table.mergeKeepUpdate(session, updateList, cols, this.colTypes, row, data2);
            }
            triggeredList.clear();
        }
        for (i = 0; i < tUpdateList.size(); ++i) {
            table = (Table)tUpdateList.getKey(i);
            updateListT = (HashMappedList)tUpdateList.get(i);
            this.database.txManager.checkDelete(session, updateListT);
        }
        this.database.txManager.checkDelete(session, updateList);
        for (i = 0; i < tUpdateList.size(); ++i) {
            table = (Table)tUpdateList.getKey(i);
            updateListT = (HashMappedList)tUpdateList.get(i);
            table.updateRowSet(session, updateListT, null, false);
            updateListT.clear();
        }
        this.updateRowSet(session, updateList, cols, true);
        this.fireAll(session, 2);
        path.clear();
        this.constraintPath = path;
        this.tableUpdateList = tUpdateList;
        Table.clearUpdateLists(this.tableUpdateList);
        return updateList.size();
    }

    void updateRowSet(Session session, HashMappedList rowSet, int[] cols, boolean nodelete) throws HsqlException {
        Object[] data;
        Row row;
        int i;
        for (i = rowSet.size() - 1; i >= 0; --i) {
            row = (Row)rowSet.getKey(i);
            data = (Object[])rowSet.get(i);
            if (row.isCascadeDeleted()) {
                if (nodelete) {
                    throw Trace.error(199);
                }
                rowSet.remove(i);
                continue;
            }
            for (int j = 0; j < this.constraintList.length; ++j) {
                Constraint c = this.constraintList[j];
                if (c.getType() != 3) continue;
                c.checkCheckConstraint(session, data);
            }
            this.deleteNoCheck(session, row, true);
        }
        for (i = 0; i < rowSet.size(); ++i) {
            row = (Row)rowSet.getKey(i);
            data = (Object[])rowSet.get(i);
            if (this.triggerLists[11] != null) {
                this.fireAll(session, 11, row.getData(), data);
                this.checkRowDataUpdate(session, data, cols);
            }
            this.insertNoCheck(session, data);
            if (this.triggerLists[8] == null) continue;
            this.fireAll(session, 8, row.getData(), data);
            this.checkRowDataUpdate(session, data, cols);
        }
    }

    void checkRowDataInsert(Session session, Object[] data) throws HsqlException {
        this.enforceFieldValueLimits(data, null);
        this.enforceNullConstraints(data);
        if (this.database.isReferentialIntegrity()) {
            int size = this.constraintList.length;
            for (int i = 0; i < size; ++i) {
                this.constraintList[i].checkInsert(session, data);
            }
        }
    }

    void checkRowDataUpdate(Session session, Object[] data, int[] cols) throws HsqlException {
        this.enforceFieldValueLimits(data, cols);
        this.enforceNullConstraints(data);
        for (int j = 0; j < this.constraintList.length; ++j) {
            Constraint c = this.constraintList[j];
            if (c.getType() != 3) continue;
            c.checkCheckConstraint(session, data);
        }
    }

    public boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    int getIndexIndex(String indexName) {
        Index[] indexes = this.indexList;
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexName.equals(indexes[i].getName().name)) continue;
            return i;
        }
        return -1;
    }

    Index getIndex(String indexName) {
        Index[] indexes = this.indexList;
        int i = this.getIndexIndex(indexName);
        return i == -1 ? null : indexes[i];
    }

    int getConstraintIndex(String constraintName) {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            if (!this.constraintList[i].getName().name.equals(constraintName)) continue;
            return i;
        }
        return -1;
    }

    Constraint getConstraint(String constraintName) {
        int i = this.getConstraintIndex(constraintName);
        return i < 0 ? null : this.constraintList[i];
    }

    void removeConstraint(String name) {
        int index = this.getConstraintIndex(name);
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, index, -1);
    }

    Column getColumn(int i) {
        return (Column)this.columnList.get(i);
    }

    void renameColumn(Column column, String newName, boolean isquoted) throws HsqlException {
        String oldname = column.columnName.name;
        int i = this.getColumnNr(oldname);
        this.columnList.setKey(i, newName);
        column.columnName.rename(newName, isquoted);
        this.renameColumnInCheckConstraints(oldname, newName, isquoted);
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    public Index getIndex(int i) {
        return this.indexList[i];
    }

    public Index[] getIndexes() {
        return this.indexList;
    }

    CachedRow getRow(int pos, Node primarynode) throws HsqlException {
        if (this.isText) {
            CachedDataRow row = (CachedDataRow)this.rowStore.get(pos);
            row.nPrimaryNode = primarynode;
            return row;
        }
        if (this.isCached) {
            return (CachedRow)this.rowStore.get(pos);
        }
        return null;
    }

    CachedRow getRow(int pos) {
        return (CachedRow)this.rowStore.get(pos);
    }

    CachedRow getRow(long id) {
        return (CachedRow)this.rowStore.get((int)id);
    }

    void removeRowFromStore(Row row) throws HsqlException {
        if (this.isCached || this.isText && this.cache != null) {
            this.rowStore.remove(row.getPos());
        }
    }

    void releaseRowFromStore(Row row) throws HsqlException {
        if (this.isCached || this.isText && this.cache != null) {
            this.rowStore.release(row.getPos());
        }
    }

    void commitRowToStore(Row row) {
        if (this.isText && this.cache != null) {
            this.rowStore.commit(row);
        }
    }

    void indexRow(Session session, Row row) throws HsqlException {
        int i;
        try {
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i].insert(session, row, i);
            }
        }
        catch (HsqlException e) {
            --i;
            while (i >= 0) {
                Node n = row.getNode(i);
                this.indexList[i].delete(session, n);
                --i;
            }
            row.delete();
            this.removeRowFromStore(row);
            throw e;
        }
    }

    void clearAllRows(Session session) {
        for (int i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].clearAll(session);
        }
        if (!this.isTemp) {
            this.identitySequence.reset();
            this.rowIdSequence.reset();
        }
    }

    void drop() throws HsqlException {
    }

    boolean isWritable() {
        return !this.isDataReadOnly() && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs") ? this.database.getURI() : null;
    }

    public String getSchemaName() {
        return this.tableName.schema.name;
    }

    public int getRowCount(Session session) throws HsqlException {
        return this.getPrimaryIndex().size(session);
    }

    public void resetRowId(Session session) throws HsqlException {
        if (this.isCached) {
            return;
        }
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        RowIterator it = this.getPrimaryIndex().firstRow(session);
        while (it.hasNext()) {
            Row row = it.next();
            int pos = (int)this.rowIdSequence.getValue();
            row.setPos(pos);
        }
    }

    Row newRow(Object[] o) throws HsqlException {
        Row row;
        try {
            if (this.isMemory) {
                row = new Row(this, o);
                int pos = (int)this.rowIdSequence.getValue();
                row.setPos(pos);
            } else {
                row = CachedRow.newCachedRow(this, o);
                this.rowStore.add(row);
            }
        }
        catch (IOException e) {
            throw new HsqlException(e, Trace.getMessage(98), 98);
        }
        return row;
    }

    Row restoreRow(Row oldrow) throws HsqlException {
        Row row;
        try {
            if (this.isMemory) {
                row = new Row(this, oldrow.oData);
                row.setPos(oldrow.getPos());
            } else {
                row = CachedRow.newCachedRow(this, oldrow.oData);
                row.setStorageSize(oldrow.getStorageSize());
                row.setPos(oldrow.getPos());
                this.rowStore.restore(row);
            }
        }
        catch (IOException e) {
            throw new HsqlException(e, Trace.getMessage(98), 98);
        }
        return row;
    }

    public class RowStore
    implements PersistentStore {
        public CachedObject get(int i) {
            try {
                return Table.this.cache.get(i, this, false);
            }
            catch (HsqlException e) {
                return null;
            }
        }

        public CachedObject getKeep(int i) {
            try {
                return Table.this.cache.get(i, this, true);
            }
            catch (HsqlException e) {
                return null;
            }
        }

        public int getStorageSize(int i) {
            try {
                return Table.this.cache.get(i, this, false).getStorageSize();
            }
            catch (HsqlException e) {
                return 0;
            }
        }

        public void add(CachedObject row) throws IOException {
            Table.this.cache.add(row);
        }

        public void restore(CachedObject row) throws IOException {
            Table.this.cache.restore(row);
        }

        public CachedObject get(RowInputInterface in) {
            try {
                if (Table.this.isText) {
                    return new CachedDataRow(Table.this, in);
                }
                CachedRow row = new CachedRow(Table.this, in);
                return row;
            }
            catch (HsqlException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        public CachedObject getNewInstance(int size) {
            return null;
        }

        public void remove(int i) {
            try {
                Table.this.cache.remove(i, this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void removePersistence(int i) {
            try {
                Table.this.cache.removePersistence(i, this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void release(int i) {
            Table.this.cache.release(i);
        }

        public void commit(CachedObject row) {
            try {
                if (Table.this.isText) {
                    Table.this.cache.saveRow(row);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

