/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.hsqldb;

import com.fr.third.org.hsqldb.HsqlException;
import com.fr.third.org.hsqldb.Node;
import com.fr.third.org.hsqldb.Table;
import com.fr.third.org.hsqldb.lib.IntLookup;
import com.fr.third.org.hsqldb.lib.java.JavaSystem;
import com.fr.third.org.hsqldb.persist.CachedObject;
import com.fr.third.org.hsqldb.rowio.RowOutputInterface;

public class Row
implements CachedObject {
    int tableId;
    int iPos;
    protected Object[] oData;
    protected Node nPrimaryNode;

    protected Row() {
    }

    Row(Table t, Object[] o) throws HsqlException {
        int index = t.getIndexCount();
        Node n = this.nPrimaryNode = Node.newNode(this, 0, t);
        for (int i = 1; i < index; ++i) {
            n = n.nNext = Node.newNode(this, i, t);
        }
        this.tableId = t.getId();
        this.oData = o;
    }

    Node getNode(int index) {
        Node n = this.nPrimaryNode;
        while (index-- > 0) {
            n = n.nNext;
        }
        return n;
    }

    Node getNextNode(Node n) {
        n = n == null ? this.nPrimaryNode : n.nNext;
        return n;
    }

    Row getUpdatedRow() throws HsqlException {
        return this;
    }

    public Object[] getData() {
        return this.oData;
    }

    void delete() throws HsqlException {
        ++JavaSystem.memoryRecords;
        this.nPrimaryNode = null;
    }

    void clearNodeLinks() {
        Node last = this.nPrimaryNode;
        while (last.nNext != null) {
            Node temp = last.nNext;
            last.nNext = null;
            last = temp;
        }
        this.nPrimaryNode = null;
    }

    boolean isCascadeDeleted() {
        return this.nPrimaryNode == null;
    }

    public int getRealSize(RowOutputInterface out) {
        return 0;
    }

    public void setStorageSize(int size) {
    }

    public int getStorageSize() {
        return 0;
    }

    public long getId() {
        return ((long)this.tableId << 32) + (long)this.iPos;
    }

    public static long getId(Table table, int pos) {
        return ((long)table.getId() << 32) + (long)pos;
    }

    public int getPos() {
        return this.iPos;
    }

    public void setPos(int pos) {
        this.iPos = pos;
    }

    public boolean hasChanged() {
        return false;
    }

    public boolean isKeepInMemory() {
        return true;
    }

    public void keepInMemory(boolean keep) {
    }

    public boolean isInMemory() {
        return true;
    }

    public void setInMemory(boolean in) {
    }

    public void write(RowOutputInterface out) {
    }

    public void write(RowOutputInterface out, IntLookup lookup) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Row) {
            return ((Row)obj).iPos == this.iPos;
        }
        return false;
    }

    public int hashCode() {
        return this.iPos;
    }
}

