/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.util;

import com.fr.third.org.apache.poi.hssf.record.FilePassRecord;
import com.fr.third.org.apache.poi.util.LittleEndian;

public class PWDUtils {
    static byte[] seeds = new byte[]{-69, -1, -1, -70, -1, -1, -71, -128, 0, -66, 15, 0, -65, 15, 0};

    public static short getPasswordHash(byte[] abyte0) {
        short word0 = 0;
        for (int i = 0; i < abyte0.length; ++i) {
            int j = abyte0[i] << i + 1;
            word0 = (short)(word0 ^ (short)(j & Short.MAX_VALUE | j >> 15));
        }
        word0 = (short)(word0 ^ (short)abyte0.length);
        word0 = (short)(word0 ^ 0xCE4B);
        return word0;
    }

    public static short getEncryptionKey(byte[] abyte0) {
        int i = 0;
        int j = 32768;
        int k = 65535;
        for (int l = 0; l < abyte0.length; ++l) {
            byte byte0 = (byte)(abyte0[abyte0.length - 1 - l] & 0x7F);
            for (int i1 = 0; i1 < 8; ++i1) {
                if (((j = j << 1 & 0xFFFF | j >> 15) & 1) == 1) {
                    j = (j ^ 0x1020) & 0xFFFF;
                }
                if (((k = k << 1 & 0xFFFF | k >> 15) & 1) == 1) {
                    k = (k ^ 0x1020) & 0xFFFF;
                }
                if ((byte0 & 1) == 1) {
                    i = (i ^ j) & 0xFFFF;
                }
                byte0 = (byte)(byte0 >> 1);
            }
        }
        i = (i ^ k) & 0xFFFF;
        return (short)(i & 0xFFFF);
    }

    public static byte[] getKeySequence(byte[] abyte0, short word0) {
        byte[] abyte1 = new byte[16];
        int i = abyte0.length;
        System.arraycopy(abyte0, 0, abyte1, 0, i);
        System.arraycopy(seeds, 0, abyte1, i, 16 - i);
        byte byte0 = (byte)(word0 & 0xFF);
        byte byte1 = (byte)(word0 >> 8 & 0xFF);
        for (int j = 0; j < 16; j += 2) {
            int n = j;
            abyte1[n] = (byte)(abyte1[n] ^ byte0);
            int n2 = j + 1;
            abyte1[n2] = (byte)(abyte1[n2] ^ byte1);
        }
        for (int k = 0; k < 16; ++k) {
            abyte1[k] = (byte)(abyte1[k] << 2 | abyte1[k] >> 6 & 3);
        }
        return abyte1;
    }

    public static void writeRecord(int i, byte[] abyte0, int j, int k, byte[] abyte1) {
        int l = i + j + k & 0xF;
        for (int i1 = 0; i1 < k - j; ++i1) {
            byte byte0 = (byte)(abyte0[i1 + i + j] ^ abyte1[l]);
            abyte0[i1 + i + j] = byte0 = (byte)(byte0 >> 3 & 0x1F | byte0 << 5);
            l = l + 1 & 0xF;
        }
    }

    public static void readRecord(int i, byte[] abyte0, int j, int k, byte[] abyte1) {
        int l = i + j + k & 0xF;
        for (int i1 = 0; i1 < k - j; ++i1) {
            byte byte0 = abyte0[i1 + i + j];
            byte0 = (byte)(byte0 << 3 | byte0 >> 5 & 7);
            abyte0[i1 + i + j] = (byte)(byte0 ^ abyte1[l]);
            l = l + 1 & 0xF;
        }
    }

    public static void encrypt(byte[] abyte0, FilePassRecord filepassrecord) {
        short word1;
        byte[] abyte1 = PWDUtils.getKeySequence(filepassrecord.getPassword().getBytes(), filepassrecord.getKey());
        for (int i = 0; i < abyte0.length; i += 4 + word1) {
            short word0 = LittleEndian.getShort(abyte0, i + 0);
            word1 = LittleEndian.getShort(abyte0, i + 2);
            if (word0 == 133) {
                PWDUtils.writeRecord(i + 4, abyte0, 4, word1, abyte1);
                continue;
            }
            if (word0 == 2057 || word0 == 47 || word0 == 225) continue;
            PWDUtils.writeRecord(i + 4, abyte0, 0, word1, abyte1);
        }
    }
}

