/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.usermodel;

import com.fr.third.org.apache.poi.hssf.usermodel.FontDetails;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class StaticFontMetrics {
    private static Properties fontMetricsProps;
    private static Map fontDetailsMap;

    StaticFontMetrics() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FontDetails getFontDetails(Font font) {
        block18: {
            if (fontMetricsProps == null) {
                InputStream metricsIn = null;
                try {
                    try {
                        fontMetricsProps = new Properties();
                        String propFileName = null;
                        try {
                            propFileName = System.getProperty("font.metrics.filename");
                        }
                        catch (SecurityException e) {
                            // empty catch block
                        }
                        if (propFileName != null) {
                            File file = new File(propFileName);
                            if (!file.exists()) {
                                throw new FileNotFoundException("font_metrics.properties not found at path " + file.getAbsolutePath());
                            }
                            metricsIn = new FileInputStream(file);
                        } else {
                            metricsIn = FontDetails.class.getResourceAsStream("/font_metrics.properties");
                            if (metricsIn == null) {
                                throw new FileNotFoundException("font_metrics.properties not found in classpath");
                            }
                        }
                        fontMetricsProps.load(metricsIn);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not load font metrics: " + e.getMessage());
                    }
                    Object var5_6 = null;
                    if (metricsIn == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (metricsIn == null) throw throwable;
                    try {
                        metricsIn.close();
                        throw throwable;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ignore) {}
                metricsIn.close();
            }
        }
        String fontName = font.getName();
        String fontStyle = "";
        if (font.isPlain()) {
            fontStyle = fontStyle + "plain";
        }
        if (font.isBold()) {
            fontStyle = fontStyle + "bold";
        }
        if (font.isItalic()) {
            fontStyle = fontStyle + "italic";
        }
        if (fontMetricsProps.get(FontDetails.buildFontHeightProperty(fontName)) == null && fontMetricsProps.get(FontDetails.buildFontHeightProperty(fontName + "." + fontStyle)) != null) {
            fontName = fontName + "." + fontStyle;
        }
        if (fontDetailsMap.get(fontName) != null) return (FontDetails)fontDetailsMap.get(fontName);
        FontDetails fontDetails = FontDetails.create(fontName, fontMetricsProps);
        fontDetailsMap.put(fontName, fontDetails);
        return fontDetails;
    }

    static {
        fontDetailsMap = new HashMap();
    }
}

