/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.MathX;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.MultiOperandNumericFunction;

public class Sum
extends MultiOperandNumericFunction {
    private static final ValueEvalToNumericXlator DEFAULT_NUM_XLATOR = new ValueEvalToNumericXlator(3);

    protected ValueEvalToNumericXlator getXlator() {
        return DEFAULT_NUM_XLATOR;
    }

    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ErrorEval retval = null;
        double[] values = this.getNumberArray(operands, srcCellRow, srcCellCol);
        if (values == null) {
            retval = ErrorEval.VALUE_INVALID;
        } else {
            double d = values.length > 0 ? MathX.sum(values) : 0.0;
            retval = Double.isNaN(d) || Double.isInfinite(d) ? ErrorEval.NUM_ERROR : new NumberEval(d);
        }
        return retval;
    }
}

