/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public abstract class NumericFunction
implements Function {
    protected static final double E = Math.E;
    protected static final double PI = Math.PI;
    private static final ValueEvalToNumericXlator DEFAULT_NUM_XLATOR = new ValueEvalToNumericXlator(27);
    private static final int DEFAULT_MAX_NUM_OPERANDS = 30;

    protected ValueEvalToNumericXlator getXlator() {
        return DEFAULT_NUM_XLATOR;
    }

    protected ValueEval singleOperandEvaluate(Eval eval, int srcRow, short srcCol) {
        ValueEval retval;
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (ae.contains(srcRow, srcCol)) {
                retval = ErrorEval.CIRCULAR_REF_ERROR;
            } else if (ae.isRow()) {
                if (ae.containsColumn(srcCol)) {
                    ValueEval ve = ae.getValueAt(ae.getFirstRow(), srcCol);
                    ve = this.getXlator().attemptXlateToNumeric(ve);
                    retval = this.getXlator().attemptXlateToNumeric(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else if (ae.isColumn()) {
                if (ae.containsRow(srcRow)) {
                    ValueEval ve = ae.getValueAt(srcRow, ae.getFirstColumn());
                    retval = this.getXlator().attemptXlateToNumeric(ve);
                } else {
                    retval = ErrorEval.VALUE_INVALID;
                }
            } else {
                retval = ErrorEval.VALUE_INVALID;
            }
        } else {
            retval = this.getXlator().attemptXlateToNumeric((ValueEval)eval);
        }
        return retval;
    }
}

