/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.AreaPtg;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Area2DEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.BoolEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.EvaluationException;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.OperandResolver;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Countif;

final class LookupUtils {
    static /* synthetic */ Class class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval;

    LookupUtils() {
    }

    public static int resolveRowOrColIndexArg(ValueEval veRowColIndexArg) throws EvaluationException {
        StringEval se;
        String strVal;
        Double dVal;
        if (veRowColIndexArg == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (veRowColIndexArg instanceof BlankEval) {
            throw EvaluationException.invalidValue();
        }
        if (veRowColIndexArg instanceof StringEval && (dVal = OperandResolver.parseDouble(strVal = (se = (StringEval)veRowColIndexArg).getStringValue())) == null) {
            throw EvaluationException.invalidRef();
        }
        return OperandResolver.coerceValueToInt(veRowColIndexArg) - 1;
    }

    public static AreaEval resolveTableArrayArg(Eval eval) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return (AreaEval)eval;
        }
        if (eval instanceof RefEval) {
            RefEval refEval = (RefEval)eval;
            int rowIx = refEval.getRow();
            int colIx = refEval.getColumn();
            AreaPtg ap = new AreaPtg(rowIx, rowIx, colIx, colIx, false, false, false, false);
            ValueEval value = refEval.getInnerValueEval();
            return new Area2DEval(ap, new ValueEval[]{value});
        }
        throw EvaluationException.invalidValue();
    }

    public static boolean resolveRangeLookupArg(Eval rangeLookupArg, int srcCellRow, short srcCellCol) throws EvaluationException {
        if (rangeLookupArg == null) {
            return true;
        }
        ValueEval valEval = OperandResolver.getSingleValue(rangeLookupArg, srcCellRow, srcCellCol);
        if (valEval instanceof BlankEval) {
            return false;
        }
        if (valEval instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)valEval;
            return boolEval.getBooleanValue();
        }
        if (valEval instanceof StringEval) {
            String stringValue = ((StringEval)valEval).getStringValue();
            if (stringValue.length() < 1) {
                throw EvaluationException.invalidValue();
            }
            Boolean b = Countif.parseBoolean(stringValue);
            if (b != null) {
                return b;
            }
            throw EvaluationException.invalidValue();
        }
        if (valEval instanceof NumericValueEval) {
            NumericValueEval nve = (NumericValueEval)valEval;
            return 0.0 != nve.getNumberValue();
        }
        throw new RuntimeException("Unexpected eval type (" + valEval.getClass().getName() + ")");
    }

    public static int lookupIndexOfValue(ValueEval lookupValue, ValueVector vector, boolean isRangeLookup) throws EvaluationException {
        LookupValueComparer lookupComparer = LookupUtils.createLookupComparer(lookupValue);
        int result = isRangeLookup ? LookupUtils.performBinarySearch(vector, lookupComparer) : LookupUtils.lookupIndexOfExactValue(lookupComparer, vector);
        if (result < 0) {
            throw new EvaluationException(ErrorEval.NA);
        }
        return result;
    }

    private static int lookupIndexOfExactValue(LookupValueComparer lookupComparer, ValueVector vector) {
        int size = vector.getSize();
        for (int i = 0; i < size; ++i) {
            if (!lookupComparer.compareTo(vector.getItem(i)).isEqual()) continue;
            return i;
        }
        return -1;
    }

    private static int performBinarySearch(ValueVector vector, LookupValueComparer lookupComparer) {
        BinarySearchIndexes bsi = new BinarySearchIndexes(vector.getSize());
        int midIx;
        while ((midIx = bsi.getMidIx()) >= 0) {
            CompareResult cr = lookupComparer.compareTo(vector.getItem(midIx));
            if (cr.isTypeMismatch()) {
                int newMidIx = LookupUtils.handleMidValueTypeMismatch(lookupComparer, vector, bsi, midIx);
                if (newMidIx < 0) continue;
                midIx = newMidIx;
                cr = lookupComparer.compareTo(vector.getItem(midIx));
            }
            if (cr.isEqual()) {
                return LookupUtils.findLastIndexInRunOfEqualValues(lookupComparer, vector, midIx, bsi.getHighIx());
            }
            bsi.narrowSearch(midIx, cr.isLessThan());
        }
        return bsi.getLowIx();
    }

    private static int handleMidValueTypeMismatch(LookupValueComparer lookupComparer, ValueVector vector, BinarySearchIndexes bsi, int midIx) {
        CompareResult cr;
        int newMid = midIx;
        int highIx = bsi.getHighIx();
        do {
            if (++newMid == highIx) {
                bsi.narrowSearch(midIx, true);
                return -1;
            }
            cr = lookupComparer.compareTo(vector.getItem(newMid));
            if (!cr.isLessThan() || newMid != highIx - 1) continue;
            bsi.narrowSearch(midIx, true);
            return -1;
        } while (cr.isTypeMismatch());
        if (cr.isEqual()) {
            return newMid;
        }
        bsi.narrowSearch(newMid, cr.isLessThan());
        return -1;
    }

    private static int findLastIndexInRunOfEqualValues(LookupValueComparer lookupComparer, ValueVector vector, int firstFoundIndex, int maxIx) {
        for (int i = firstFoundIndex + 1; i < maxIx; ++i) {
            if (lookupComparer.compareTo(vector.getItem(i)).isEqual()) continue;
            return i - 1;
        }
        return maxIx - 1;
    }

    public static LookupValueComparer createLookupComparer(ValueEval lookupValue) throws EvaluationException {
        if (lookupValue instanceof BlankEval) {
            throw new EvaluationException(ErrorEval.NA);
        }
        if (lookupValue instanceof StringEval) {
            return new StringLookupComparer((StringEval)lookupValue);
        }
        if (lookupValue instanceof NumberEval) {
            return new NumberLookupComparer((NumberEval)lookupValue);
        }
        if (lookupValue instanceof BoolEval) {
            return new BooleanLookupComparer((BoolEval)lookupValue);
        }
        throw new IllegalArgumentException("Bad lookup value type (" + lookupValue.getClass().getName() + ")");
    }

    private static final class BinarySearchIndexes {
        private int _lowIx = -1;
        private int _highIx;

        public BinarySearchIndexes(int highIx) {
            this._highIx = highIx;
        }

        public int getMidIx() {
            int ixDiff = this._highIx - this._lowIx;
            if (ixDiff < 2) {
                return -1;
            }
            return this._lowIx + ixDiff / 2;
        }

        public int getLowIx() {
            return this._lowIx;
        }

        public int getHighIx() {
            return this._highIx;
        }

        public void narrowSearch(int midIx, boolean isLessThan) {
            if (isLessThan) {
                this._highIx = midIx;
            } else {
                this._lowIx = midIx;
            }
        }
    }

    private static final class BooleanLookupComparer
    extends LookupValueComparerBase {
        private boolean _value;

        protected BooleanLookupComparer(BoolEval be) {
            super(be);
            this._value = be.getBooleanValue();
        }

        protected CompareResult compareSameType(ValueEval other) {
            BoolEval be = (BoolEval)other;
            boolean otherVal = be.getBooleanValue();
            if (this._value == otherVal) {
                return CompareResult.EQUAL;
            }
            if (this._value) {
                return CompareResult.GREATER_THAN;
            }
            return CompareResult.LESS_THAN;
        }

        protected String getValueAsString() {
            return String.valueOf(this._value);
        }
    }

    private static final class NumberLookupComparer
    extends LookupValueComparerBase {
        private double _value;

        protected NumberLookupComparer(NumberEval ne) {
            super(ne);
            this._value = ne.getNumberValue();
        }

        protected CompareResult compareSameType(ValueEval other) {
            NumberEval ne = (NumberEval)other;
            return CompareResult.valueOf(Double.compare(this._value, ne.getNumberValue()));
        }

        protected String getValueAsString() {
            return String.valueOf(this._value);
        }
    }

    private static final class StringLookupComparer
    extends LookupValueComparerBase {
        private String _value;

        protected StringLookupComparer(StringEval se) {
            super(se);
            this._value = se.getStringValue();
        }

        protected CompareResult compareSameType(ValueEval other) {
            StringEval se = (StringEval)other;
            return CompareResult.valueOf(this._value.compareToIgnoreCase(se.getStringValue()));
        }

        protected String getValueAsString() {
            return this._value;
        }
    }

    private static abstract class LookupValueComparerBase
    implements LookupValueComparer {
        private final Class _targetClass;

        protected LookupValueComparerBase(ValueEval targetValue) {
            if (targetValue == null) {
                throw new RuntimeException("targetValue cannot be null");
            }
            this._targetClass = targetValue.getClass();
        }

        public final CompareResult compareTo(ValueEval other) {
            if (other == null) {
                throw new RuntimeException("compare to value cannot be null");
            }
            if (this._targetClass != other.getClass()) {
                return CompareResult.TYPE_MISMATCH;
            }
            if (this._targetClass == (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval == null ? (class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval = LookupUtils.class$("com.fr.third.org.apache.poi.hssf.record.formula.eval.StringEval")) : class$com$fr$third$org$apache$poi$hssf$record$formula$eval$StringEval)) {
                // empty if block
            }
            return this.compareSameType(other);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this.getValueAsString());
            sb.append("]");
            return sb.toString();
        }

        protected abstract CompareResult compareSameType(ValueEval var1);

        protected abstract String getValueAsString();
    }

    public static interface LookupValueComparer {
        public CompareResult compareTo(ValueEval var1);
    }

    public static final class CompareResult {
        private final boolean _isTypeMismatch;
        private final boolean _isLessThan;
        private final boolean _isEqual;
        private final boolean _isGreaterThan;
        public static final CompareResult TYPE_MISMATCH = new CompareResult(true, 0);
        public static final CompareResult LESS_THAN = new CompareResult(false, -1);
        public static final CompareResult EQUAL = new CompareResult(false, 0);
        public static final CompareResult GREATER_THAN = new CompareResult(false, 1);

        private CompareResult(boolean isTypeMismatch, int simpleCompareResult) {
            if (isTypeMismatch) {
                this._isTypeMismatch = true;
                this._isLessThan = false;
                this._isEqual = false;
                this._isGreaterThan = false;
            } else {
                this._isTypeMismatch = false;
                this._isLessThan = simpleCompareResult < 0;
                this._isEqual = simpleCompareResult == 0;
                this._isGreaterThan = simpleCompareResult > 0;
            }
        }

        public static final CompareResult valueOf(int simpleCompareResult) {
            if (simpleCompareResult < 0) {
                return LESS_THAN;
            }
            if (simpleCompareResult > 0) {
                return GREATER_THAN;
            }
            return EQUAL;
        }

        public boolean isTypeMismatch() {
            return this._isTypeMismatch;
        }

        public boolean isLessThan() {
            return this._isLessThan;
        }

        public boolean isEqual() {
            return this._isEqual;
        }

        public boolean isGreaterThan() {
            return this._isGreaterThan;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this.formatAsString());
            sb.append("]");
            return sb.toString();
        }

        private String formatAsString() {
            if (this._isTypeMismatch) {
                return "TYPE_MISMATCH";
            }
            if (this._isLessThan) {
                return "LESS_THAN";
            }
            if (this._isEqual) {
                return "EQUAL";
            }
            if (this._isGreaterThan) {
                return "GREATER_THAN";
            }
            return "??error??";
        }
    }

    public static interface ValueVector {
        public ValueEval getItem(int var1);

        public int getSize();
    }
}

