/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.AreaEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.RefEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.Function;

public final class Index
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        int nArgs = args.length;
        if (nArgs < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        Eval firstArg = args[0];
        if (firstArg instanceof AreaEval) {
            AreaEval reference = (AreaEval)firstArg;
            int rowIx = 0;
            int columnIx = 0;
            int areaIx = 0;
            switch (nArgs) {
                case 4: {
                    areaIx = Index.convertIndexArgToZeroBase(args[3]);
                    throw new RuntimeException("Incomplete code - don't know how to support the 'area_num' parameter yet)");
                }
                case 3: {
                    columnIx = Index.convertIndexArgToZeroBase(args[2]);
                }
                case 2: {
                    rowIx = Index.convertIndexArgToZeroBase(args[1]);
                    break;
                }
                default: {
                    return ErrorEval.VALUE_INVALID;
                }
            }
            int nColumns = reference.getLastColumn() - reference.getFirstColumn() + 1;
            int index = rowIx * nColumns + columnIx;
            return reference.getValues()[index];
        }
        throw new RuntimeException("Incomplete code - cannot handle first arg of type (" + firstArg.getClass().getName() + ")");
    }

    private static int convertIndexArgToZeroBase(Eval ev) {
        NumberEval ne;
        if (ev instanceof RefEval) {
            RefEval re = (RefEval)ev;
            ne = (NumberEval)re.getInnerValueEval();
        } else {
            ne = (NumberEval)ev;
        }
        return (int)ne.getNumberValue() - 1;
    }
}

