/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.formula.functions;

import com.fr.third.org.apache.poi.hssf.record.formula.eval.BlankEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ErrorEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.Eval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumberEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.eval.ValueEval;
import com.fr.third.org.apache.poi.hssf.record.formula.functions.NumericFunction;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import java.util.Calendar;
import java.util.Date;

public class Day
extends NumericFunction {
    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval retval = null;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
                break;
            }
            case 1: {
                ValueEval ve = this.singleOperandEvaluate(operands[0], srcCellRow, srcCellCol);
                if (ve instanceof NumericValueEval) {
                    NumericValueEval ne = (NumericValueEval)ve;
                    if (HSSFDateUtil.isValidExcelDate(ne.getNumberValue())) {
                        Date d = HSSFDateUtil.getJavaDate(ne.getNumberValue(), false);
                        Calendar c = Calendar.getInstance();
                        c.setTime(d);
                        retval = new NumberEval(c.get(5));
                        break;
                    }
                    retval = ErrorEval.NUM_ERROR;
                    break;
                }
                if (ve instanceof BlankEval) break;
                retval = ErrorEval.NUM_ERROR;
            }
        }
        return retval;
    }
}

