/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.record.aggregates;

import com.fr.third.org.apache.poi.hssf.record.CellValueRecordInterface;
import com.fr.third.org.apache.poi.hssf.record.EOFRecord;
import com.fr.third.org.apache.poi.hssf.record.FormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.Record;
import com.fr.third.org.apache.poi.hssf.record.RecordInputStream;
import com.fr.third.org.apache.poi.hssf.record.SharedFormulaRecord;
import com.fr.third.org.apache.poi.hssf.record.StringRecord;
import com.fr.third.org.apache.poi.hssf.record.UnknownRecord;
import com.fr.third.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ValueRecordsAggregate
extends Record {
    public static final short sid = -1001;
    int firstcell = -1;
    int lastcell = -1;
    CellValueRecordInterface[][] records = new CellValueRecordInterface[30][];

    public void insertCell(CellValueRecordInterface cell) {
        CellValueRecordInterface[] rowCells;
        int newSize;
        short column = cell.getColumn();
        int row = cell.getRow();
        if (row >= this.records.length) {
            CellValueRecordInterface[][] oldRecords = this.records;
            newSize = oldRecords.length * 2;
            if (newSize < row + 1) {
                newSize = row + 1;
            }
            this.records = new CellValueRecordInterface[newSize][];
            System.arraycopy(oldRecords, 0, this.records, 0, oldRecords.length);
        }
        if ((rowCells = this.records[row]) == null) {
            newSize = column + 1;
            if (newSize < 10) {
                newSize = 10;
            }
            rowCells = new CellValueRecordInterface[newSize];
            this.records[row] = rowCells;
        }
        if (column >= rowCells.length) {
            CellValueRecordInterface[] oldRowCells = rowCells;
            int newSize2 = oldRowCells.length * 2;
            if (newSize2 < column + 1) {
                newSize2 = column + 1;
            }
            rowCells = new CellValueRecordInterface[newSize2];
            System.arraycopy(oldRowCells, 0, rowCells, 0, oldRowCells.length);
            this.records[row] = rowCells;
        }
        rowCells[column] = cell;
        if (column < this.firstcell || this.firstcell == -1) {
            this.firstcell = column;
        }
        if (column > this.lastcell || this.lastcell == -1) {
            this.lastcell = column;
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        if (cell != null) {
            short column = cell.getColumn();
            int row = cell.getRow();
            if (row >= this.records.length) {
                return;
            }
            CellValueRecordInterface[] rowCells = this.records[row];
            if (rowCells == null) {
                return;
            }
            if (column >= rowCells.length) {
                return;
            }
            rowCells[column] = null;
        }
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        for (int r = 0; r < this.records.length; ++r) {
            CellValueRecordInterface[] rowCells = this.records[r];
            if (rowCells == null) continue;
            for (int c = 0; c < rowCells.length; c = (int)((short)(c + 1))) {
                if (rowCells[c] == null) continue;
                ++count;
            }
        }
        return count;
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public int construct(int offset, List records) {
        Record rec;
        int k = 0;
        FormulaRecordAggregate lastFormulaAggregate = null;
        ArrayList<Record> sharedFormulas = new ArrayList<Record>();
        for (k = offset; k < records.size(); ++k) {
            rec = (Record)records.get(k);
            if (rec instanceof SharedFormulaRecord) {
                sharedFormulas.add(rec);
            }
            if (rec instanceof EOFRecord) break;
        }
        for (k = offset; k < records.size() && ((rec = (Record)records.get(k)) instanceof StringRecord || rec.isInValueSection() || rec instanceof UnknownRecord); ++k) {
            if (rec instanceof SharedFormulaRecord) continue;
            if (rec instanceof FormulaRecord) {
                FormulaRecord formula = (FormulaRecord)rec;
                if (formula.isSharedFormula()) {
                    boolean found = false;
                    for (int i = sharedFormulas.size() - 1; i >= 0; --i) {
                        SharedFormulaRecord shrd = (SharedFormulaRecord)sharedFormulas.get(i);
                        if (!shrd.isFormulaInShared(formula)) continue;
                        shrd.convertSharedFormulaRecord(formula);
                        found = true;
                        break;
                    }
                    if (!found) {
                        ValueRecordsAggregate.handleMissingSharedFormulaRecord(formula);
                    }
                }
                lastFormulaAggregate = new FormulaRecordAggregate((FormulaRecord)rec, null);
                this.insertCell(lastFormulaAggregate);
                continue;
            }
            if (rec instanceof StringRecord) {
                lastFormulaAggregate.setStringRecord((StringRecord)rec);
                continue;
            }
            if (!rec.isValue()) continue;
            this.insertCell((CellValueRecordInterface)((Object)rec));
        }
        return k;
    }

    private static void handleMissingSharedFormulaRecord(FormulaRecord formula) {
    }

    public int serialize(int offset, byte[] data) {
        throw new RuntimeException("This method shouldnt be called. ValueRecordsAggregate.serializeCellRow() should be called from RowRecordsAggregate.");
    }

    public int getRowCellBlockSize(int startRow, int endRow) {
        CellValueRecordInterface cell;
        int row;
        MyIterator itr = new MyIterator(startRow, endRow);
        int size = 0;
        while (itr.hasNext() && (row = (cell = (CellValueRecordInterface)itr.next()).getRow()) <= endRow) {
            if (row < startRow || row > endRow) continue;
            size += ((Record)((Object)cell)).getRecordSize();
        }
        return size;
    }

    public boolean rowHasCells(int row) {
        if (row > this.records.length - 1) {
            return false;
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            return false;
        }
        for (int col = 0; col < rowCells.length; ++col) {
            if (rowCells[col] == null) continue;
            return true;
        }
        return false;
    }

    public int serializeCellRow(int row, int offset, byte[] data) {
        CellValueRecordInterface cell;
        MyIterator itr = new MyIterator(row, row);
        int pos = offset;
        while (itr.hasNext() && (cell = (CellValueRecordInterface)itr.next()).getRow() == row) {
            pos += ((Record)((Object)cell)).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void fillFields(RecordInputStream in) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1001;
    }

    public int getRecordSize() {
        int size = 0;
        Iterator irecs = this.getIterator();
        while (irecs.hasNext()) {
            size += ((Record)irecs.next()).getRecordSize();
        }
        return size;
    }

    public Iterator getIterator() {
        return new MyIterator();
    }

    public Object clone() {
        ValueRecordsAggregate rec = new ValueRecordsAggregate();
        Iterator valIter = this.getIterator();
        while (valIter.hasNext()) {
            CellValueRecordInterface val = (CellValueRecordInterface)((CellValueRecordInterface)valIter.next()).clone();
            rec.insertCell(val);
        }
        return rec;
    }

    private final class MyIterator
    implements Iterator {
        short nextColumn = (short)-1;
        int nextRow;
        int lastRow;

        public MyIterator() {
            this.nextRow = 0;
            this.lastRow = ValueRecordsAggregate.this.records.length - 1;
            this.findNext();
        }

        public MyIterator(int firstRow, int lastRow) {
            this.nextRow = firstRow;
            this.lastRow = lastRow;
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextRow <= this.lastRow;
        }

        public Object next() {
            CellValueRecordInterface o = ValueRecordsAggregate.this.records[this.nextRow][this.nextColumn];
            this.findNext();
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException("gibt's noch nicht");
        }

        private void findNext() {
            this.nextColumn = (short)(this.nextColumn + 1);
            while (this.nextRow <= this.lastRow) {
                CellValueRecordInterface[] rowCells;
                CellValueRecordInterface[] cellValueRecordInterfaceArray = rowCells = this.nextRow < ValueRecordsAggregate.this.records.length ? ValueRecordsAggregate.this.records[this.nextRow] : null;
                if (rowCells == null) {
                    this.nextColumn = 0;
                } else {
                    while (this.nextColumn < rowCells.length) {
                        if (rowCells[this.nextColumn] != null) {
                            return;
                        }
                        this.nextColumn = (short)(this.nextColumn + 1);
                    }
                    this.nextColumn = 0;
                }
                ++this.nextRow;
            }
        }
    }
}

