/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.org.apache.poi.hssf.model;

import com.fr.third.org.apache.poi.ddf.EscherBoolProperty;
import com.fr.third.org.apache.poi.ddf.EscherContainerRecord;
import com.fr.third.org.apache.poi.ddf.EscherOptRecord;
import com.fr.third.org.apache.poi.ddf.EscherRGBProperty;
import com.fr.third.org.apache.poi.ddf.EscherRecord;
import com.fr.third.org.apache.poi.ddf.EscherSimpleProperty;
import com.fr.third.org.apache.poi.ddf.EscherSpRecord;
import com.fr.third.org.apache.poi.hssf.model.CommentShape;
import com.fr.third.org.apache.poi.hssf.model.ConvertAnchor;
import com.fr.third.org.apache.poi.hssf.model.LineShape;
import com.fr.third.org.apache.poi.hssf.model.PictureShape;
import com.fr.third.org.apache.poi.hssf.model.PolygonShape;
import com.fr.third.org.apache.poi.hssf.model.SimpleFilledShape;
import com.fr.third.org.apache.poi.hssf.model.TextboxShape;
import com.fr.third.org.apache.poi.hssf.record.ObjRecord;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFAnchor;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFComment;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFPolygon;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFTextbox;

public abstract class AbstractShape {
    /*
     * WARNING - void declaration
     */
    public static AbstractShape createShape(HSSFShape hssfShape, int shapeId) {
        void var2_2;
        AbstractShape shape;
        if (hssfShape instanceof HSSFComment) {
            shape = new CommentShape((HSSFComment)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFTextbox) {
            shape = new TextboxShape((HSSFTextbox)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFPolygon) {
            shape = new PolygonShape((HSSFPolygon)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFSimpleShape) {
            HSSFSimpleShape simpleShape = (HSSFSimpleShape)hssfShape;
            switch (simpleShape.getShapeType()) {
                case 8: {
                    shape = new PictureShape(simpleShape, shapeId);
                    break;
                }
                case 1: {
                    shape = new LineShape(simpleShape, shapeId);
                    break;
                }
                case 2: 
                case 3: {
                    shape = new SimpleFilledShape(simpleShape, shapeId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Do not know how to handle this type of shape");
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown shape type");
        }
        EscherSpRecord sp = var2_2.getSpContainer().getChildById((short)-4086);
        if (hssfShape.getParent() != null) {
            sp.setFlags(sp.getFlags() | 2);
        }
        return var2_2;
    }

    protected AbstractShape() {
    }

    public abstract EscherContainerRecord getSpContainer();

    public abstract ObjRecord getObjRecord();

    protected EscherRecord createAnchor(HSSFAnchor userAnchor) {
        return ConvertAnchor.createAnchor(userAnchor);
    }

    protected int addStandardOptions(HSSFShape shape, EscherOptRecord opt) {
        opt.addEscherProperty(new EscherBoolProperty(191, 524288));
        if (shape.isNoFill()) {
            opt.addEscherProperty(new EscherBoolProperty(447, 0x110000));
        } else {
            opt.addEscherProperty(new EscherBoolProperty(447, 65536));
        }
        opt.addEscherProperty(new EscherRGBProperty(385, shape.getFillColor()));
        opt.addEscherProperty(new EscherBoolProperty(959, 524288));
        opt.addEscherProperty(new EscherRGBProperty(448, shape.getLineStyleColor()));
        int options = 5;
        if (shape.getLineWidth() != 9525) {
            opt.addEscherProperty(new EscherSimpleProperty(459, shape.getLineWidth()));
            ++options;
        }
        if (shape.getLineStyle() != 0) {
            opt.addEscherProperty(new EscherSimpleProperty(462, shape.getLineStyle()));
            opt.addEscherProperty(new EscherSimpleProperty(471, 0));
            if (shape.getLineStyle() == -1) {
                opt.addEscherProperty(new EscherBoolProperty(511, 524288));
            } else {
                opt.addEscherProperty(new EscherBoolProperty(511, 524296));
            }
            options += 3;
        }
        opt.sortProperties();
        return options;
    }
}

