/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.events;

import com.fr.third.javax.xml.namespace.QName;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.XMLStreamReader;
import com.fr.third.javax.xml.stream.events.AttributeImpl;
import com.fr.third.javax.xml.stream.events.CharacterEvent;
import com.fr.third.javax.xml.stream.events.CommentEvent;
import com.fr.third.javax.xml.stream.events.DTDEvent;
import com.fr.third.javax.xml.stream.events.DummyEvent;
import com.fr.third.javax.xml.stream.events.EndDocumentEvent;
import com.fr.third.javax.xml.stream.events.EndElementEvent;
import com.fr.third.javax.xml.stream.events.EntityDeclarationImpl;
import com.fr.third.javax.xml.stream.events.EntityReferenceEvent;
import com.fr.third.javax.xml.stream.events.NamespaceImpl;
import com.fr.third.javax.xml.stream.events.ProcessingInstructionEvent;
import com.fr.third.javax.xml.stream.events.StartDocumentEvent;
import com.fr.third.javax.xml.stream.events.StartElementEvent;
import com.fr.third.javax.xml.stream.events.XMLEvent;
import com.fr.third.javax.xml.stream.util.XMLEventAllocator;
import com.fr.third.javax.xml.stream.util.XMLEventConsumer;
import com.fr.third.javax.xml.stream.xerces.util.NamespaceContextWrapper;
import com.fr.third.javax.xml.stream.xerces.util.NamespaceSupport;

public class XMLEventAllocatorImpl
implements XMLEventAllocator {
    public XMLEvent allocate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (xMLStreamReader == null) {
            throw new XMLStreamException("Reader cannot be null");
        }
        return this.getXMLEvent(xMLStreamReader);
    }

    public void allocate(XMLStreamReader xMLStreamReader, XMLEventConsumer xMLEventConsumer) throws XMLStreamException {
        XMLEvent currentEvent = this.getXMLEvent(xMLStreamReader);
        if (currentEvent != null) {
            xMLEventConsumer.add(currentEvent);
        }
    }

    public XMLEventAllocator newInstance() {
        return new XMLEventAllocatorImpl();
    }

    XMLEvent getXMLEvent(XMLStreamReader streamReader) {
        DummyEvent event = null;
        int eventType = streamReader.getEventType();
        switch (eventType) {
            case 1: {
                StartElementEvent startElementEvent = new StartElementEvent(this.getQName(streamReader));
                this.fillAttributes(startElementEvent, streamReader);
                if (((Boolean)streamReader.getProperty("com.fr.third.javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(startElementEvent, streamReader);
                    this.setNamespaceContext(startElementEvent, streamReader);
                }
                startElementEvent.setLocation(streamReader.getLocation());
                event = startElementEvent;
                break;
            }
            case 2: {
                EndElementEvent endElementEvent = new EndElementEvent(this.getQName(streamReader));
                endElementEvent.setLocation(streamReader.getLocation());
                if (((Boolean)streamReader.getProperty("com.fr.third.javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(endElementEvent, streamReader);
                }
                event = endElementEvent;
                break;
            }
            case 3: {
                ProcessingInstructionEvent piEvent = new ProcessingInstructionEvent(streamReader.getPITarget(), streamReader.getPIData());
                piEvent.setLocation(streamReader.getLocation());
                event = piEvent;
                break;
            }
            case 4: {
                CharacterEvent cDataEvent = new CharacterEvent(streamReader.getText());
                cDataEvent.setLocation(streamReader.getLocation());
                event = cDataEvent;
                break;
            }
            case 5: {
                CommentEvent commentEvent = new CommentEvent(streamReader.getText());
                commentEvent.setLocation(streamReader.getLocation());
                event = commentEvent;
                break;
            }
            case 7: {
                StartDocumentEvent sdEvent = new StartDocumentEvent();
                sdEvent.setVersion(streamReader.getVersion());
                sdEvent.setEncoding(streamReader.getEncoding());
                if (streamReader.getCharacterEncodingScheme() != null) {
                    sdEvent.setDeclaredEncoding(true);
                } else {
                    sdEvent.setDeclaredEncoding(false);
                }
                sdEvent.setStandalone(streamReader.isStandalone());
                sdEvent.setLocation(streamReader.getLocation());
                event = sdEvent;
                break;
            }
            case 8: {
                EndDocumentEvent endDocumentEvent = new EndDocumentEvent();
                endDocumentEvent.setLocation(streamReader.getLocation());
                event = endDocumentEvent;
                break;
            }
            case 9: {
                EntityReferenceEvent entityEvent = new EntityReferenceEvent(streamReader.getLocalName(), new EntityDeclarationImpl(streamReader.getLocalName(), streamReader.getText()));
                entityEvent.setLocation(streamReader.getLocation());
                event = entityEvent;
                break;
            }
            case 10: {
                event = null;
                break;
            }
            case 11: {
                event = new DTDEvent(streamReader.getText());
                break;
            }
            case 12: {
                CharacterEvent cDataEvent = new CharacterEvent(streamReader.getText(), true);
                cDataEvent.setLocation(streamReader.getLocation());
                event = cDataEvent;
                break;
            }
            case 6: {
                CharacterEvent spaceEvent = new CharacterEvent(streamReader.getText(), false, true);
                spaceEvent.setLocation(streamReader.getLocation());
                event = spaceEvent;
            }
        }
        return event;
    }

    protected XMLEvent getNextEvent(XMLStreamReader streamReader) throws XMLStreamException {
        streamReader.next();
        return this.getXMLEvent(streamReader);
    }

    protected void fillAttributes(StartElementEvent event, XMLStreamReader xmlr) {
        int len = xmlr.getAttributeCount();
        QName qname = null;
        String prefix = null;
        String localpart = null;
        AttributeImpl attr = null;
        Object nattr = null;
        int i = 0;
        while (i < len) {
            qname = xmlr.getAttributeName(i);
            prefix = qname.getPrefix();
            localpart = qname.getLocalPart();
            attr = new AttributeImpl();
            attr.setName(qname);
            attr.setAttributeType(xmlr.getAttributeType(i));
            attr.setSpecified(xmlr.isAttributeSpecified(i));
            attr.setValue(xmlr.getAttributeValue(i));
            event.addAttribute(attr);
            ++i;
        }
    }

    protected void fillNamespaceAttributes(StartElementEvent event, XMLStreamReader xmlr) {
        int count = xmlr.getNamespaceCount();
        String uri = null;
        String prefix = null;
        NamespaceImpl attr = null;
        int i = 0;
        while (i < count) {
            uri = xmlr.getNamespaceURI(i);
            prefix = xmlr.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            attr = new NamespaceImpl(prefix, uri);
            event.addNamespaceAttribute(attr);
            ++i;
        }
    }

    protected void fillNamespaceAttributes(EndElementEvent event, XMLStreamReader xmlr) {
        int count = xmlr.getNamespaceCount();
        String uri = null;
        String prefix = null;
        NamespaceImpl attr = null;
        int i = 0;
        while (i < count) {
            uri = xmlr.getNamespaceURI(i);
            prefix = xmlr.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            attr = new NamespaceImpl(prefix, uri);
            event.addNamespace(attr);
            ++i;
        }
    }

    private void setNamespaceContext(StartElementEvent event, XMLStreamReader xmlr) {
        NamespaceContextWrapper contextWrapper = (NamespaceContextWrapper)xmlr.getNamespaceContext();
        NamespaceSupport ns = new NamespaceSupport(contextWrapper.getNamespaceContext());
        event.setNamespaceContext(new NamespaceContextWrapper(ns));
    }

    private QName getQName(XMLStreamReader xmlr) {
        String prefix = xmlr.getPrefix();
        String uri = xmlr.getNamespaceURI();
        String localpart = xmlr.getLocalName();
        QName qn = null;
        if (prefix != null && uri != null) {
            qn = new QName(uri, localpart, prefix);
        } else if (prefix == null && uri != null) {
            qn = new QName(uri, localpart);
        } else if (prefix == null && uri == null) {
            qn = new QName(localpart);
        }
        return qn;
    }
}

