/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.FileBufferManager;
import com.fr.third.javax.xml.stream.StreamBufferManager;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.CharBuffer;

public abstract class BufferManager {
    protected boolean endOfStream = false;
    static boolean DEBUG = false;

    public static BufferManager getBufferManager(XMLInputSource inputSource) throws IOException {
        InputStream stream = inputSource.getByteStream();
        if (stream instanceof FileInputStream) {
            if (DEBUG) {
                System.out.println("Using FileBufferManager");
            }
            return new FileBufferManager((FileInputStream)stream, inputSource.getEncoding());
        }
        if (DEBUG) {
            System.out.println("Using StreamBufferManager");
        }
        return new StreamBufferManager(stream, inputSource.getEncoding());
    }

    public abstract boolean getMore() throws IOException;

    public abstract CharBuffer getCharBuffer();

    public abstract boolean arrangeCapacity(int var1) throws IOException;

    public boolean endOfStream() {
        return this.endOfStream;
    }

    public abstract void close() throws IOException;

    public abstract void setEncoding(String var1) throws IOException;

    protected Object[] getEncodingName(byte[] b4, int count) {
        if (count < 2) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 255 && b1 == 254) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (count < 3) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        if (count < 4) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "UTF-8";
            return objectArray;
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(true)};
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", new Boolean(false)};
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "ISO-10646-UCS-4";
            return objectArray;
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "ISO-10646-UCS-4";
            return objectArray;
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return new Object[]{"UTF-16BE", new Boolean(true)};
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return new Object[]{"UTF-16LE", new Boolean(false)};
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "CP037";
            return objectArray;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = "UTF-8";
        return objectArray;
    }

    public static void main(String[] args) {
        try {
            File file = new File(args[0]);
            System.out.println("url parameter = " + file.toURI().toString());
            URL url = new URL(file.toURI().toString());
            XMLInputSource inputSource = new XMLInputSource(null, null, null, new FileInputStream(file), "UTF-8");
            BufferManager sb = BufferManager.getBufferManager(inputSource);
            CharBuffer cb = sb.getCharBuffer();
            int i = 0;
            while (sb.getMore()) {
                System.out.println("Loop " + i++ + " = " + sb.getCharBuffer());
            }
            System.out.println("End of stream reached = " + sb.endOfStream());
            System.out.println("Total no. of loops required = " + i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

